/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.TypeVisitor;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.FormalParameter;

public class TreeConstructorInfo
implements ConstructorInfo {
    private ConstructorDeclaration constructorTree;
    private ClassFinder classFinder;
    private ClassInfo[] parameters;
    private ClassInfo[] exceptions;
    private ClassInfo declaringClass;
    private TypeVisitor typeVisitor;

    public TreeConstructorInfo(ConstructorDeclaration f, ClassFinder cf, ClassInfo dc) {
        this.constructorTree = f;
        this.classFinder = cf;
        this.declaringClass = dc;
        this.typeVisitor = new TypeVisitor(this.classFinder, this.declaringClass);
    }

    public ConstructorDeclaration getConstructorDeclaration() {
        return this.constructorTree;
    }

    public int getModifiers() {
        return this.constructorTree.getAccessFlags();
    }

    public ClassInfo[] getParameterTypes() {
        if (this.parameters == null) {
            List ls = this.constructorTree.getParameters();
            Iterator it = ls.iterator();
            this.parameters = new ClassInfo[ls.size()];
            int i = 0;
            while (it.hasNext()) {
                FormalParameter fp = (FormalParameter)it.next();
                this.parameters[i++] = (ClassInfo)fp.getType().acceptVisitor(this.typeVisitor);
            }
        }
        return (ClassInfo[])this.parameters.clone();
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptions == null) {
            List ls = this.constructorTree.getExceptions();
            Iterator it = ls.iterator();
            this.exceptions = new ClassInfo[ls.size()];
            int i = 0;
            while (it.hasNext()) {
                this.exceptions[i++] = this.lookupClass((String)it.next(), this.declaringClass);
            }
        }
        return (ClassInfo[])this.exceptions.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TreeConstructorInfo)) {
            return false;
        }
        return this.constructorTree.equals(((TreeConstructorInfo)obj).constructorTree);
    }

    private ClassInfo lookupClass(String s, ClassInfo c) {
        try {
            if (c == null) {
                return this.classFinder.lookupClass(s, c);
            }
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }
}

