// UTF-8 ☀☁☂☃
package base;
import java.io.*;

// dynamicjava のパーサは ￥u???? は読めるがUnicodeは読めない
// そこでエスケープを行うreaderが必要になる
public class EscapeReader extends Reader {
	static final String alnum="0123456789abcdef";
	char[] buffer=new char[]{ 0,0,0,0,'u'};
	int offset=0;

	Reader isr;
	public void close()throws IOException{ isr.close(); }
	public EscapeReader(Reader r){isr=r;}

    public boolean ready() throws IOException
    { return (offset!=0) || isr.ready(); }
	public int read() throws IOException{
		if(offset!=0) return buffer[--offset];
		int c = isr.read(); if(c<0x7f) return c;
		buffer[0]= alnum.charAt((c    )&15);
		buffer[1]= alnum.charAt((c>> 4)&15);
		buffer[2]= alnum.charAt((c>> 8)&15);
		buffer[3]= alnum.charAt((c>>12)&15);
		offset=5;
		return '\\';
	}

	public int read(char[] cbuf,int off,int len) throws IOException {
		for(int i=0;i<len;++i){
			int c=read();if(c==-1)return(i!=0)?i:c;
			cbuf[off++]=(char)c;
		} return len;
	}
	public int read(char[] cbuf) throws IOException
    { return read(cbuf,0,cbuf.length); }
	public long skip(long len) throws IOException
	{ for(int i=0;i<len;++i){if(read()==-1)return(i!=0)?i:-1;} return len; }
}
