// UTF-8 ☀☁☂☃
package base;

import java.util.*;
import java.io.*;
import java.text.ParseException;

public class MyStreamTokenizer extends StreamTokenizer{
	public static final char QUOTE = '\'';
	public static final char DOUBLE_QUOTE = '"';
	//////////////////////////////////////////////////
	public ParseException nomatch(String desc){
		String t;
		switch(ttype){
		case StreamTokenizer.TT_EOF   :t="ファイル終端"; break;
		case StreamTokenizer.TT_EOL   :t="行末"; break;
		case StreamTokenizer.TT_NUMBER:t="数値 "+nval; break;
		case StreamTokenizer.TT_WORD  :t="単語 "+sval; break;
		case QUOTE  :t="文字列 "+sval; break;
		case DOUBLE_QUOTE  :t="文字列 "+sval; break;
		default       :t="文字 "+(char)ttype+" "+Integer.toHexString((char)ttype); break;
		}
		return new ParseException(desc+"を期待したが出現したのは["+t+"]だった",0);
	}

	public String readQuote(String desc)
	throws IOException,ParseException
	{
		if(ttype==QUOTE||ttype==DOUBLE_QUOTE){
			String r=sval;
			nextToken();
			return r;
		}
		throw nomatch(desc);
	}

	public String readWord(String desc)
	throws IOException,ParseException
	{
		if(ttype==TT_WORD){
			String r=sval;
			nextToken();
			return r;
		}
		if(ttype==TT_NUMBER){
			String r=Double.toString(nval);
			nextToken();
			return r;
		}
		throw nomatch(desc);
	}
	public double readNumber(String desc)
	throws IOException,ParseException
	{
		if(ttype== TT_NUMBER){
			double d = nval;
			nextToken();
			return d;
		}
		if(ttype==TT_WORD){
			String r=sval;
			nextToken();
			return Double.parseDouble(r);
		}
		throw nomatch(desc);
	}

	public int readInt(String desc)
	throws java.text.ParseException,java.io.IOException
	{ return (int)readNumber(desc); }


	public String readWordOrQuote(String desc)
	throws IOException,ParseException
	{

		if(ttype==TT_WORD
		|| ttype==QUOTE
		|| ttype==DOUBLE_QUOTE
		){
			String r=sval;
			nextToken();
			return r;
		}
		if(ttype==TT_NUMBER){
			String r=Double.toString(nval);
			nextToken();
			return r;
		}
		throw nomatch(desc);
	}

	// key=value という形式のオプションを読む。 行末や文末の直前で停止。
	public HashMap readOptions(String desc,boolean toLower)
	throws IOException,ParseException
	{
		HashMap map = new HashMap();
		String key=null;
		int mode=0;
			// 0 初期 = が出たらエラー
			// 1 キー 次は = か キーか何もなし
			// 2 =    次は値 =が出たらエラー
		while( !isEndOfStatement() ){
			if(ttype=='='){
				if(mode !=1) throw new ParseException("予期しない '='" ,0);
				mode=2;
				nextToken();
				continue;
			}
			String s = readWordOrQuote("オプション指定");
			if(mode==2){
				map.put(key,s);
				mode=0;
			}else{
				key= (toLower?s.toLowerCase():s);
				map.put(key,"1");
				mode =1;
			}
		}
		return map;
	}

	////////////////////////////////////////////////////////

	// 最初に文末や不要な改行を読み飛ばす
	public void skipToStartOfStatement()
	throws IOException,ParseException
	{
		for(;;){
			// BYTE ORDER MARK
			if( 0xfffc==(char)ttype
			|| (ttype==TT_WORD && sval.charAt(0)==0xfeff)
			){
				nextToken();
				continue;
			}
			if(ttype==TT_EOL|| ttype==';'){
				nextToken();
				 continue;
			}
			break;
		}
	}

	// 文末かどうか
	public boolean isEndOfStatement()
	throws IOException
	{ return ttype==';' || ttype==TT_EOL || ttype==TT_EOF; }

	// エラー時に文末まで読み飛ばす
	public void skipToEndOfStatement()
	throws IOException
	{
		// 行末または;まで読み飛ばす
		while(ttype!=';'&& ttype!=TT_EOL && ttype!=TT_EOF ) nextToken();
	}

	////////////////////////////////////////////////////////

	public String fname;
	public MyStreamTokenizer(Reader r,String fname,boolean doParseNumbers)
	throws IOException
	{ this(r,fname,doParseNumbers,false);}

	public MyStreamTokenizer(Reader r,String fname
		,boolean doParseNumbers
		,boolean doSkipEOL
	)
	throws IOException
	{
		super(r);
		this.fname=fname;

		resetSyntax();
		whitespaceChars(' ', ' ');
		whitespaceChars('\t', '\t');
		whitespaceChars('\n', '\n');
		whitespaceChars('\r', '\r');
		quoteChar(QUOTE);
		quoteChar(DOUBLE_QUOTE);
		slashStarComments(true);
		slashSlashComments(true);
		if(!doSkipEOL) eolIsSignificant(true);
		ordinaryChar('=') ;

		wordChars('0', '9');
		wordChars('a', 'z');
		wordChars('A', 'Z');
		wordChars('_', '_');

		if(doParseNumbers){
			parseNumbers();
		}else{
			wordChars('-', '-');
		}

		// 最初の単語
		nextToken();

		// 文字コード識別用BOMをスキップ
		if(ttype==TT_WORD
		&& sval.length()==1
		&& sval.charAt(0)==0xfeff
		) nextToken();
	}
	public String errorString(ParseException e){
		return fname+" "+lineno()+"行: "+e.getMessage();
	}
}
