// UTF-8 ☀☁☂☃
/*
	・アプリケーションの主要機能を持つ
	・バッファ一覧のツリーのルート
*/

package bluntirc;

import irc.*;
import base.*;
import gui.*;
import bluntirc.djava.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.logging.*;

class DelayProc{
	long time;
	Runnable method;
};

class ScreenLogHandler extends Handler{
    private boolean doneHeader;
    public ScreenLogHandler(){ configure(); }

    Level getLevelProperty(String val, Level defaultValue){
		try { if(val != null) return Level.parse(val.trim());
		}catch (Exception ex){}
		return defaultValue;
    }
    Filter getFilterProperty(String val, Filter defaultValue){
		try{ if(val != null) return (Filter) ClassLoader.getSystemClassLoader().loadClass(val).newInstance();
	    } catch (Exception ex) {}
		return defaultValue;
    }
    Formatter getFormatterProperty(String val, Formatter defaultValue) {
		try { if (val != null) return (Formatter) ClassLoader.getSystemClassLoader().loadClass(val).newInstance();
		} catch (Exception ex) {}
		return defaultValue;
    }
    String getStringProperty(String val, String defaultValue){
		if(val == null) return defaultValue;
		return val.trim();
    }

	private void configure(){
		LogManager manager = LogManager.getLogManager();
		String cname = ScreenLogHandler.class.getName();
		Level lv = getLevelProperty(manager.getProperty(cname +".level"),null);
		if(lv!=null) setLevel(lv );
		setFilter(getFilterProperty(manager.getProperty(cname +".filter"), null));
		setFormatter(getFormatterProperty(manager.getProperty(cname +".formatter"), new SimpleFormatter() ));
		try{ setEncoding(getStringProperty(manager.getProperty(cname +".encoding"), null)); 
		}catch(Exception ex){
			try{ setEncoding(null); } catch (Exception ex2) {}
		}
    }
    public synchronized void flush() {}
	public synchronized void close() throws SecurityException {}
	public boolean isLoggable(LogRecord record)
	{ return App.isLoggable(record)?super.isLoggable(record):false; }
	public void publish(LogRecord record){
		if(!isLoggable(record)) return;
		String msg;
		String head=null;
		try {
	 	    msg = getFormatter().format(record);
			if(!doneHeader){
				head = getFormatter().getHead(this);
				doneHeader = true;
			}
		}catch (Exception ex){
			reportError(null, ex, ErrorManager.FORMAT_FAILURE);
			return;
		}
		App.publish(head,msg);
	}
}

class MyFormatter extends Formatter{
	private Calendar calendar = Calendar.getInstance();
	private final static char DATE_SEPARATOR = '/';    
    private final static char TIME_SEPARATOR = ':';

	public String format(LogRecord record) {
		StringBuffer sb=new StringBuffer();
		{
			calendar.setTimeInMillis(record.getMillis());
			int[] list= { calendar.get(Calendar.HOUR_OF_DAY),calendar.get(Calendar.MINUTE),calendar.get(Calendar.SECOND)};
			for(int i=0;i<list.length;++i){
				if(list[i]<10) sb.append( '0' );
				sb.append( Integer.toString(list[i]) );
				if(i<list.length-1)sb.append( ':' );
			}
		}
		{
			String[] list = {
				" ",record.getSourceClassName(),
				"#",record.getSourceMethodName(),
				" <",record.getLevel().getName(),
				"> ",record.getMessage(),"\n"
			};
			for(int i=0;i<list.length;++i) if(list[i]!=null) sb.append( list[i] );
		}
		Object[] o = record.getParameters();
		if(o!=null){
			for(int i=0;i<o.length;++i){
				if(o[i]==null) o[i]="(null)";
				sb.append( "\tparam["+i+"] ");
				sb.append( o[i].toString() );
				sb.append( "\n");
			}
		}
		Throwable t = record.getThrown();
		int ti = 0;
		while(t!=null){
			sb.append("例外["+(ti++)+"]");
			sb.append(t.toString().replace('\n','\t'));
			sb.append('\n');
			StackTraceElement[] st = t.getStackTrace();
			if(st!=null){
				for(int i=0;i<st.length;++i){
					if(st[i]==null) continue;
					sb.append("\tstack[");
					sb.append( Integer.toString(st.length-i-1) );
					sb.append("] ");
					sb.append(st[i].getClassName());
					sb.append('#');
					sb.append(st[i].getMethodName());
					if(st[i].isNativeMethod()){
						sb.append(" (native method)");
					}else if( st[i].getFileName()!=null
					||  st[i].getLineNumber()>=0
					){
						sb.append(" (");
						sb.append( st[i].getFileName()  );
						sb.append(':');
						sb.append( Integer.toString(st[i].getLineNumber()) );
						sb.append(')');
					}
					sb.append('\n');
				}
			}
			t=t.getCause();
			if(t!=null) sb.append("<Cause> ");
		}
		return sb.toString();
	}
}

public class App
extends ConnTreeNode
{
	public static java.util.logging.Logger root_logger = java.util.logging.Logger.getLogger("");
	public static FileHandler      log_file_handler;
	public static ScreenLogHandler log_screen_handler;
	static{
		try{
			root_logger.setLevel(Level.FINEST);
			root_logger.setFilter(null);
			{
				Handler[] hs=root_logger.getHandlers();
				for(int i=0;i<hs.length;++i) hs[i].setFormatter(new MyFormatter());
			}
			{
				log_file_handler = new FileHandler("BluntIRC-debug.log",false);
				log_file_handler.setEncoding("UTF-8");
				log_file_handler.setFormatter(new MyFormatter());
				root_logger.addHandler(log_file_handler);
			}
			{
				log_screen_handler = new ScreenLogHandler();
				log_screen_handler.setEncoding("UTF-8");
				log_screen_handler.setFormatter(new MyFormatter());
				root_logger.addHandler(log_screen_handler);
			}
			Handler[] hs=root_logger.getHandlers();
			for(int i=0;i<hs.length;++i) hs[i].setLevel(Level.INFO);
		}catch( IOException e ){ e.printStackTrace(); }
	}

	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluntirc.app");
	static{ logger.setLevel(null); }

	public static String config_AppName ="BluntIRC";
	public static String IniFileName="hash.ini";
	public String GetName(){return config_AppName;}

	// 主要な部品
	public static ImageIcon icon_app;
	public static base.Logger connection_logger= new base.Logger(){ public void Log(String s){ App.Log(s);} };
	public static OSDependence os_dependence = new OSDependence();
	public static base.SelectorRun selector;
	public static ConnectionListener conn_hook = new ConnectionListener();
	public static PrintFormatMacroManager pfm_manager = new PrintFormatMacroManager();
	public static StyleManager style_manager = new StyleManager();
	public static MenuConf menu_conf = new MenuConf();
	public static ActionManager action_manager = new ActionManager();
	public static HookManager hook_manager = new HookManager();
	public static ScriptManagerCompiled compiled_scripts = new ScriptManagerCompiled();
	public static BufferList buf_list = new BufferList();
	public static buffer.LogDocument console_doc;
	public static DelayLog delay_log = new DelayLog();
	public static LinkedList delay_proc_list = new LinkedList();


	// ウィンドウ
	public static MainWindow main_window;
	public static ScriptManagerWindow script_manager;
	public static AllLogWindow log_all;
//	public static JobManager job_view;


	// 外部からアプリケーションのオブジェクトを取得できるようにする
	private static App application;
	public  static App getApp(){return application;}
	public static PropertyManager root_property;

	//////////////////////////////////////////////////////////////
	// 作成と破棄

	public static void main(String[] args) {
		// バージョンとカレントディレクトリを表示する
		logger.info(App.config_AppName+" build "+bdate.BuildDate.getVersion());
		logger.info("CWD is "+ (new java.io.File("nonexistent")).getAbsoluteFile().getParent() );
		// 各モジュールの初期化
		bluntirc.djava.ScriptManagerWindow.loadDummyScript();
		base.Util.AppClassLoader = App.class.getClassLoader();
		try{
			base.ConvertChar.Setup();
		}catch(Throwable e){
			logger.log(Level.SEVERE,"base.ConvertChar.Setup failed.",e);
			return;
		}
		irc.IRCMessageReader.init();


		// InetAddress のキャッシュの有効時間を変更する
		try{
			java.security.Security.setProperty("networkaddress.cache.ttl","0");
			java.security.Security.setProperty("networkaddress.cache.negative.ttl","0");
		}catch(Throwable e){
			logger.log(Level.SEVERE,"cant set networkaddress.cache Property",e);
			return;
		}

		javax.swing.SwingUtilities.invokeLater(
			new Runnable(){public void run(){
				icon_app = Util.GetImageIconFromJAR("images/app.gif");
				// 表示設定ファイルを読む
				if(! App.style_manager.load("Style.conf" ) ) return;
				if(! App.pfm_manager.load("PrintFormat.conf" ) ) return;
				console_doc=new buffer.LogDocument(App.style_manager);
				new App().init(); 
			}}
		);
		// セレクタの初期化
		try{
			App.selector = new base.SelectorRun();
			App.selector.loop();
			logger.fine("socket selector closed.");
		}catch(Throwable e){
			logger.log(Level.SEVERE,"selectorの駆動に失敗",e);
		}
		log_file_handler.setLevel(Level.FINEST);
		log_screen_handler.setLevel(Level.FINEST);
		logger.log(Level.INFO,"main終了処理開始");
		try{
			javax.swing.SwingUtilities.invokeAndWait(new Runnable(){public void run(){
				// 接続ツリーを消す
				App.getApp().removeChildAll();
				// ログ出力の終了
				App.delay_log.flushAll();
				// アプリケーションの終了
			}});
		}catch(Throwable e){
			logger.log(Level.SEVERE,"main終了処理失敗",e);
		}
		logger.log(Level.INFO,"System.runFinalization");
		System.runFinalization();
		logger.log(Level.INFO,"System.exit");
		System.exit(0);
	}
	public synchronized void MyWait(long t){ try{ wait(t);}catch(InterruptedException e){} }

	public App(){ super(console_doc); }

	// 初期化と終了の間AWTスレッドを占有するわけにもいかないので、
	// Timerにステートマシンを仕込んで細切れに実行する
	private static javax.swing.Timer timer;
	private static volatile int timerState =0;
	public void init(){
		while(App.selector==null){
			MyWait(1000);
		}
		try{
			application=this; 
			setDefaultProperty();
			root_property = property;

			// BluntIRC.iniを読んでレイアウト設定だけを見る
			PropertyManager.preloadIniFile(getApp(),IniFileName);

			// アクションの登録
			action.BaseActions.entry();
			// メニューの読み込み
			menu_conf.load();

			// ウィンドウの作成
			// 全てのメッセージ
			log_all =new  AllLogWindow( !App.root_property.getBoolean("AlloLogInMain",false) );
			log_all.setSize(400,300);

			main_window = new MainWindow();
			script_manager = new ScriptManagerWindow();
			// job_view = new JobManager(this);

			WindowPos.setWindowsPosToCenter(main_window);
			WindowPos.setWindowsPosToCenter(script_manager);
			WindowPos.setWindowsPosToCenter(log_all);
	//		WindowPos.setWindowsPosToCenter(job_view);

			PropertyManager.load(getApp(),IniFileName);
			setDefaultProperty();

			App.buf_list.sortByOrder();
			App.buf_list.select(root_property.getInt("buf_list_last_select",0));
			App.main_window.reloadBGInfoAll();

			// スクリプト
			for(Iterator it=root_property.getList("Scripts").iterator();it.hasNext();)
			{ script_manager.loadInfo( PropertyManager.StringValue(it.next())); }
			compiled_scripts.setup();


			// selectの開始

			os_dependence.setLF(root_property.setDefaultString( 
				"LookAndFeel"
				,UIManager.getSystemLookAndFeelClassName()
			));

			// プロパティを読んでウィンドウ位置を再現する
			WindowPos.loadWindowPos(main_window,"WindowBounds_Main");
			WindowPos.loadWindowPos(script_manager,"WindowBounds_Scripts");
			WindowPos.loadWindowPos(log_all,"WindowBounds_AllLog");
	//		WindowPos.loadWindowPos(job_view,"WindowBounds_JobManager");

			// スプリッタ位置を再現する
			WindowPos.loadSplitterPos("ChannelAndUserSplitter",main_window.ChannelAndUserSplitter);
			WindowPos.loadSplitterPos("LRSplitter",main_window.LRSplitter);
			WindowPos.loadSplitterPos("AllLogSplitter",main_window.AllLogSplitter);
			WindowPos.loadTableColPos(main_window.user_view.table,"UserViewColmnWidth");

			if(null== root_property.get("WindowBounds_AllLog"))
			{  log_all.show(); }

			// 初回のみ、スプリッタの位置を調整する
			if( null== root_property.get("ChannelAndUserSplitter") ){
				int w;
				if(App.root_property.getBoolean("TopTree",false)){
					w = (int) (main_window.buflist_scroll.getPreferredSize().getWidth());
				}else{
					w = (int) (main_window.ChannelAndUserSplitter.getWidth()-main_window.buflist_scroll.getPreferredSize().getWidth());
				}
				try{
					main_window.ChannelAndUserSplitter.setDividerLocation( w );
				}catch(Throwable e){
					App.Log("neatSplitter fail ChannelAndUserSplitter="+w);
					main_window.ChannelAndUserSplitter.setDividerLocation( -1 );
				}
			/*
				int loc = LRSplitter.getDividerLocation();
				int right_width = LRSplitter.getRightComponent().getMinimumSize().width;
				int left_width  = LRSplitter.getLeftComponent() .getMinimumSize().width;
				int width = LRSplitter.getWidth();
				if(loc>width)loc=width;
				if(App.root_property.getBoolean("RightTree",false)){
					if(loc < left_width) loc = left_width;
				}else{
					if((width-loc) < right_width) loc = width-right_width;
				}
				LRSplitter.setDividerLocation(loc);
			*/
			}

			App.main_window.setVisible(true);
			App.main_window.repaint();

			// タイマの開始
			timer = new javax.swing.Timer(100,new ActionListener(){
			    public void actionPerformed(ActionEvent evt){
					try{
						switch(timerState){
						case 0:
							//repaintが反映された後にLFの詳細を直す必要がある
							os_dependence.setLF(root_property.setDefaultString( 
								"LookAndFeel"
								,UIManager.getSystemLookAndFeelClassName()
							));

							// 起動時に接続する？
							for(Iterator it=getChilds();it.hasNext();){
								Object o=it.next();
								if(o instanceof CTN_Conn) ((CTN_Conn)o).onLoad();
							}

						((javax.swing.Timer)evt.getSource()).setDelay(1000);
						timerState=100;break;case 100: // timer
						//	App.selector.timer();
							hook_manager.callTimer();

							// PONG送信
							for(Iterator it=getChilds();it.hasNext();){
								Object o=it.next();
								if(o instanceof CTN_Conn) ((CTN_Conn)o).onTimer();
							}
							App.delay_log.onTimer();

							// DelayProcを処理する
							long now = System.currentTimeMillis();
							while(! delay_proc_list.isEmpty()){
								DelayProc dp = (DelayProc)delay_proc_list.getFirst();
								if(dp.time>now) break;
								delay_proc_list.removeFirst();
								javax.swing.SwingUtilities.invokeLater(dp.method);
							}

						break;case 1000: // 終了動作開始
						timerState=1010;break;case 1010: // 終了時の待機
							break;
						}
					}catch(Throwable e){
						logger.log(Level.SEVERE,"timerState="+timerState,e);
					}
			    }
			});
			timer.start();
		}catch(Throwable e){
			logger.log(Level.SEVERE,"init",e);
		}
	}

	public void AppExit(String reason){
		/*
			実行中にjarファイルを書き換えるとクラスローダまわりでうまく動作しなくなるのに
			jarファイルをロックしてくれないのって難儀やなぁ
		*/
		try{
			timer.stop();
		}catch(Throwable e){ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// スクリプトの状況をプロパティに保存する
			root_property.set("Scripts",script_manager.getScriptInfo());
		}catch(Throwable e)
		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// スプリッタとテーブルの区切り位置
			WindowPos.saveTableColPos(main_window.user_view.table,"UserViewColmnWidth");
			WindowPos.saveSplitterPos("ChannelAndUserSplitter",main_window.ChannelAndUserSplitter);
			WindowPos.saveSplitterPos("LRSplitter",main_window.LRSplitter);
			WindowPos.saveSplitterPos("AllLogSplitter",main_window.AllLogSplitter);
		}catch(Throwable e)
		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// ウィンドウ位置を保存
			WindowPos.saveWindowPos(main_window,"WindowBounds_Main");
			WindowPos.saveWindowPos(script_manager,"WindowBounds_Scripts");
			WindowPos.saveWindowPos(log_all,"WindowBounds_AllLog");
	//		WindowPos.saveWindowPos(job_view,"WindowBounds_JobManager");
		}catch(Throwable e)
		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			App.buf_list.saveOrder();
			root_property.set("buf_list_last_select",""+App.buf_list.getSelectedIndex() );
		}catch(Throwable e)
		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// スクリプトの停止
			script_manager.exit();
		}catch(Throwable e)
		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			compiled_scripts.unloadAll();
		}catch(Throwable e)		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// プロパティを保存する
			PropertyManager.save(getApp(),IniFileName);
		}catch(Throwable e)		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// 接続を切る
			disconnectAll();
		}catch(Throwable e)		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			System.runFinalization();
		}catch(Throwable e)		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// ウィンドウを隠す
			log_all.hide();
			main_window.hide();
			script_manager.hide();
			// job_view.hide();
		}catch(Throwable e)		{ logger.log(Level.SEVERE,"AppExit reason="+reason,e); }

		try{
			// セレクタを閉じる
			logger.info("AppExit reason="+reason);
			App.selector.exit_flag = true;
			logger.info("close socket selector ...");
		}catch(Throwable e){	logger.log(Level.SEVERE,"AppExit reason="+reason,e);	}
	}

	///////////////////////////////////////////////////////////////////
	// implements ConnTreeNode

	public boolean isApp (){ return true;}
	public String GetCaption(){ return App.getApp().GetName(); }

	public String getPopupName(){ return "popup-app";}
	public int getListLevel(){ return 0;}
	public String getTitle(){ return App.config_AppName +" - ";}

	public boolean SendFromUserInput(String a,int type){return false;}

	public void disconnectAll(){
		Vector v =new Vector();
		for(Iterator it=child.iterator();it.hasNext();) v.add( it.next() );
		for(int i=0;i<v.size();++i){
			ConnTreeNode o = (ConnTreeNode)v.get(i);
			if(o instanceof CTN_Conn) ((CTN_Conn)o).disconnect();
		}
	}
/*
	public ConnTreeNode FindConnectionNode(String name){
	}
*/
	public java.util.List getCreateParam(){
		LinkedList l=new LinkedList();
		l.add( GetCaption() );
		return l;
	}
	public static ConnTreeNode createNode(ConnTreeNode parent,java.util.List param){
		return getApp();
	}
	public void PreRemove(){ /* nothing to do */ }

	////////////////////////////////////////////////////////////
	// プロパティと変数の対応
	public Object getPropertyExtra(){ return this; }
	public void onHashSave(){}
	public void onHashLoad(){}

	public void onPropertyChanged(String name,Object value){
		if(name.equals("LogSweepMax")){
			buffer.LogDocument.config_LogSweepMax =PropertyManager.IntValue(value);
			if(buffer.LogDocument.config_LogSweepMax<1)buffer.LogDocument.config_LogSweepMax=1;
		}
		if(name.equals("LookAndFeel")){
			os_dependence.setLF((String)value);
		}
		if(name.equals("ConvertChar/BaseDecodeMode")){
			ConvertChar.setBaseDecodeMode(PropertyManager.IntValue(value));
		}
	}

	public void setDefaultProperty(){
		property.setDefaultObject("ConvertChar",new HashMap());
		property.setDefaultObject("DelayLog",new HashMap());
		property.setDefaultInt("ConvertChar/BaseDecodeMode",1);

		property.setDefaultBoolean("ActivateBufferOnCreate",true);
		property.setDefaultBoolean("LogCRLF",true);
		property.setDefaultBoolean("RightTree",true);
		property.setDefaultBoolean("TopTree",true);
		property.setDefaultBoolean("AlloLogInMain",false);
		property.setDefaultBoolean("alllog_top",false);
		property.setDefaultBoolean("HorizontalLayout",true);
		property.setDefaultString("LogFileEncoding","UTF-8");
		property.setDefaultString("CommandSlash","/");
		property.setDefaultString("LogSweepMax","2000");

		property.setDefaultString("TextEditorPath","notepad.exe");
		property.setDefaultString("FolderViewerPath","cmd.exe /C start");
		property.setDefaultString("BrowserName","cmd.exe /C start");
	}

	//////////////////////////////////////////////////////////////////////////
	// 選択状態の取得

	// 選択中のノードとそれに関係したノードを返す
	public static ConnTreeNode getSelected(){ return buf_list==null?null:buf_list.getSelected(); }
	public static CTN_Conn getSelectedConn(){ return (buf_list==null)? null : buf_list.getConn(); }
	public static CTN_Chan getSelectedChannel(){ return (buf_list==null)? null : buf_list.getChannel(); }
	public static CTN_Priv getSelectedPriv(){ return (buf_list==null)? null : buf_list.getPrivNode(); }

	// ノードの選択
	public static void selectTreeView(ConnTreeNode node)
		{ buf_list.select(node); }

	// ノードの再描画
	public static void redrawTreeView(ConnTreeNode node)
		{ buf_list.redrawItem(node); }

	// prefferdSizeの再評価 ノードの増減や編集の際に呼ぶ必要がある
	public static void updateBufferListItem(ConnTreeNode node)
		{ buf_list.notifySizeChange(); }

	// ノードが選択された際に主ウィンドウの表示を更新する
	String lastTitle=null;
	public void updateTopic(){
		ConnTreeNode c = buf_list.getSelected();
		if(c==null) return;
		String t=c.getTitle();
		if(!t.equals(lastTitle)) App.main_window.setTitle(lastTitle=t);
		App.main_window.labelBufferInfo.setText(c.getBufferInfo());
		App.main_window.log_view.setDocument( c.getLogDocument() );
		App.main_window.user_view.setDocument(c,c.getUserList());
	}


	//////////////////////////////////////////////////////////////////////////
	// その他

	// バッファにtextを追加する
	public static void Log(String text){
		if(text==null || text.length()==0) return;
		App app= getApp();
		if(app==null || app.console_doc==null) return;
		for(int i=0;i<text.length();++i){
			int lf = text.indexOf('\n',i);
			if(lf==-1) lf=text.length();
			if(lf>i){
				String s=text.substring(i,lf);
				i=lf;
				// BluntIRC バッファと すべてのメッセージに出力する
				app.console_doc.addText(App.main_window,s);
				if( app.log_all!=null 
				&&  app.log_all.doc !=null
				){
					app.log_all.doc.addText(App.main_window,s);
				}
			}
		}
	}
	public static boolean isLoggable(LogRecord record){
		App app= getApp();
		if(app==null || app.console_doc==null || timerState >=1000 ) return false;
		return true;
	}
	public static void publish(String head,String msg){
		if(head!=null) App.Log(head);
		App.Log(msg);
	}


	/////////////////////////////////////////////////////
	/*
		メニューを開くとJTextComponent からフォーカスが失われる現象の対策 
		MenuConf.java も見ること
	*/
	static Component pre_focus;
	public static void recordPreFocus(String context){
		Component c= KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
		if(c==null || (c instanceof JRootPane) ) return;
		pre_focus = c;
	}
	public static Object getFocusComponent(){
		Component c= KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
		if(c instanceof JRootPane) c = pre_focus;
		return c;
	}

	/////////////////////////
	
	public static void addDelayProc(int second,Runnable method){
		DelayProc dp = new DelayProc();
		dp.time = System.currentTimeMillis()+ second*1000;
		dp.method=method;
		int i=0;
		for(Iterator it = delay_proc_list.iterator();it.hasNext();){
			DelayProc item=(DelayProc)it.next();
			if(dp.time < item.time ) break;
			++i;
		}
		delay_proc_list.add(i,dp);
	}

}
