package bluntirc;
import irc.*;
import base.*;
import java.util.*;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.ImageIcon;

public class CTN_Conn extends ConnTreeNode{
	public String getName(){ return property.getString("Name"); }
	public String GetCaption(){ return property.getString("Name"); }
	public String getTitle(){ return property.getString("Name"); }
	////////////////////////////////////////////////////////////
	public IRCConnection conn;
	public CTN_Conn getConnNode(){return this;}
	////////////////////////////////////////////////////////////
	static ImageIcon icon_conn  = Util.GetImageIconFromJAR("images/conn1.gif");
	static ImageIcon icon_connD = Util.GetImageIconFromJAR("images/conn2.gif");
	public ImageIcon getImageIcon(){ return conn.isConnected() ? icon_conn : icon_connD; }
	////////////////////////////////////////////////////////////
	public int getListLevel(){ return 1;}
	public String getPopupName(){ return "popup-conn";}

	public void OnDoubleClick(MouseEvent e)
	{ if(!conn.isConnected()) conn.Connect(); }

	public void cmd_list(){
		java.util.Vector v= new java.util.Vector();
		v.add(property.setDefaultString( "ListDialog_Command","LIST"));
		conn.SendToServer(v);
	}

	int nick_try_count;
	public String getNickName(boolean isFirst){
		String nick = property.getString("Nick");
		if(isFirst){
			nick_try_count=0;
			return nick;
		}
		++nick_try_count;
		if(nick_try_count>=100) nick_try_count=0;
		int end = nick.length();
		if(end>7)end=7;
		String nn = ("0"+nick_try_count);
		return nick.substring(0,end)+nn.substring(nn.length()-2);
	}

	public boolean SendFromUserInput(String a,int type){
		if(! conn.isConnected() ) return false;
		// 行ごとに区切って、コマンドだと解釈して送信する
		for(int i=0;i<a.length(); i+=((i<a.length() && a.charAt(i) == '\n')?1:0) ){
			int start=i; while(i<a.length() && a.charAt(i) != '\n') ++i;
			if(i==start) continue;
			if(a.charAt(start)==App.root_property.getString("CommandSlash").charAt(0)) ++start;
			String cmd = a.substring(start,i);
			if(!App.action_manager.fireUserCommand(cmd)){
				conn.SendToServer(conn.encodeUserCommand(cmd));
			}
		}
		return true;
	}
	public void onLoad(){
		if(property.getBoolean("ConnectOnStartUp",false))
			conn.Connect();
	}
	public LinkedList getChannelNodes(){
		LinkedList result = new LinkedList();
		for(Iterator it=child.iterator();it.hasNext();){
			ConnTreeNode o = (ConnTreeNode)it.next();
			if( o instanceof CTN_Chan) result.add(o);
		}
		return result;
	}
	////////////////////////////////////////////////////////////
	// プロパティと変数の対応
	public Object getPropertyExtra(){ return conn;}
	public void onHashSave(){}
	public void onHashLoad(){}
	public void onPropertyChanged(String name,Object value){
		if(name.equals("TimeZone")){
			property.set("TimeZoneObject",TimeZone.getTimeZone((String)value));
		}
		if(name.equals("Name")){
			App.updateBufferListItem(this);
		}
	}
	public void setDefaultOption(){
		property.setDefaultString("UserMode"	,"+i");
		property.setDefaultString("Server"		,"");
		property.setDefaultString("Port"		,"6667");
		property.setDefaultString("Nick"		,"");
		property.setDefaultString("Password"	,"");
		property.setDefaultString("UserName"	,App.config_AppName);
		property.setDefaultString("RealName"	,App.config_AppName);
		property.setDefaultString("SoTimeout"	,"3600000");
		property.setDefaultBoolean("AutoReconnect"		,false);
		property.setDefaultBoolean("SetPlusI"			,false);
		property.setDefaultBoolean("dumpRecvLine"		,false);
		property.setDefaultBoolean("ConnectOnStartUp"	,false);
		property.setDefaultInt("ForcePongToServer",60);
	}

	int pong_timer=0;
	public void onTimer(){
		// PONG送信
		int max = property.getInt("ForcePongToServer",0);
		if(max<=0) return;
		if(pong_timer>max) pong_timer=max;
		if(--pong_timer <=0 ){
			pong_timer=max;
			if(conn.isConnected()
			&& conn.fromServer!=null
			){
				conn.SendToServer(conn.encodeString("PONG :"+ conn.fromServer.getName()),true,true);
			}
		}
	}
	////////////////////////////////////////////////////////////
	// 作成と破棄
	public java.util.List getCreateParam(){
		LinkedList l=new LinkedList();
		l.add( getName() );
		return l;
	}
	public static ConnTreeNode createNode(ConnTreeNode parent,java.util.List param){
		String name =(String)param.get(0);
		return new CTN_Conn(parent,name);
	}
	public CTN_Conn(ConnTreeNode parent,String name){
		super(null);
		setDefaultOption();
		property.setString("Name",name);
		conn= new IRCConnection(App.conn_hook,App.connection_logger);
		conn.Extra = this;
		parent.insertNodeInto(this);
	}
	public void disconnect(){
		String message = (String)property.get("QuitMessage");
		if(message==null) message="Remove Connection" ;
		conn.Disconnect( message);
	}
	public void PreRemove(){
		disconnect();
		conn.cleanup();
		conn=null;
	}
}
