package bluntirc;
import java.util.*;
import java.io.*;
import java.text.ParseException;
import irc.IRCMessage;

class PFM_COLOR extends PrintFormatMacro{
	public PFM_COLOR(Object a_extra){ super("%#;",a_extra,false); }
	public int getStyle(){return PrintFormatMacro.COLOR;}
	public String getText(IRCMessage m,Object to){return null;} 
}

public class PrintFormatMacroManager{
	public PrintFormatMacroManager(){
		init_macro_revlist();
	}
	////////////////////////////////////////////////////////
	// PrintFormatのマクロ文字列

	String[] macro_revlist;
	HashMap macro_map = new HashMap();
	private void init_macro_revlist(){
		PrintFormatMacro[] macro_ary=new PrintFormatMacro[]{
			new PrintFormatMacro("%cs",null,false){public String getText(IRCMessage m,Object to){return getShortName  (to);} },// context のshortName
			new PrintFormatMacro("%ce",null,false){public String getText(IRCMessage m,Object to){return getEscapedName(to);} },// context チャンネル名の場合はEscapedName
			new PrintFormatMacro("%c" ,null,false){public String getText(IRCMessage m,Object to){return getNormalName (to);} },// context の表示名
			new PrintFormatMacro("%fs",null,false){public String getText(IRCMessage m,Object to){return getShortName  (m.log_from);} },//送信者(from) チャンネル名の場合はEscapedName
			new PrintFormatMacro("%fe",null,false){public String getText(IRCMessage m,Object to){return getEscapedName(m.log_from);} },//送信者(from) のshortName
			new PrintFormatMacro("%f" ,null,false){public String getText(IRCMessage m,Object to){return getNormalName (m.log_from);} },//送信者(from) の表示名
			new PrintFormatMacro("%ts",null,false){public String getText(IRCMessage m,Object to){return getShortName  (m.log_to);} },//変更後またはpriv宛先 チャンネル名の場合はEscapedName
			new PrintFormatMacro("%te",null,false){public String getText(IRCMessage m,Object to){return getEscapedName(m.log_to);} },//変更後またはpriv宛先 のshortName
			new PrintFormatMacro("%t" ,null,false){public String getText(IRCMessage m,Object to){return getNormalName (m.log_to);} },//変更後またはpriv宛先 の表示名
			new PrintFormatMacro("%s" ,null,false){public String getText(IRCMessage m,Object to){return m.conn.getListener().getConnectionName(m.conn);} },//接続名
			new PrintFormatMacro("%m" ,null,true ){public String getText(IRCMessage m,Object to){return m.log_msg;} },//メッセージ
			new PrintFormatMacro("%x" ,null,false){public String getText(IRCMessage m,Object to){return m.cmd;} },//パラメータ全部
			new PrintFormatMacro("%y" ,null,false){public String getText(IRCMessage m,Object to){return m.params_str;} },//メッセージ種別
			new PrintFormatMacro("%w" ,null,false){public String getText(IRCMessage m,Object to){return null;} public int getStyle(){return PrintFormatMacro.SAVE_WRAP;}},//折り返し
			new PFM_COLOR(null),//色指定解除
		};
		Vector names = new Vector(macro_ary.length);
		for(int i=0;i<macro_ary.length;++i){
			macro_map.put(macro_ary[i].name(),macro_ary[i]);
			names.add(macro_ary[i].name());
		}
		Collections.sort(names);
		Collections.reverse(names);
		macro_revlist =new String[names.size()];
		for(int i=0;i<macro_revlist.length;++i) macro_revlist[i]=(String)names.get(i);
	}
	// マクロ文字列を読んで PrintFormat.macro に追加する
	public void readMacroString(PrintFormat pf,String a_text) throws ParseException{
		StringBuffer sb = new StringBuffer();
		ParseLoop: for(int i=0;i<a_text.length();){
			// % 以外
			int per = a_text.indexOf('%',i);
			if(per==-1) per= a_text.length();
			if(per>i){
				for(int j=i;j<per;++j) sb.append(a_text.charAt(j));
				i=per;
				continue;
			}
			// %%
			if(i==a_text.length()-1 || a_text.charAt(i+1)=='%' ){
				sb.append('%');
				i+=2;
				continue;
			}

			// マクロを検索
			for(int j=0;j<macro_revlist.length;++j){
				if(a_text.indexOf(macro_revlist[j],i)!=i) continue;
				if(sb.length()>0){ pf.macro.add(new String(sb)); sb=new StringBuffer(); }
				pf.macro.add( macro_map.get(macro_revlist[j]) );
				i+=macro_revlist[j].length();
				continue ParseLoop;
			}

			int[] ir=new int[6];
			// %#HHH;
			if(a_text.length()-i>=6
			&& a_text.charAt(i+1) =='#'
			&& a_text.charAt(i+5) ==';'
			&& -1 != (ir[0]=Character.digit(a_text.charAt(i+2),16))
			&& -1 != (ir[1]=Character.digit(a_text.charAt(i+3),16))
			&& -1 != (ir[2]=Character.digit(a_text.charAt(i+4),16))
			){
				if(sb.length()>0){ pf.macro.add(new String(sb)); sb=new StringBuffer(); }
				java.awt.Color cl = new java.awt.Color(ir[0]/(float)15,ir[1]/(float)15,ir[2]/(float)15);
				pf.macro.add(new PFM_COLOR(cl));
				i+=6;
				continue ParseLoop;
			}
			// %#HHHHHH;
			if(a_text.length()-i>=9
			&& a_text.charAt(i+1) =='#'
			&& a_text.charAt(i+8) ==';'
			&& -1 != (ir[0]=Character.digit(a_text.charAt(i+2),16))
			&& -1 != (ir[1]=Character.digit(a_text.charAt(i+3),16))
			&& -1 != (ir[2]=Character.digit(a_text.charAt(i+4),16))
			&& -1 != (ir[3]=Character.digit(a_text.charAt(i+5),16))
			&& -1 != (ir[4]=Character.digit(a_text.charAt(i+6),16))
			&& -1 != (ir[5]=Character.digit(a_text.charAt(i+7),16))
			){
				if(sb.length()>0){ pf.macro.add(new String(sb)); sb=new StringBuffer(); }
				java.awt.Color cl = new java.awt.Color(
					 (ir[0]*16+ir[1])/(float)255
					,(ir[2]*16+ir[3])/(float)255
					,(ir[4]*16+ir[5])/(float)255
				);
				pf.macro.add(new PFM_COLOR(cl));
				i+=9;
				continue ParseLoop;
			}
			throw new ParseException("マクロ文字列の"+i+"文字目に未対応のマクロ%"+a_text.charAt(i+1),i);
		}
		if(sb.length()>0){ pf.macro.add(new String(sb));}
	}
	// オプション文字列を読む
	public void readOptionString(PrintFormat pf,String a_option) throws ParseException{
		for(int i=0;i<a_option.length();++i){
			char c = a_option.charAt(i);
			switch(c){
			default: throw new ParseException("オプションの"+i+"文字目に未対応のオプション "+c,i);
			case '-': pf.NoDisp       =true; continue;
			case 'm': pf.NoCountMidoku=true; continue;
			case 'r':
				int start =++i;
				while(i<a_option.length() && Character.isDigit(a_option.charAt(i))) ++i;
				pf.RapidRate = ((i==start)?60:Integer.parseInt(a_option.substring(start,i)));
				--i;continue;
			}
		}
	}
	///////////////////////////////////////////////////////////////
	// 設定情報

	public HashMap config;
	public PrintFormat findPrintFormat(String sect,String cmd){
		if(config==null) return null;
		HashMap section=(HashMap)config.get(sect);
		if(section==null){
			App.Log("findPrintFormat: no section:"+sect);
			return null;
		}
		PrintFormat pf = (PrintFormat)section.get(cmd);
		return pf;
	}

	/////////////////////////////////////////////////////////
	// 設定を読む
	public HashMap readStream(Reader r,String fname)
	throws IOException
	{
		base.MyStreamTokenizer in =new base.MyStreamTokenizer(r,fname,true);

		HashMap result = new HashMap();
		String NowTargetName=null;
		HashMap NowTarget=null;
		boolean hasError=false;
		// 文を読む
		for(;;){
			try{
				in.skipToStartOfStatement();
				if(in.ttype==in.TT_EOF) break;

				// PrintFormat "section_name";
				if( in.ttype==in.TT_WORD && in.sval.equals("PrintFormat") ){
					in.nextToken();
					NowTargetName= in.readQuote("PrintFormatの後のセクション名");
					// セクションのハッシュを呼び出す、なければ作る
					NowTarget = (HashMap)result.get(NowTargetName);
					if(NowTarget==null)  result.put(NowTargetName,(NowTarget=new HashMap()));
					continue;
				}

				PrintFormat pf = new PrintFormat();
				readOptionString(pf,in.readQuote("行頭のオプション文字列またはPrintFormatセクション指定"));
				readMacroString (pf,in.readQuote("オプション文字列の後のマクロ文字列"));
				if(NowTarget==null) throw new ParseException("前の行までにPrintFormatセクションが指定されていない",0);

				// 文末までメッセージ番号を読む
				for(;!in.isEndOfStatement();in.nextToken()){
					switch(in.ttype){
					case base.MyStreamTokenizer.TT_WORD: 
					case base.MyStreamTokenizer.QUOTE: 
					case base.MyStreamTokenizer.DOUBLE_QUOTE:
						NowTarget.put(in.sval,pf);
						continue;
					case base.MyStreamTokenizer.TT_NUMBER:
						NowTarget.put(Integer.toString((int)in.nval),pf);
						continue;
					}
					throw in.nomatch("メッセージ種別");
				}
			}catch(java.text.ParseException e){
				hasError=true;
				App.Log(in.errorString(e));
				in.skipToEndOfStatement();
			}
		}
		return hasError? null:result;
	}
	public boolean load(String fname){
		try{
			InputStreamReader r = new InputStreamReader(base.Util.OpenFile(fname),"UTF-8");
			try{
				HashMap a =readStream(r,fname);
				if(a!=null){
					config =a;
					App.Log(fname+"を読み終わりました");
					return true;
				}
			}finally{
				r.close();
			}
		}catch(FileNotFoundException e){
			App.Log(e.getMessage());
		}catch(IOException e){
			App.Log(fname +":"+e.getMessage());
		}
		return false;
	}
}
