package bluntirc;
// UTF-8 ☀☁☂☃

import base.*;
import java.util.*;
import java.io.*;
import java.text.ParseException;
/*
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
*/

public class PropertyManager {
	ConnTreeNode context;
	public PropertyManager(ConnTreeNode c){context=c;}

	Map map = new HashMap();
	private void setMap(Map t){map=t;}

	public static Vector parsePropertyName(String name){
		Vector result=new Vector();
		if(name==null || name.length()==0) return result;
		for(int i=0;i<name.length();){
			int start=i;
			while(i<name.length() && name.charAt(i)!='/') ++i;
			result.add( name.substring(start,i));
			++i;
		}
		return result;
	}
	public Object get(String name){ return get(parsePropertyName(name)); }
	public Object get(Vector param){
		Object context = map;
		for(int i=0;i<param.size();++i){
			String v = (String)param.get(i);
			if(context instanceof Map){
				context = ((Map)context).get(v);
				continue;
			}
			if(context instanceof List){
				int index ;
				try{
					index= Integer.parseInt(v);
				}catch(Throwable e){
					App.Log(v+" リストのインデクスは数値でないといけません");
					return null;
				}
				if( index<0 || index>=((List)context).size() ){
					App.Log(v+" リストのインデクスが範囲外です");
					return null;
				}
				context = ((List)context).get(index);
				continue;
			}
			App.Log("MapもListもありません キー="+v);
			return null;
		}
		return context;
	}

	public boolean exists(Vector param){
		Object context = map;
		for(int i=0;i<param.size();++i){
			String v = (String)param.get(i);
			if(context instanceof Map){
				if(! ((Map)context).containsKey(v) ) return false;
				context = ((Map)context).get(v);
				continue;
			}
			if(context instanceof List){
				int index ;
				try{
					index= Integer.parseInt(v);
				}catch(Throwable e){
					App.Log(v+" リストのインデクスは数値でないといけません");
					return false;
				}
				if( index<0 || index>=((List)context).size() ){
					App.Log(v+" リストのインデクスが範囲外です");
					return false;
				}
				context = ((List)context).get(index);
				continue;
			}
			App.Log(v+"MapもListもありません");
			return false;
		}
		return true;
	}

	private boolean set_(String name,Object value){ return set_(parsePropertyName(name),value);}
	private boolean set_(Vector param,Object value){
		Object context = map;
		int last = param.size() -1;
		for(int i=0;i<param.size();++i){
			String v = (String)param.get(i);
			if(context instanceof Map){
				if(i==last){
					((Map)context).put(v,value);
					return true;
				}
				context = ((Map)context).get(v);
				continue;
			}
			if(context instanceof List){
				int index ;
				try{
					index= Integer.parseInt(v);
				}catch(Throwable e){
					App.Log(v+" リストのインデクスは数値でないといけません");
					return false;
				}
				if( index<0 || index>=((List)context).size() ){
					App.Log(v+" リストのインデクスが範囲外です");
					return false;
				}
				if(i==last){
					((List)context).set(index,value);
					return true;
				}
				context = ((List)context).get(index);
				continue;
			}
			App.Log(v+"MapもListもありません");
			return false;
		}
		App.Log("プロパティ '"+keyToString(param)+"'の変更はできません key=");
		return false;
	}
	public static String keyToString(Vector param){
		StringBuffer sb=new StringBuffer();
		for(int i=0;i<param.size();++i){
			if(i!=0) sb.append('/');
			String s= (String)param.get(i);
			for(int j=0;j<s.length();++j){
				char c= s.charAt(j);
				if(c=='/') c='?';
				sb.append(c);
			}
		}
		return sb.toString();
	}

	// 変更してonPropertyChangedを呼ぶ
	public void put(String name,Object value){set(name,value);}
	public void set(String name,Object value){
		if(set_( name,value) ) context.onPropertyChanged(name,value);
	}

	public void put(Vector param,Object value){set(param,value);}
	public void set(Vector param,Object value){
		if(set_( param,value) ) context.onPropertyChanged(keyToString(param),value);
	}

	public int getInt(String name){return IntValue( get(name) );}
	public int getInt(String name,int defvalue){
		try{ return IntValue(get(name));}
		catch(Throwable e){ return defvalue;}
	}
	public boolean getBoolean(String name,boolean defvalue){
		try{ return BooleanValue(get(name));}
		catch(Throwable e){ return defvalue;}
	}
	public List getList(String name)
		{ Object o = get(name); return o!=null?((List)o):new LinkedList(); }

	public String getString(String name)
		{ Object o = get(name); return o!=null?((String)o):""; }

	public String setString(String name,String value)
		{set(name,value);return value;}

	public boolean setBoolean(String name,boolean value)
		{set(name,Boolean.toString(value));return value;}

	public int setInt(String name,int value)
		{set(name,Integer.toString(value));return value;}

	public String setDefaultString(String name,String value){
		Vector param = parsePropertyName(name);
		Object o = get(param);
		if(o==null){ set(param,value); return value;}
		return StringValue( o );
	}
	public boolean setDefaultBoolean(String name,boolean value){
		Vector param = parsePropertyName(name);
		Object o = get(param);
		if(o==null){ set(param,""+value); return value;}
		return BooleanValue( o );
	}
	public int setDefaultInt(String name,int value){
		Vector param = parsePropertyName(name);
		Object o = get(param);
		if(o==null){ set(param,""+value); return value;}
		try{ return IntValue( o ); }
		catch(NumberFormatException e){ return value;}
	}
	public Object setDefaultObject(String name,Object value){
		Vector param = parsePropertyName(name);
		Object o = get(param);
		if(o==null){ set(param,value); return value;}
		return o;
	}


	public static boolean BooleanValue(Object value)
		{ return Boolean.valueOf((String)value).booleanValue(); }
	public static int IntValue(Object value)
		{return Integer.parseInt((String)value);}

	public static char CharValue(Object value)
		{ return ((String)value).charAt(0); }

	public static String StringValue(Object value)
		{ return (String)value; }

	/////////////////////////////////////////////
	public static final String eol="\n";
	public static void writeIndent(TinyWriter w,int indent)throws java.io.IOException{
		for(int i=0;i<indent;++i) w.write('\t');
	}

	//////////////////////////////////////////////
	// Map の保存と読み込み
	public static void SaveProperty(TinyWriter w,int indent,Object o) throws java.io.IOException{
		if(o instanceof String){
			w.write("String ");
			w.write(Util.qq((String)o));
			w.write(eol);
			return;
		}
		if(o instanceof List){
			w.write("List ");
			List list = (List)o;
			w.write(Integer.toString(list.size()));
			w.write(eol);
			++indent;
			for(Iterator it=list.iterator();it.hasNext();){
				writeIndent(w,indent);
				SaveProperty(w,indent,it.next());
			}
			--indent;
			return;
		}
		if(o instanceof Map){
			w.write("Map ");
			Map map = (Map)o;
			w.write(Integer.toString(map.size()));
			w.write(eol);
			++indent;
			for(Iterator it=map.entrySet().iterator();it.hasNext();){
				Map.Entry me = (Map.Entry)it.next();
				writeIndent(w,indent);
				w.write(Util.qq((String)me.getKey()));
				w.write(" ");
				SaveProperty(w,indent,me.getValue());
			}
			--indent;
			return;
		}
		w.write("null"); //o.getClass().getName());
		w.write(eol);
	}

	public static Object LoadProperty(MyStreamTokenizer in)
	throws java.text.ParseException,java.io.IOException
	{
		String type= in.readWord("プロパティの型");
		if(type.equals("null") ) return null;
		if(type.equals("String") ) return in.readQuote("文字列");
		if( type.equals("List") 
		||  type.equals("LinkedList")
		){
			List list=new LinkedList();
			int count = in.readInt("リストの要素数");
			for(int i=0;i<count;++i) list.add( LoadProperty(in));
			return list;
		}
		if( type.equals("Map") 
		||  type.equals("TreeMap") 
		){
			Map map=new HashMap();
			int count = in.readInt("マップの要素数");
			for(int i=0;i<count;++i){
				String key = in.readQuote("マップのキー");
				map.put(key,LoadProperty(in));
			}
			return map;
		}
		throw in.nomatch("プロパティの型");
	}

	///////////////////////////////////////
	// ConnTree の保存と読み込み
	static private void SaveConnTreeNode(TinyWriter w,ConnTreeNode node) throws java.io.IOException{
		// ハッシュの中にデータを置いてもらう
		node.onHashSave();

		// ノードの種類
		String type=null;
		if(node instanceof App ) type ="App";
		else if(node instanceof CTN_Conn) type ="Conn";
		else if(node instanceof CTN_Chan) type ="Chan";
		else if(node instanceof CTN_Priv) type ="Priv";
		else type = node.getClass().getName();

		// 1行目は type CreateParamCount CreateParam* childcount
		w.write( type );
		w.write(' ');
		java.util.List l = node.getCreateParam();
		w.write(Integer.toString(l.size()));
		w.write(' ');
		for(Iterator it = l.iterator();it.hasNext();){
			w.write(Util.qq((String)it.next()));
			w.write(' ');
		}
		w.write( Integer.toString(node.getChildCount()));
		w.write(eol);
		// プロパティ
		SaveProperty(w,0,node.property.map);
		// 子ノード
		for(Iterator it = node.child.iterator();it.hasNext();)
			{ SaveConnTreeNode(w,(ConnTreeNode)it.next()); }
	}
	private static void LoadConnTreeNode(MyStreamTokenizer in,ConnTreeNode parent)
	throws java.text.ParseException,java.io.IOException
	{
		String type = in.readWord("ノードの種類");

		int CreateParamCount =in.readInt("作成パラメータの要素数");
		Vector v=new Vector(CreateParamCount);
		for(int i=0;i<CreateParamCount;++i) v.add( in.readQuote("作成パラメータ"+i ));
		int child_count =in.readInt("子ノードの数");

		ConnTreeNode node;
		if(type.equals("App") 		){ node = App     .createNode(parent,v); }else
		if(type.equals("Conn")		){ node = CTN_Conn.createNode(parent,v); }else
		if(type.equals("Chan")		){ node = CTN_Chan.createNode(parent,v); }else
		if(type.equals("Priv")		){ node = CTN_Priv.createNode(parent,v); }else
		{ throw in.nomatch("ノードの種類");  }

		node.property.setMap((Map)LoadProperty(in));
		for(int i=0;i<child_count;++i){ LoadConnTreeNode(in,node); }
		node.onHashLoad();
	}

	///////////////////////////////////////
	// 設定ファイルの扱い
//	public static String TargetFile="hash.ini";
	public static String TargetFileEncode="UTF-8";

	// GUIのレイアウトに必要な情報だけを読む
	public static void preloadIniFile(ConnTreeNode root,String TargetFile){
		try{
			Reader r = new InputStreamReader(Util.OpenFile(TargetFile),TargetFileEncode);
			try{
				String fname = TargetFile;
				MyStreamTokenizer in = new MyStreamTokenizer(r,TargetFile,true,true);
				try{
					String type = in.readWord("ノードの型");
					int CreateParamCount =in.readInt("作成パラメータの要素数");
					Vector v=new Vector(CreateParamCount);
					for(int i=0;i<CreateParamCount;++i) v.add( in.readQuote("作成パラメータ"+i));
					int child_count =in.readInt("子ノードの数");
					root.property.setMap((Map)LoadProperty(in));
					return;
				}catch(java.text.ParseException e){
					App.Log(in.errorString(e));
				}
			}finally{
				r.close();
			}
		}catch(FileNotFoundException e){
			App.Log(e.getMessage());
			saveAtExit=true;
		}catch(IOException e){
			App.Log(TargetFile +":"+e.toString()+" "+e.getMessage());
		}
	}


	static boolean saveAtExit=false;
	public static void load(ConnTreeNode root,String TargetFile){
		saveAtExit=false;
		try{
			Reader r = new InputStreamReader(Util.OpenFile(TargetFile),TargetFileEncode);
			try{
				MyStreamTokenizer in = new MyStreamTokenizer(r,TargetFile,true,true);
				LoadConnTreeNode(in,root);
				App.Log(TargetFile+"を読み終わりました");
				saveAtExit=true;
				return;
			}catch(java.text.ParseException e){
				App.Log(e.getMessage());
			}finally{
				r.close();
			}
		}catch(FileNotFoundException e){
			App.Log(e.getMessage());
			saveAtExit=true;
		}catch(IOException e){
			App.Log(TargetFile +":"+e.toString()+" "+e.getMessage());
		}
	}
	public static void save(ConnTreeNode root,String TargetFile){
		if(!saveAtExit) return;
		try{
			TinyWriter w = new TinyWriter(new FileOutputStream(TargetFile),TargetFileEncode);
			try{
				w.println("// "+TargetFileEncode+"このファイルは"+TargetFileEncode+"で書かれています。");
				SaveConnTreeNode(w,root);
			}finally{
				w.close();
			}
		}catch(Exception e){
			App.logger.log(java.util.logging.Level.SEVERE,TargetFile,e);
			App.Log(TargetFile +":"+e.toString()+" "+e.getMessage());
		}
	}
	public static void resetSaveFlag(){ saveAtExit=true;}
}
