package bluntirc.djava;
import java.util.*;
import bluntirc.*;

public class HookManager{
	/////////////////////////////////////////////////
	// フック
	private LinkedList hook_list = new LinkedList();
	public void remove(ScriptItem si){ hook_list.remove(si); }
	public void add   (ScriptItem si){ hook_list.add(si); }

	// スクリプト内でのフックの追加削除に備えて複製し、イテレータを返す
	public Iterator getHookList(){
		return ((LinkedList)hook_list.clone()).iterator();
	}

	//////////////////////////////////////////////////
	// スクリプトの実行時エラーをログに出力する

	public static void write2(StringBuffer sb,String s){
		for(int i=0;i<s.length();++i){
			char c= s.charAt(i);
			if(c=='\n') c=' ';
			sb.append(c);
		}
	}

	public static void parseScriptError(String script_name,Throwable ee){
		if( ee instanceof koala.dynamicjava.interpreter.error.CatchedExceptionError ){
			koala.dynamicjava.interpreter.error.CatchedExceptionError e = (koala.dynamicjava.interpreter.error.CatchedExceptionError) ee;
			koala.dynamicjava.tree.Node node = e.getNode();
			StringBuffer sb = new StringBuffer();
			sb.append("CatchedExceptionError in ");
			sb.append( script_name );
			if(node!=null){
				sb.append( ' ');
				sb.append(node.getBeginLine()+"行"+node.getBeginColumn()+"桁～");
				sb.append(node.getEndLine()+"行"+node.getEndColumn()+"桁");
			}
			sb.append(" 例外 ");
			sb.append(e.getClass().getName());
			sb.append(" ");
			write2(sb,e.getMessage());
			App.logger.log(java.util.logging.Level.WARNING,sb.toString(),e);

			if(e.getMessage().indexOf("java.lang.IllegalAccessException")!=-1)
				App.logger.log(java.util.logging.Level.WARNING,script_name+"のアクセス先のクラスやメソッドとかがpublicじゃないかも");
			return;
		}
		if( ee instanceof koala.dynamicjava.interpreter.InterpreterException ){
			koala.dynamicjava.interpreter.InterpreterException e = (koala.dynamicjava.interpreter.InterpreterException) ee;
			koala.dynamicjava.tree.Node node = e.getNode();
			StringBuffer sb = new StringBuffer();
			sb.append( "InterpreterException in ");
			sb.append( script_name );
			if(node!=null){
				sb.append(' ');
				sb.append(node.getBeginLine()+"行"+node.getBeginColumn()+"桁～");
				sb.append(node.getEndLine()+"行"+node.getEndColumn()+"桁");
			}
			App.logger.log(java.util.logging.Level.WARNING,sb.toString(),e);
			return;
		}
		if( ee instanceof koala.dynamicjava.interpreter.error.ExecutionError ){
			koala.dynamicjava.interpreter.error.ExecutionError e = (koala.dynamicjava.interpreter.error.ExecutionError) ee;
			koala.dynamicjava.tree.Node node = e.getNode();
			StringBuffer sb = new StringBuffer();
			sb.append( "ExecutionError in ");
			sb.append( script_name );
			if(node!=null){
				sb.append( ' ');
				sb.append(node.getBeginLine()+"行"+node.getBeginColumn()+"桁～");
				sb.append(node.getEndLine()+"行"+node.getEndColumn()+"桁");
			}
			sb.append(" ");
			sb.append(e.getClass().getName());
			sb.append(" ");
			write2(sb,e.getMessage());
			App.logger.log(java.util.logging.Level.WARNING,sb.toString(),e);
			return;
		}
		if( ee instanceof NoClassDefFoundError ){
			NoClassDefFoundError e = (NoClassDefFoundError) ee;
			App.logger.log(java.util.logging.Level.WARNING,script_name+"に書かれている "+e.getMessage()
				+"が見つかりません。クラス名の前にパッケージ指定を忘れていませんか？トップレベルの変数に違うレベルからアクセスしようとしていませんか？"
			);
			return;
		}
		if( ee instanceof java.util.MissingResourceException ){
			java.util.MissingResourceException e = (java.util.MissingResourceException) ee;
			App.logger.log(java.util.logging.Level.WARNING,script_name+" MissingResourceException "+e.getMessage()+" "+e.getClassName()+" "+e.getKey(),e);
			return;
		}
		if( ee instanceof NoSuchMethodError ){
			NoSuchMethodError e = (NoSuchMethodError)ee;
			App.logger.log(java.util.logging.Level.WARNING,"parseScriptError(NoSuchMethodError) "+script_name+"に書かれているメソッド "+e.getMessage()+"が見つかりません。",e);
			return;
		}
		App.logger.log(java.util.logging.Level.WARNING,"parseScriptError: "+script_name+" "+ee+" "+ee.getMessage()+" (!)",ee);
	}

	////////////////////////////
	public void callTimer(){
		for(Iterator it=getHookList();it.hasNext();){
			ScriptItem si= (ScriptItem)it.next();
			Object plugin = si.getPlugin();
			if( plugin instanceof hook.Timer){
				try{
					((hook.Timer)plugin).timer();
				}catch(Throwable e){ 
					parseScriptError(si.getName(),e);
				}
			}
		}
	}
}
