package buffer;
import gui.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

////////////////////////////////////////////////////////
// 選択位置
// 行番号、区間、文字

class LogSelPos{
	int lineno; //論理行
	short span; //区間
	short offset; // 区間内でのオフセット
	public LogSelPos(){}
	public LogSelPos(int a,int b){span=(short)a;offset=(short)b;}
	public LogSelPos(int l){lineno=l;}
	// - だと b の方が後の位置
	public int compareTo(LogSelPos b){
		int i= lineno - b.lineno;
		if(i==0) i = span - b.span;
		if(i==0) i = offset - b.offset;
		return i;
	}
}

// 範囲
class LogSelectionRange{
	public LogSelPos start;
	public LogSelPos end;
	public final boolean isIn( LogSelPos pos)
	{ return start.compareTo(pos) <=0 &&  pos.compareTo(end) <0 ; }
	public LogSelectionRange(LogSelPos _s,LogSelPos _e){
		if( _s.compareTo(_e) <0 ){
			start =_s;
			end   =_e;
		}else{
			start =_e;
			end   =_s;
		}
	}
	// 行の中での選択範囲を示す
	public LogSelectionRange(LogSelectionRange src,int lineno,int endspan,int endoffset){
		start = ( lineno==src.start.lineno ? src.start:new LogSelPos(0,0) );
		end   = ( lineno==src.end  .lineno ? src.end  :new LogSelPos(endspan,endoffset));
	}
	public LogSelectionRange(LogSelectionRange src,int lineno,LogSelPos srcend){
		start = ( lineno==src.start.lineno ? src.start:new LogSelPos(0,0) );
		end   = ( lineno==src.end  .lineno ? src.end  :new LogSelPos(srcend.span,srcend.offset));
	}
	public boolean empty(){
		return start.lineno==end.lineno 
		&& start.span == end.span
		&& start.offset==end.offset
		;
	}
	public void clear(int lineno){
		start=new LogSelPos(lineno);
		end  =new LogSelPos(lineno);
	}
}

// 表示行
class LogLineInfo {
	short x; //開始位置
	short width; // 横幅
	short height ;
	short baseline;
	short start_span;
	short start_offset;
	short end_span;
	short end_offset;
	public LogLineInfo(int s,int o){
		super();
		start_span=(short)s;
		start_offset=(short)o;
	}
	LogSelPos getStartPos(){ return new LogSelPos(start_span,start_offset);}
	LogSelPos getEndPos  (){ return new LogSelPos(end_span,end_offset);}
//	void setStartPos(LogSelPos src){ start_span=src.span; start_offset=src.offset;}
}

////////////////////////////////////////////////////////

// 区間のサイズ
class SpanSizeDetail{
	public SpanSizeDetail(){}
	int width; // 横幅
	int Ascent ; // 複数の種類のフォントがある場合、それらのベースラインをそろえる
	int Descent; // 
	int Leading; // 
	int height ; // 
	int baseline;
}

// 行の中の区間のサイズ
class SpanMetrics {
	PackedLineReader tsi;
	int length; // 文字数
//		int getTextLength(){return length;}

	Font font;

	static Stroke normal_stroke = new BasicStroke(1);
	static Stroke  hover_stroke = new BasicStroke
	(1,BasicStroke.CAP_ROUND,BasicStroke.JOIN_ROUND,3,new float[]{2,4},1);

	static Composite normal_composite = AlphaComposite.getInstance(AlphaComposite.SRC);
	static Composite hover_composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER,0.3f);

	// use tsi.text_bulk .	char[] text;
	// use tsi.text_now_pos . int text_start;
	// use tsi.* LogSpanType type;
/*
	int calcWidth(LogDiv div,int start,int end)
	{ return getSubstringWidth(div,start,end); }
	int getSubstringWidth(LogDiv div,int start,int end,LogSpanDrawInfo lsdi)
		{ return lsdi.stringWidth(div.text,start+text_start,end+text_start); }
*/
	StyleID sid;
	public SpanMetrics(PackedLineReader tsi,StyleID sid){
		this.tsi =tsi;
		this.length =tsi.text_span_length;
		this.sid=sid;
		this.font   =sid.getFont(tsi);
	}

	String getText(){ return tsi.getSpanText();}

	// start～(end-1)の範囲の文字列を表示するのに必要な幅を計算する
	int getSubstringWidth(Object o,int start,int end){
		// o は Component か Graphics
		if( o instanceof Graphics )
			return ((Graphics)o).getFontMetrics(font).charsWidth(tsi.text_bulk ,tsi.text_offset+start,end-start);
		if( o instanceof Component )
			return ((Component)o).getFontMetrics(font).charsWidth(tsi.text_bulk ,tsi.text_offset+start,end-start);
		// デタラメを返す
		return end-start;
	}

	// 文字範囲を指定してサイズを返す
	FontMetrics lastFontMetrics=null;
	SpanSizeDetail calcSizeDetail(Object o,int start,int end){
		if(font==null) System.err.println("calcSizeDetail: no font");
		// o は Component か Graphics
		FontMetrics fm=null;
		if( o instanceof Component ) fm= ((Component)o).getFontMetrics(font);
		if( o instanceof Graphics  ) fm= ((Graphics )o).getFontMetrics(font);
		// FontMetricsを取得できなかった場合の対策
		if(fm!=null){
			lastFontMetrics=fm;
		}else if(lastFontMetrics!=null){
			fm = lastFontMetrics;
		}else{
			SpanSizeDetail lss =new SpanSizeDetail();
			lss.Ascent  = 1;
			lss.Descent = 1;
			lss.Leading = 1;
			lss.width = end-start;
			return lss;
		}
		FontInfo2 fi = sid.getBaseStyle(tsi.baseid);
		SpanSizeDetail lss =new SpanSizeDetail();
		lss.Ascent  = fm.getAscent () + ((Integer)fi.get(fi.KEY_ASCENTPLUS )).intValue();
		lss.Descent = fm.getDescent() + ((Integer)fi.get(fi.KEY_DESCENTPLUS)).intValue();
		lss.Leading = fm.getLeading() + ((Integer)fi.get(fi.KEY_LEADINGPLUS)).intValue();
	//	System.err.println(fi.getFontName()+" "+((Integer)fi.get(fi.KEY_ASCENTPLUS )).intValue());
		if(lss.Ascent <=0) lss.Ascent =1;
		if(lss.Descent<=0) lss.Descent=1;
		if(lss.Leading<=0) lss.Leading=1;
		lss.width = fm.charsWidth( tsi.text_bulk, tsi.text_offset+start ,end-start );
		return lss;
	}

	// 指定した横幅に収まる文字数を計算する
	int calcMojisu(Object c,int start,int width){
		int min= start;
		int max=length;
		while( max-min >2 ){
			int mid = (max+min)>>1;
			int w = getSubstringWidth(c,start,mid);
			if(w==width) return mid-start;
			if(w<width) min = mid; else max=mid-1;
		}
		for(int i=max;i>=start;--i){
			int w = getSubstringWidth(c,start,i);
			if(w<=width) return i-start;
		}
		return 0;
	}
	// SPANのある位置をpointしたら何文字目に当てはまるか
	int calcOffset(Object c,int start,int width){
		return start + calcMojisu(c,start,width);
	}

	// 指定した範囲を指定した位置に描画する
	// 描画した幅を返す
	public int draw(Graphics g,int x,int y,LogLineInfo line
		,int start,int end
		,int style //0==normal 1==hover 2=selected
		,StyleID sid
	){
		if(end<=start||end>length||start<0) return 0;
		int str_width = getSubstringWidth(g,start,end);
		int font_style = sid.getFontStyle(tsi);
		Color4 c4 =  sid.getColor(tsi);

		boolean rev      = (0!=(font_style&FontInfo2.REVERSE));
		boolean selected = (style==2);
		Color color;
		// 背景を書く
		color =(rev?
		(selected?c4.fg2:c4.fg):
		(selected?c4.bg2:c4.bg));

		if(color!=null){
			g.setColor( color );
		//重いので使わない	((Graphics2D)g).setComposite(hover_composite);
			g.fillRect(x,y,str_width ,line.height );
		//重いので使わない	((Graphics2D)g).setComposite(normal_composite);
		}

		// 文字色
		color =(rev?
		(selected?c4.bg2:c4.bg):
		(selected?c4.fg2:c4.fg));

		if(color==null) color =(rev?
		(selected?Color.black:Color.white):
		(selected?Color.white:Color.black));

		g.setColor( color );

		// ホバー
		if(style==1 
		&& null==sid.getBaseStyle(tsi.baseid).get(FontInfo2.KEY_NOHOVER) 
		){
			((Graphics2D)g).setComposite(hover_composite);
			g.drawRect(x-2,y,str_width+3,line.height);
			((Graphics2D)g).setComposite(normal_composite);

		}

		// 文字
		g.setFont( font );
		g.drawChars(tsi.text_bulk,tsi.text_offset+start,end-start,x,y+line.baseline);

		// 拡張スタイル
		if(0!=(font_style&FontInfo2.UNDERLINE)){
			int yy = y+(line.height-1);
			g.drawLine(x,yy,x+str_width ,yy);
		}
		if(0!=(font_style&FontInfo2.STRIKE)){
			int yy = y+line.baseline -(g.getFontMetrics().getAscent()>>1);
			g.drawLine(x,yy,x+str_width,yy);
		}
		return str_width;
	}
}


////////////////////////////////////////////////////////////////////////////
// 論理行
class LogDiv{
	int divsize_height=0;
		int getHeight(){return divsize_height;}

	LogLineInfo[] lines;
		LogSelPos GetEndPos()
		{ return lines[lines.length-1].getEndPos(); }
		LogSelPos GetBeginPos(Object g)
		{ return lines[0].getStartPos(); }

	BufferTextBlock block;
	int lnum;
	StyleID sid;
	public LogDiv(BufferTextBlock block,int lnum,StyleID sid){
		this.block=block;
		this.lnum=lnum;
		this.sid=sid;
	}

	// 横幅を渡して、縦幅を更新する
	public int updateHeight(Object graphics,int divsize_width){
		if(divsize_width<=0){
			this.lines = new LogLineInfo[1];
			this.lines[0]=new LogLineInfo(0,0);
			this.lines[0].height   =(short)(divsize_height =2);
			this.lines[0].baseline =(short)1;
			return divsize_height;
		}
		this.lines = null;
		divsize_height =0;
		PackedLineReader tsi = new PackedLineReader(block,lnum,sid,"base");
		LinkedList lines = new LinkedList();
		LogLineInfo line=null;
		short line_start_x =0;
		int line_Ascent =0;
		int line_Descent=0;
		int line_Leading=0;

		for(int span_index=0;;++span_index){
			// 区間を読む
			if(tsi.readSpan()==0){
				if( ! tsi.hasNextSpan() ) break;
				if(line!=null) line_start_x =(short)(line.width<divsize_width?line.width:0);
			}
			SpanMetrics metrics = new SpanMetrics(tsi,sid);
			int span_offset=0;
			do{
				//行を開く
				if( line==null ){
					line = new LogLineInfo(span_index,span_offset);
					line.x     =line.width = line_start_x;
					line_Ascent =line_Descent=line_Leading=0;
				}
				boolean closeline = false;
				SpanSizeDetail nodesize = metrics.calcSizeDetail(graphics ,span_offset ,metrics.length);
				if(line.width + nodesize.width <= divsize_width){
					 // 全部書ける
					 span_offset=metrics.length;
					// 最後の区間なら
					if(!tsi.hasNextSpan()) closeline=true;
				}else{
					closeline=true;
					int mojisu = metrics.calcMojisu(graphics,span_offset,divsize_width-line.width);
					// 1文字も表示できない場合は行を閉じるが、
					// 行の先頭のspanに限っては10文字は表示する
					if( mojisu==0 && line.x == line.width ){
						System.err.println("too short width: offset="+span_offset +" length="+metrics.length);
						mojisu =10;
					}
					int old_offset = span_offset;
					span_offset += mojisu;
					if(span_offset>=metrics.length) span_offset=metrics.length;
					nodesize = metrics.calcSizeDetail(this,old_offset,span_offset);
				}
				if(nodesize.width >0){
					line.width += nodesize.width;
					if(line_Ascent < nodesize.Ascent ) line_Ascent  = nodesize.Ascent;
					if(line_Descent< nodesize.Descent) line_Descent = nodesize.Descent;
					if(line_Leading< nodesize.Leading) line_Leading = nodesize.Leading;
				}
				if(closeline){
					line.end_span  =(short)span_index;
					line.end_offset=(short)span_offset;
					line.height    =(short)(line_Leading+line_Ascent+line_Descent+1);
					line.baseline  =(short)(line.height-(line_Descent+1));
					lines.add(line);
					divsize_height += line.height;
					line=null;
				}
			}while( span_offset<metrics.length );
		}
		this.lines = new LogLineInfo[lines.size()];
		int i=0;
		for(Iterator it=lines.iterator();i<lines.size();++i){
			this.lines[i]=(LogLineInfo)it.next();
		}
		return divsize_height;
	}

	// クリックした位置から、spanとその内部での文字位置を計算する
	// p はdiv の左上を基準とした位置であること
	public LogSelPos PointToPos(Object component,Point p,boolean severe){
		if(lines==null) return null; // need updateHeight
		int x=p.x;
		int y=p.y;
		for(int it=0;it<lines.length;++it){
			LogLineInfo line = lines[it];
			if( y >= line.height ){
				y -= line.height;
				continue;
			}
			LogSelectionRange range= new LogSelectionRange(line.getStartPos(),line.getEndPos());
			if(x <line.x) return severe?null:range.start;
			x -=line.x;
			PackedLineReader tsi = new PackedLineReader(block,lnum,sid,"base");
			for(int s=0;;++s){
				int text_length =tsi.readSpan();
				if(s<range.start.span) continue;
				if(s>range.end  .span) break;
				int start = (s==range.start.span?range.start.offset:0);
				int end =   (s==range.end  .span?range.end  .offset:text_length);
				SpanMetrics metrics = new SpanMetrics(tsi,sid);
				int nodewidth = metrics.getSubstringWidth(component,start,end);
				if(x<nodewidth) return new LogSelPos(s,metrics.calcOffset(component,start,x));
				x-=nodewidth;
			}
			return severe?null:range.end;
		}
		if(severe) return null;
		return lines[lines.length-1].getEndPos();
	}

	// 論理行の描画
	public void  draw(
		Graphics g,int to_y // 出力先
		,int lnum           // ブロック内の行番号
		,LogSelectionRange range // 選択範囲 ただしlinenoは見ない
		,int hover_span   // ハイライトされる区間
	){
		PackedLineReader tsi = new PackedLineReader(block,lnum,sid,"base");

		int span_count=-1;
		LogLineInfo line;
		for(int it=0;it<lines.length;++it,to_y+=line.height ){
			line = lines[it];
			int x=line.x;
			LogSelPos line_start =line.getStartPos();
			LogSelPos line_end   =line.getEndPos();
			while(span_count < line_start.span){
				tsi.readSpan();
				++span_count;
			}
			for(;;){
				SpanMetrics metrics = new SpanMetrics(tsi,sid);
				int isHover =(hover_span==span_count?1:0);
				// 区間内部の描画範囲
				int start = (span_count==line_start.span?line_start.offset:0);
				int end   = (span_count==line_end  .span?line_end  .offset:metrics.length);
				// 選択範囲
				int ss =(range.start.span < span_count ?start
				        :range.start.span > span_count? end
				        :range.start.offset <start? start
				        :range.start.offset >end  ? end
				        :range.start.offset );
				int se =(range.end  .span < span_count ?start
						:range.end  .span > span_count ?end
						:range.end.offset <start? start
						:range.end.offset >end  ? end
						:range.end.offset  );
				// 選択範囲より手前
				if(start < ss ){
					x+=metrics.draw(g,x,to_y,line ,start,ss ,isHover,sid );
					start = ss;
				}
				if( se < end ){
					// 選択範囲とその後ろ
					x+=metrics.draw(g,x,to_y,line, start,se,2,sid);
					x+=metrics.draw(g,x,to_y,line, se,end ,isHover,sid);
				}else{
					boolean isSelect =( ss < se );
					if(start<end) x+=metrics.draw(g,x,to_y,line, start,end,(isSelect?2:isHover) ,sid);
				}
				if( span_count==line_end.span) break;
				tsi.readSpan();
				++span_count;
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////
// 効率の理由から複数の論理行をまとめたブロックを扱う

class BufferTextBlock extends PackedLineBlock{
	public BufferTextBlock(int min_length,int min_style_count){
		super(min_length,min_style_count);
	}
	private short[] divheight = new short[maxline+1];
	public  Object[] extra;
	private int height;
	public int getHeight(){return height;}
	public int getLineHeight(int l){return divheight[l];}

	int updateHeight(Object component,int width,StyleID sid){
		height=0;
		for(int lnum=0;lnum<getLineCount();++lnum){
			LogDiv div = new LogDiv(this,lnum,sid);
			height += (divheight[lnum] =(short) div.updateHeight(component,width));
		}
		return height;
	}
	int appendHeight(Object component,int width
		,char[] text
		,byte[] style
		,StyleID sid
		,Object o
	){
		int lnum = super.appendLine(text,style);
		if(o!=null){
			if(extra==null) extra=new Object[maxline];
			extra[lnum]=o;
		}

		LogDiv div = new LogDiv(this,lnum,sid);
		height += (divheight[lnum] =(short) div.updateHeight(component,width));
		return divheight[lnum];
	}
}


/////////////////////////////////////////////////////////////////////////
// 文書

public class LogDocument
implements PopupMenuListener
{
	StyleID sid;
	public LogDocument(StyleID sid){
		this.sid=sid;
	}

	//--------------------------------------------
	// サイズとスクロール
	private Dimension size=new Dimension(-1,0);
		public  int getWidth (){return size.width ;}
		public  int getHeight(){return size.height;}

	private int scrolly=0;
		public  int getScrollY()     {return scrolly;}
		public  int setScrollY(int y){return scrolly=y;}

	private int linecount;
		public int lines(){return linecount;}
		public int getLineCount(){return linecount;}

	// 表示するコントロール
	private LogView view;
		public void addView_byLogView(LogView lv){
			view = lv;
			hover=null;
		}

	// 行データそのもの
	private LinkedList blocks =new LinkedList();

	// 折り返しを計算しなおす
	public void ReloadSetting(Component c){
		size.height=0;
		linecount = 0;
		for(Iterator it=blocks.iterator();it.hasNext();){
			BufferTextBlock node=(BufferTextBlock)it.next();
			size.height += node.updateHeight(c,size.width,sid);
			linecount   += node.getLineCount();
		}
		if(view!=null){
			view.setCursor(Cursor.getDefaultCursor());
		}
	}

	// 古いログを消去
	public static int config_LogSweepMax=2000;
	private void sweepOld(){
		if(linecount < config_LogSweepMax ) return;
		int old_lines  = linecount;
		int old_size   = blocks.size();
		int old_height = size.height;

		size.height=0;
		linecount = 0;
		ListIterator i=blocks.listIterator(blocks.size());
		while(i.hasPrevious()){
			BufferTextBlock node=(BufferTextBlock)i.previous();
			size.height += node.getHeight();
			linecount   += node.getLineCount();
			if( linecount > config_LogSweepMax ) break;
		}
		while(i.hasPrevious()){
			i.previous();
			i.remove();
		}
		if(blocks.size()!=old_size){
			if(SelStartPos.lineno >=0) SelStartPos.lineno -= old_lines-linecount;
			if(SelEndPos  .lineno >=0) SelEndPos  .lineno -= old_lines-linecount;
			scrolly -= old_height - size.height;
			if(scrolly <0 ) scrolly=0;
		}
		if(view!=null) view.onLogSweep();
	}

	////////////////////////////////////////////////////
	// 行の追加
	public void addText(Component g,String t){
		Vector texts = new Vector(1);
		texts.add(t);
		FontInfo2 style = FontInfo2.getDefaultStyle();
		PackedLineWriter tsi = new PackedLineWriter(sid,"base");
		tsi.appendText(texts,0,0,null);
		addText(g,tsi);
	}
	public void addText(Component c,PackedLineWriter tsi){ addText(c,tsi,null); }
	public void addText(Component c,PackedLineWriter tsi,Object o){
		sweepOld();

		int text_length = tsi.text.size();
		int style_count = tsi.style.size();

		// ブロックがないかもう追加できないならブロックを追加する
		if(	blocks.size()==0 
		||	! ((BufferTextBlock)blocks.getLast()).canAppendLine(text_length,style_count)
		)	blocks.add( new BufferTextBlock(text_length,style_count) );

		// ブロックに行を追加する
		BufferTextBlock block = (BufferTextBlock)blocks.getLast();
		int add_height = block.appendHeight(c,size.width
			,tsi.text.toCharArray() 
			,tsi.style.toByteArray() 
			,sid
			,o
		);
		size.height+=add_height;
		++linecount;

		// スクロール位置を調整する。
		if(view!=null){
			// viewがあれば再描画の範囲の都合もあるのでそちらに任せる
			view.onAddText(add_height);
		}else{
			int old_size = size.height-add_height;
			if( size.height <= viewHeight ){
				scrolly=0;
			}else if( old_size-viewHeight-scrolly <= add_height ){
				scrolly = size.height-viewHeight;
			}
		}
	}

	private int viewHeight = 0;
	// ハイライト
	private TextSpanInfo hover;
	void updateHover(TextSpanInfo neo){
		// 範囲選択があるならホバーは出ない
		LogSelectionRange selected =new LogSelectionRange(SelStartPos,SelEndPos);
		if(! selected.empty() ) neo=null;

		if(neo==null){
			if(hover==null) return;
		}else if(hover!=null){
			if( hover.block==neo.block
			&&  hover.line==neo.line
			&&  hover.span_index==neo.span_index
			) return;
		}
		hover=neo;
		if(view!=null){
			Cursor c = (hover==null?null:(Cursor)hover.base_style.get(FontInfo2.KEY_CURSOR));
			view.setCursor(c!=null?c:Cursor.getDefaultCursor());
			view.repaint(100);
		}
	}

	public  void setWidth(Component g,int w,int viewHeight){
		this.viewHeight =viewHeight;
		if(size.width!=w){ size.width= w; ReloadSetting(g); }
	}

	public  void clear(Component g){
		SelectionReset();
		blocks.clear();
		ReloadSetting(g);
		if(view!=null){ view.OnResize(); view.repaint(100); }
	}

	public  void paint(Graphics g,LogView view,int width){
		Composite old_composite =null;
		Stroke old_stroke =null;
		if(g instanceof Graphics2D){
			old_composite = ((Graphics2D)g).getComposite();
			old_stroke = ((Graphics2D)g).getStroke();
		}
		if(size.width!=width){ size.width= width; ReloadSetting(view); }
		LogSelectionRange selected =new LogSelectionRange(SelStartPos,SelEndPos);
		if( selected.empty() ) selected.clear(-1);

		Rectangle rec=g.getClipBounds();
		int ly_start = rec.y +scrolly;
		int ly_end = ly_start + rec.height;

		int linesum=0;
		int y_start=0;
		BufferTextBlock block;
		for(Iterator it=blocks.iterator();it.hasNext();y_start+=block.getHeight(),linesum+=block.getLineCount() ){
			block=(BufferTextBlock)it.next();
			if( y_start >= ly_end ) break;
			if( ly_start >=y_start+block.getHeight()) continue;

			int ys=y_start;
			for(int j=0;j<block.getLineCount();ys+=block.getLineHeight(j++)){
				if( ys >= ly_end ) break;
				if(ly_start >= ys+block.getLineHeight(j) ) continue;
				// 論理行のレイアウト
				int lineno = linesum+j;
				LogDiv div = new LogDiv(block,j,sid);
				div.updateHeight(g,size.width);
				// 論理行内の選択範囲
				if(div.lines ==null || div.lines.length==0) continue;
				LogSelectionRange linerange
					=(lineno<selected.start.lineno||lineno>selected.end.lineno)
					?new LogSelectionRange(div.GetEndPos(),div.GetEndPos())
					:new LogSelectionRange(selected,lineno,div.GetEndPos())
					;
				// 論理行内でハイライトされる区間のインデクス
				int hover_span = ((hover!=null&& hover.block==block && hover.line==j)?hover.span_index:-1);
				// 論理行を描画
				div.draw(g,ys-scrolly, j ,linerange,hover_span);
			}
		}
		if( g instanceof Graphics2D ){
			((Graphics2D)g).setComposite(old_composite);
			((Graphics2D)g).setStroke(old_stroke);
		}
	}

	////////////////////////////////////////////////
	// 座標から位置を取得
	public  LogSelPos PointToPos(Object component,int x,int y,boolean severe){
		y+=scrolly;
		if(y<0 && severe) return null;
		int y_start=0;int lineno=0;
		BufferTextBlock block;
		for(Iterator it=blocks.iterator();it.hasNext();y_start+=block.getHeight(),lineno+=block.getLineCount()){
			block=(BufferTextBlock)it.next();
			if( y >= y_start+block.getHeight()) continue;
			int ys=y_start;
			for(int j=0;j<block.getLineCount();ys+=block.getLineHeight(j++) ){
				if( y >= ys+block.getLineHeight(j) ) continue;
				LogDiv div = new LogDiv(block,j,sid);
				div.updateHeight(component,size.width);
				LogSelPos result =div.PointToPos(component,new Point(x,y-ys),severe);
				if(result==null) return null;
				result.lineno = lineno+j;
				return result;
			}
		}
		return severe?null:new LogSelPos(lineno);
	}
	// 指定した位置の情報
	public  TextSpanInfo PosToSpan(LogSelPos pos){
		int s=0;
		BufferTextBlock block;
		for(Iterator it=blocks.iterator();it.hasNext();s+=block.getLineCount()){
			block=(BufferTextBlock)it.next();
			if( pos.lineno < s ) break;
			if( pos.lineno >= s + block.getLineCount() )continue;
			return new TextSpanInfo(block,pos.lineno-s,pos.span,pos.offset,sid);
		}
		return null;
	}

	////////////////////////////////////////////////////////////
	// 範囲選択

	private LogSelPos badpos      =new LogSelPos(-1);
	private LogSelPos SelStartPos =new LogSelPos(-1);
	private LogSelPos SelEndPos   =new LogSelPos(-1);

	public  void SelectionReset(){
		SelStartPos=badpos;
		SelEndPos  =badpos;
		if(view!=null) view.repaint(100);
	}
	public void selectAll(){
		SelStartPos=new LogSelPos(0);
		SelEndPos  =new LogSelPos(linecount);
		if(view!=null) view.repaint(100);
	}
	// 選択範囲のテキストを取得
	public  String getSelectedText(){
		LogSelectionRange range = new LogSelectionRange(SelStartPos,SelEndPos);
		if( range.empty() ){
			if(hover==null) return "";
			return hover.text;
		}
		StringBuffer sb =new StringBuffer();
		BufferTextBlock block;
		int lineno=0;
		for(Iterator i=blocks.iterator();i.hasNext();lineno+=block.getLineCount()){
			block=(BufferTextBlock)i.next();
			if(range.start.lineno > lineno + block.getLineCount() ) continue;
			if(range.end  .lineno < lineno ) break;

			for(int j=0;j<block.getLineCount();++j){
				int lno = lineno+j;
				if(range.start.lineno >lno ) continue;
				if(range.end.lineno   <lno ) break;

				PackedLineReader tsi = new PackedLineReader(block,j,sid,"base");
				tsi.calcSpanNodes();
				LogSelectionRange linerange = new LogSelectionRange(range,lno,tsi.span_count-1,tsi.lastspan_length);

				// 行の内部を読む
				for(int s=0;;++s){
					int text_length =tsi.readSpan();
					if(s<linerange.start.span) continue;
					if(s>linerange.end  .span) break;
					String spantext = tsi.getSpanText();
					int start_o =(s==linerange.start.span?linerange.start.offset:0          );
					int end_o   =(s==linerange.end  .span?linerange.end  .offset:text_length);
					tsi.writeSubstringToStringBuffer(sb,start_o,end_o-start_o);
				}
				if(lno<range.end.lineno) sb.append("\n");
			}
		}
		int last= sb.length()-1;
		while(last >=0 && sb.charAt(last)=='\n')--last;
		return last <0?"":sb.substring(0,last+1);
	}
	////////////////////////////////////////////////////////////

	public  void mouseMoved(MouseEvent e){
		// ハイライトの更新
		if(!isMenuOpen 
		&& !in_area_select
		){
			LogSelPos pos = PointToPos(e.getComponent(),e.getX(),e.getY(),true);
			updateHover(  pos==null?null:PosToSpan(pos) );
		}
	}
	public void mouseExited(MouseEvent e){
		// ハイライトの更新
		if(!isMenuOpen
		&& !in_area_select
		){
			updateHover(null);
		}
	}

	LogSelPos lastPressStart;
	boolean in_area_select =false;

	public  void mousePressed(MouseEvent e){
		// 範囲選択した部分を押したらドラッグ開始
		LogSelPos pos = PointToPos(e.getComponent(),e.getX(),e.getY(),true);
		if(pos !=null ){
			LogSelectionRange range = new LogSelectionRange(SelStartPos,SelEndPos);
			if( range.isIn(pos) ){
				view.getTransferHandler().exportAsDrag(view, e, TransferHandler.COPY);
				return;
			}
		}

		// 範囲選択の開始？
		lastPressStart=PointToPos(e.getComponent(),e.getX(),e.getY(),false );
		if(lastPressStart==null){ SelectionReset(); return; }
		// System.err.println("selection start?"+" lineno="+lastPressStart.lineno+" span="  +lastPressStart.span+" offset="+lastPressStart.offset);
		in_area_select=true;
	}
	public  void mouseDragged(MouseEvent e){
		if(!isMenuOpen){
			updateHover(null);
			if(in_area_select){
				/// 範囲選択の継続
				if(lastPressStart!=null){
					SelStartPos=lastPressStart;
					lastPressStart=null;
				}
				SelEndPos = PointToPos(e.getComponent(),e.getX(),e.getY() ,false );
				if(view!=null) view.repaint(100);
			}
		}
	}
	public  void mouseReleased(MouseEvent e){
		in_area_select=false;
	}

	// クリックを吸収したらtrue 
	public  boolean mouseClicked(MouseEvent e){
		if(e.isPopupTrigger()) return false;

		// クリックした位置
		LogSelPos pos = PointToPos(e.getComponent(),e.getX(),e.getY(),true);
		// 範囲選択した部分をクリックした
		if(pos!=null){
			LogSelectionRange range = new LogSelectionRange(SelStartPos,SelEndPos);
			if( range.isIn(pos) ){
				// この場合ホバーは関係ない
				// よって区間ごとに処理がかわることもない

				// todo:範囲選択した部分のクリックでやることは何かあるか？
				return false;
			}
		}

		// 範囲選択を解除する
		if(e.getButton()== MouseEvent.BUTTON1 ){
			SelectionReset();
		}

		// 余白をクリックした場合はイベントは吸収しない
		if(pos==null) return false;

		// 注目する位置の更新
		TextSpanInfo lsd = PosToSpan(pos);
		updateHover( lsd );

		// 注目する位置には何もなかった？
		if( lsd==null ) return false;

		// 区間に応じたアクションを実行する
		BufferClickAdapter ca = (BufferClickAdapter)lsd.base_style.get(FontInfo2.KEY_BCA);
		if(ca!=null && ca.ClickEvent(e,this,lsd) ) return true;

		// アクションがない場合ダブルクリックで範囲選択
		if(e.getClickCount()==2){
			SelStartPos=new LogSelPos(pos.span,0);
			SelEndPos  =new LogSelPos(pos.span,lsd.text.length());
			SelStartPos.lineno = SelEndPos.lineno = pos.lineno;
			if(view!=null) view.repaint(100);
			return true;
		}

		// その他の場合でもクリックという動作は吸収したことになる
		return true;
	}

	////////////////////////////////////////
	// ポップアップメニューリスナーの取得
	TextSpanInfo hover_lastpopup;
	public TextSpanInfo getLastHover(){ return hover_lastpopup;}

	boolean isMenuOpen=false;
	public String getMenuListener(){
		isMenuOpen=true;
		hover_lastpopup=null;
		LogSelectionRange range = new LogSelectionRange(SelStartPos,SelEndPos);
		if( range.empty() && hover!=null){
			hover_lastpopup=hover;
			FontInfo2 fi = hover.base_style;
			String s=(String)fi.get(FontInfo2.KEY_MENUSTRING);
			if(s!=null) return s;
		}
		// 範囲選択されている場合ホバーは関係ない
		// 区間ごとに処理がかわることもない
		// 範囲選択がなくてホバーもない場合も、何も特別なことはない
		return "popup-buffer";
	}
	public void popupMenuCanceled(PopupMenuEvent e){}
	public void popupMenuWillBecomeVisible(PopupMenuEvent e){}
	public void popupMenuWillBecomeInvisible(PopupMenuEvent e){
		((JPopupMenu)e.getSource()).removePopupMenuListener(this);
		isMenuOpen=false;
	}
}
