package compiledplugin;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.nio.channels.*;
import java.nio.ByteBuffer;
import java.io.IOException;
import bluntirc.App;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import bluntirc.*;
import dialog.*;
import irc.*;
import base.*;
import gui.*;
import java.text.ParseException;

class DCCReceiveItem implements base.SelectorItem{
	public String getName(SelectableChannel which){ return "DCCReceiveItem";}
	// 補助的なもの
	static final String[] scale=new String[]{ "B","KB","MB","GB","TB"};
	static JFileChooser fc;
	static java.text.NumberFormat nf ;

	public static void unloadStatic(){
		fc=null;
		nf=null;
	}

	String cropSize(double size){
		if(size<0) return "不明";
		if(nf==null){
			nf=java.text.NumberFormat.getInstance();
			nf.setMaximumFractionDigits(2);
		}
		for(int i=0;i<scale.length;++i){
			if(size<1000 || i==scale.length-1) return nf.format(size)+scale[i];
			size/=1000;
		}
		return "?";
	}
	static int parseInt(String text,String desc)
	throws ParseException
	{
		if(text==null) throw new ParseException(desc+"の指定がありません",0);
		try{ return Integer.parseInt(text); }
		catch(Exception e){ throw new ParseException(desc+"の値"+text+"+を整数に変換できません",0);}
	}

	////////////////////////
	// 情報
	java.text.DateFormat date_format;
	java.text.DateFormat time_format;
	Date _sendtime; // DCC SENDを受けた時刻
		String text_sendtime; // DCC SENDを受け取った時刻

	IRCConnection conn;
	String from_nick; // 送信者

	InetAddress src_host; // DCCサーバのアドレス 
	int         src_port; // DCCサーバのポート
		String text_sendaddr;

	File saveto;
	long src_size; // サイズ
	String      src_name; // ファイル名
		String text_srcsize;
		String text_srcfile;
		String text_saveto;
		String text_saveto_dir;
		void setSaveTo(File file){
			saveto = file;
			text_saveto=saveto.getName();
			text_saveto_dir=saveto.getParentFile().getAbsolutePath();
			if(owner!=null) owner.updateDisplay(this);
		}


	String text_state; // 状態
	String text_speed; // 速度

	// セーブルセルに表示する
	public Object getCellValue(int col){
		switch(col){
		case 0: return text_sendtime;
		case 1: return from_nick+"@"+conn.getListener().getConnectionName(conn);
		case 2: return text_sendaddr;
		case 3: return text_srcsize;
		case 4: return text_srcfile;
		case 5: return text_saveto_dir;
		case 6: return text_saveto;
		case 7: return text_state;
		case 8: return text_speed;
		}
		return "?";
	}

	///////////////////////////////////
	// 状態
	public static final int ST_PRESTART =0;
	public static final int ST_PROGRESS =1;
	public static final int ST_END      =2;
	public static final int ST_RESUME_WAIT=3;
	
	int now_state=-1;
	DCCReceiveManager owner;
	void setState(int state,String text,String detail){
		now_state=state;
		text_state=text;
		if(detail!=null) text_speed = detail;
		if(owner!=null) owner.updateDisplay(this);
	}

	///////////////////////////////////
	// 統計の更新

	int  sec_read;
	long pre_time;
	long total_offset;
	void clearStats(long start_pos){
		pre_time = System.currentTimeMillis();
		total_offset = start_pos;
		sec_read=0;
	}

	void updateSpeed(int plus){
		total_offset+=plus;
		sec_read+=plus;
		long now = System.currentTimeMillis();
		if(now-pre_time <1000) return;
		text_speed = cropSize( sec_read*(double)1000/(now-pre_time) )+"/s";
		text_state = cropSize( total_offset )+"/"+cropSize(src_size)+"受信";
		pre_time=now;
		sec_read=0;
		if(owner!=null) owner.updateDisplay(this);
	}


	///////////////////////////////////////////
	// ソケットの扱い
	SocketChannel channel;
	ByteBuffer read_buffer;
	ByteBuffer write_buffer;
	FileChannel fo;
	ByteBuffer fo_buffer;
	SelectionKey key;

	File resume_file;

	public void init(DCCReceiveManager owner,TimeZone tz
		,IRCConnection conn,String from_nick
		,String a_sendname
		,String a_address
		,String a_port
		,String a_size
	)
	throws ParseException
	{
		resume_file=null;
		this.owner=owner;

		// DCC SENDを受けた時刻
		date_format = java.text.DateFormat.getDateInstance(java.text.DateFormat.LONG );
		time_format = java.text.DateFormat.getTimeInstance(java.text.DateFormat.LONG );
		date_format.setCalendar(new GregorianCalendar(tz));
		time_format.setCalendar(new GregorianCalendar(tz));
		_sendtime = new Date();
		// ファイル名
		{
			StringBuffer sb=new StringBuffer();
			for(int i=0;i<a_sendname.length();++i){
				char c= a_sendname.charAt(i);
				if(-1!="\\/:;".indexOf(c)){
					sb=new StringBuffer();
					continue;
				}
				if(c<0x20 || c=='%'|| c==0x7f || -1!="?*,<>|\"".indexOf(c)){
					sb.append('%');
					String Hex= Integer.toHexString(256+c);
					sb.append(Hex.substring(Hex.length()-2));
					continue;
				}
				sb.append(c);
			}
			src_name= sb.toString();
		}
		// 送信アドレス
		{
			if(a_address==null) throw new ParseException("アドレスの指定がありません",0);
			boolean nonDigit =false;
			for(int i=0;i<a_address.length();++i){
				if(!Util.isURIDigit(a_address.charAt(i))){
					nonDigit=true;
					break;
				}
			}
			if(!nonDigit){
				long l = Long.parseLong(a_address);
				int[] a=new int[4];
				a[0] =(int)(l>> 24)&255;
				a[1] =(int) (l>>16)&255;
				a[2] =(int) (l>> 8)&255;
				a[3] =(int) (l>> 0)&255;
				StringBuffer sb=new StringBuffer();
				for(int i=0;i<4;++i){
					if(i!=0) sb.append('.');
					sb.append(Integer.toString(a[i]));
				}
				a_address =new String(sb);
			}
			try{
				src_host= InetAddress .getByName(a_address);
			}catch(UnknownHostException e){
				throw new ParseException(a_address+"をInetAddressに変換できません",0);
			}
		}
		// ポート番号
		src_port =parseInt(a_port,"送信側ポート番号");
		if(src_port<1) throw new ParseException("送信側ポート番号が1より小さい",0);
		// ファイルサイズ
		if(a_size==null){
			src_size=-1; // 不明を示す
		}else{
			src_size=parseInt(a_size,"ファイルサイズ");
			if(src_size<1) throw new ParseException("ファイルサイズが1より小さい",0);
		}
		///////////////////////////////
		// 保存先を用意する
		{
			int dot = src_name.lastIndexOf('.');
			if(dot==-1) dot = src_name.length();
			String src_base = src_name.substring(0,dot);
			String src_ext  = (dot==src_name.length() ? "" :src_name.substring(dot));
			String path = DialogEditItem_FilePath.getPath( App.root_property.getString("DCCReceiver/DefaultSaveDirectory"));
			File savedir = new File( path!=null?path:"");
			if( !savedir.exists() ){
				try{
					savedir.mkdirs();
				}catch(SecurityException e){
					throw new ParseException("保存先"+savedir.getAbsolutePath()+"への出力はセキュリティマネージャによって拒否された。"+e.getLocalizedMessage(),0);
				}
			}
			for(int i=1;;++i){
				String name= src_base + (i==1?"":"."+i) +src_ext;
				saveto =new File(savedir,name);
				if(!saveto.exists()) break;
			}
		}
		///////////////////////////////
		// 表示用の情報を用意する
		text_sendtime = date_format.format(_sendtime)
			+"_"+time_format.format(_sendtime)
			;
		this.conn=conn;
		this.from_nick=from_nick;

		text_sendaddr = src_host.getHostAddress()+" p#"+src_port;
		text_srcsize =cropSize(src_size);

		text_srcfile=src_name;
		setSaveTo(saveto);
		setState(ST_PRESTART,"待機中","受信ボタンか再開ボタンを押してください");
	}

	// 受信の停止
	boolean canStopReceive(){ return now_state==ST_PROGRESS;}
	void stopReceive(){
		close("中止","ユーザによる中止");
	}
	// 削除
	boolean canRemove(){ return now_state==ST_PRESTART || now_state==ST_END;}
	void unload(){
		close("中止","アンロードの準備");
		owner=null;
	}

	// フォルダを開く
	public void openFolder()
	{ App.os_dependence.openFolder(saveto.getParentFile()); }

	// 保存ファイル名の変更
	boolean canRename(){ return now_state==ST_PRESTART;}
	void renameDialog(){
		if(fc==null)  fc=new JFileChooser();
		fc.updateUI();
		fc.setSelectedFile(saveto);
		fc.setDialogType(fc.SAVE_DIALOG);
		fc.setDialogTitle("名前をつけて保存");
		if(fc.APPROVE_OPTION != fc.showSaveDialog(owner)) return;
		setSaveTo(fc.getSelectedFile());
	}

	public boolean canResume(){ return now_state==ST_PRESTART;}

	void resume(){
		// 再開するファイルを選ぶ
		if(fc==null)  fc=new JFileChooser();
		fc.updateUI();
		fc.setSelectedFile(saveto);
		fc.setDialogType(fc.OPEN_DIALOG);
		fc.setDialogTitle("どのファイルから再開しますか？");
		if(fc.APPROVE_OPTION != fc.showSaveDialog(owner)) return;
		resume_file = fc.getSelectedFile();
		long pos = resume_file.length();
		if(pos >= src_size ){
			JOptionPane.showMessageDialog(owner,resume_file.getName()+"には送信されるファイル以上のサイズがあります。\nこのファイルからは再開できないか、する必要がありません。");
			return;
		}
		// DCC ACCEPTを送信する
		{
			Vector v=new Vector(5);
			v.add("DCC");
			v.add("RESUME");
			v.add("file.ext");
			v.add(""+src_port );
			v.add(""+pos );
			conn.SendToServer(conn.encodeCTCP(Util.toJIS(from_nick),v,"PRIVMSG"));
		}
		setState(ST_RESUME_WAIT,"交渉中","再開を交渉しています");
	}

	// この項目あての再開許可なら真
	public boolean onResumeAccept(IRCMessage m,int port,long pos,byte[] name){
		// ファイル名でチェックできないのが痛い
		if( port   !=this.src_port
		||  m.conn !=this.conn
		||  ! m.from.equals(Util.toJIS(from_nick))
		) return false;
		start(resume_file,pos);
		return true;
	}

	// 普通に開始する
	boolean canStart(){ return  now_state==ST_PRESTART;}
	void startReceive(){ start(saveto,0); }

	// 開始または再開
	void start( File savefile,long pos ){
		setSaveTo(savefile);
		try{
			// 受信するアドレス
			InetSocketAddress remote = new InetSocketAddress(src_host,src_port);
			InetSocketAddress local=null;
		//	if( null!=l_host &&  0!=l_host.length() )
		//		local=new InetSocketAddress(InetAddress.getByName(l_host),l_port);

			// 保存するファイル
			if(pos==0){
				fo = new FileOutputStream(savefile).getChannel();
			}else{
				fo = new RandomAccessFile(savefile,"rw").getChannel();
				long oldsize = fo.size();
				if(oldsize > pos){
					fo.truncate(pos);
				}else if( pos > oldsize ){
					JOptionPane.showMessageDialog(owner,savefile.getName()+"の"+pos+"から再開するように指示されましたが、再開するファイルがそれより小さいです。");
					close("エラー","送信側の指定した再開位置が変です");
					return;
				}
				fo.position(pos);
			}

			// バッファの確保
			read_buffer  =ByteBuffer.allocate(16384);
			write_buffer =ByteBuffer.allocate(4096);
			fo_buffer    =ByteBuffer.allocate(16384);

			// 出力用バッファの初期状態を !hasRemaining() にする
			read_buffer.clear();
			write_buffer.flip();
			fo_buffer.flip();

			// ソケットの作成
			channel =SocketChannel.open();
			if(local!=null) channel.socket().bind(local);
			channel.socket().setSoTimeout(1000*60*3);
			channel.socket().setTcpNoDelay(true);
			channel.socket().setReuseAddress(true);
			// 非同期にしてセレクタに登録
			channel.configureBlocking(false);
			interest_ops_for_write=0;
			key = App.selector.register(this,channel);
			channel.connect(remote);
			if(pos>0){
				setState(ST_PROGRESS,"再開","接続します…");
			}else{
				setState(ST_PROGRESS,"接続","接続します…");
			}
		}catch(IOException e){
			closeByError(e,"接続");
		}
	}

	///////////////////////////////////////////////////////////////////////
	// implements SelectorItem

	public void onTimer(SelectableChannel which){}

	public boolean onAcceptable (SelectableChannel which){ return true;}

	public boolean onConnectable(SelectableChannel which){
		try{
			if(channel.finishConnect()){
				// 接続した
				interest_ops_for_write=SelectionKey.OP_WRITE|SelectionKey.OP_READ;
				key.interestOps(interest_ops_for_write);

				clearStats(fo.position());
				setState(ST_PROGRESS,"接続","接続しました");
				return false;
			}
			return false;
		}catch(IOException e){ return closeByError(e,"接続"); }
	}

	boolean read_end;
	public boolean onReadable(SelectableChannel which){
		int r=0;
		try{
			r= channel.read(read_buffer);
		}catch(IOException e){
			return closeByError(e,"受信");
		}
		// 読めたなら統計の更新とアクノリッジの送信
		if(r>0){
			updateSpeed(r);
			ack.add(new Integer((int)total_offset));

			// 書ける時に書いておく
			if(!write_buffer.hasRemaining()) charge_write_buffer();
			try{ channel.write(write_buffer); }
			catch(IOException e){ return closeByError(e,"送信"); }
			if( write_buffer.hasRemaining() ){
				// 書き専用の時間がいるらしい
				key.interestOps(interest_ops_for_write);
			}
		}
		// ファイルに書く
		if(r==-1){
			text_state = "save...";
			if(owner!=null) owner.updateDisplay(this);
		}
		for(;;){
			// ディスクへの書き込み
			if(fo_buffer.hasRemaining() ){
				try{ fo.write(fo_buffer);}
				catch(IOException e){ return closeByError(e,"保存"); }
				if(fo_buffer.hasRemaining()){
					 // 今書いてしまうしかない
					if(r==-1) continue;
					// 次の機会があるなら今でなくてもいい
					return false;
				}
			}
			// fo_bufferは空なのでread_bufferと交換する
			if( read_buffer.position()>0 ){
				ByteBuffer tmp=read_buffer;read_buffer=fo_buffer;fo_buffer=tmp;
				read_buffer.clear();
				fo_buffer  .flip();
				continue;
			}
			break;
		}
		// 次のデータを待つ
		if(r!=-1) return false;
		// 完全に書けた
		text_state = "Flushed";
		if(owner!=null) owner.updateDisplay(this);
		read_end=true;
		// アクノリッジを送信済みならここで終了
		if(ack.size()==0 
		&& !write_buffer.hasRemaining()
		){
			App.Log("DCC受信完了 "+saveto.getPath());
			return close("完了","受信が終わりました");
		}
		// アクノリッジの出力のための機会を作る
		key.interestOps(SelectionKey.OP_WRITE);
		return true;
	}

	public boolean wantWrite(SelectableChannel which){
		return write_buffer.hasRemaining() || (ack.size()>0);
	}
	public boolean onWritable(SelectableChannel which){
//		App.Log("onWritable"+key.readyOps() +" "+key.interestOps());
		do{
			if( write_buffer.hasRemaining() ){
				try{ channel.write(write_buffer); }
				catch(IOException e){ return closeByError(e,"送信"); }
				if( write_buffer.hasRemaining() ) return false;
			}
			charge_write_buffer();
		}while(write_buffer.hasRemaining());
		// 終了フラグが立ってれば終了
		if(read_end){
			App.Log("DCC受信完了: "+saveto.getPath());
			return close("完了","受信が完了しました");
		}
		// バッファが空なら onWritable が呼ばれないようにする
		// (そうしないと受信ができない?)
		key.interestOps(SelectionKey.OP_READ);
		return true;
	}
	public void onSelectorExit(SelectableChannel which){
	}


	protected boolean closeByError(Throwable e,String desc){
		String message = e.getLocalizedMessage();
		if(message==null || message.length()==0) message = e.getMessage();
		if(message==null || message.length()==0) message = e.toString();
		App.Log("DCC受信 "+desc+"時にエラー:"+message);
		return close("エラー",desc+"時にエラー:"+message);
	}
	public boolean close(String text,String detail){
		if(fo!=null){
			try{
				fo.close();
				fo=null; 
			 }catch(IOException e){
				fo=null;
				return closeByError(e,"ファイル保存");
			}
		}
		if(channel != null ){
			try{
				channel.close();
			}catch(IOException e){
			}
			channel=null;
		}
		setState(ST_END,text,detail);
		return true;
	}


	//////////////////////////////////////////////////

	protected int interest_ops_for_write;
	LinkedList ack= new LinkedList();
	public void charge_write_buffer(){
		write_buffer.clear();
		for(Iterator it=ack.iterator();it.hasNext();){
			write_buffer.putInt((((Integer)it.next()).intValue()));
		}
		ack.clear();
		write_buffer.flip();
	}

	///////////////////////////////////////////////////////

	public DCCReceiveItem(DCCReceiveManager owner,TimeZone tz,IRCConnection conn,String from_nick,byte[] param,int i)
	throws ParseException
	{
		String[] desc=new String[]{"ファイル名","送信アドレス","送信ポート","ファイルサイズ",};
		String[] value = new String[desc.length];
		ByteArrayOutputStream bao =new ByteArrayOutputStream();
		for(int j=0;j<desc.length;++j){
			while(i<param.length&&param[i]==' ')++i;
			int start=i;while(i<param.length&&param[i]!=' ')++i;
			if(i>start){
				bao.reset();
				irc.CTCPQuote.decodeParam(bao,param,start,i);
				value[j]=base.Util.fromJIS(bao.toByteArray());
				continue;
			}
			if(j!= desc.length-1) throw new ParseException("DCC SENDに"+desc[j]+"の指定がない",0);
		}
		init( owner,tz,conn,from_nick,value[0],value[1],value[2],value[3] );
	}

	public DCCReceiveItem(DCCReceiveManager owner,TimeZone tz,IRCConnection conn,String from_nick,String a_sendname,String a_address,String a_port,String a_size)
	throws ParseException
	{
		init(owner,tz,conn,from_nick,a_sendname, a_address, a_port, a_size);
	}
};





/////////////////////////////////////////////////////////////////
// 一覧を表示するフレーム
public class DCCReceiveManager 
extends JFrame
implements hook.IRCMessageRewrite2,TableModel,bluntirc.djava.ScriptUnloadable
{
	//	abstract public void updateDisplay(Object src);

	public void unload(){
		// 表示状態を覚える
		WindowPos.saveTableColPos(table,"DCCReceiver/TableColPos");
		WindowPos.saveWindowPos(this,"DCCReceiver/WindowPos");

		// アイテムを捨てる
		for(Iterator it=list.iterator();it.hasNext();){
			((DCCReceiveItem)it.next()).unload();
		}
		list.clear();
		this.fireTableChanged(new TableModelEvent(this));
		DCCReceiveItem.unloadStatic();

		// 終了
		setVisible(false);
		hide(); 
		dispose();
	}

	// インナークラスから呼ばれる
	public DCCReceiveManager getThis(){return this;}

	public DCCReceiveManager(ScriptManager manager){
		super("DCC受信器");
		setIconImage(App.icon_app.getImage());
		App.root_property.setDefaultObject("DCCReceiver",new HashMap());
		App.root_property.setDefaultString("DCCReceiver/DefaultSaveDirectory",Util.qq(new File("dccrecv").getAbsolutePath()) );
		addComponents();
		checkButtonEnabled();

		manager.addScriptAction("show",new AbstractAction(){
		public void actionPerformed(ActionEvent e){
			show();
		}});
		manager.addScriptAction("hide",new AbstractAction(){
		public void actionPerformed(ActionEvent e){
			hide();
		}});
	}

	//////////////////////////////////////////////////////
	// フック

	HashMap wildcard_cache=new HashMap();

	public IRCMessage rewriteIRCMessage2(IRCMessage m){ checkCTCP(m); return m; }
	void checkCTCP(IRCMessage ctcp){
		if(! ctcp.cmd.equals("CTCP_DCC")) return;
		byte[] ba=ctcp.getParam(0);
		int start=0;
		int i=start;
		while(i<ba.length && ba[i]==' ') ++i;
		start=i;while(i<ba.length && ba[i]!=' ') ++i;
		if(i>start){
			String cmd =Util.fromJIS(ba,start,i);
			if(cmd.equals("SEND")){
				// 無視する？
				{
					String str = ctcp.from.getPrefixStr();
					Object o = App.root_property.get("DCCReceiver/ignoreMask");
					if(o instanceof LinkedList ){
						for(Iterator it= ((LinkedList)o).iterator();it.hasNext();){
							String mask = (String)it.next();
							Pattern p= (Pattern)wildcard_cache.get(mask);
							if(p==null) wildcard_cache.put(mask,p = Pattern.compile(base.Util.WildcardToRegEx(mask)));
							if( p.matcher(str).matches() ){
								App.Log("DCC SENDの無視: "+str+" "+mask);
								return; 
							}
						}
					}
				}

				try{
					if(!App.root_property.setDefaultBoolean("DCCReceiver/NoPopupOnRequest",false))
						show();
					table_add(new DCCReceiveItem(
						getThis(),TimeZone.getDefault(),ctcp.conn,ctcp.from.getName(),ba,i
					));

				}catch(ParseException ee){
					App.Log("DCC SENDのパースに失敗:"+ee.getMessage() );
				}
			}
			if(cmd.equals("ACCEPT")){
				String[] desc=new String[]{"ファイル名","送信ポート","再開位置",};
				byte[][] value = new byte[desc.length][];
				ByteArrayOutputStream bao =new ByteArrayOutputStream();
				try{
					for(int j=0;j<desc.length;++j){
						while(i<ba.length&&ba[i]==' ')++i;
						start=i;while(i<ba.length&&ba[i]!=' ')++i;
						if(i>start){
							bao.reset();
							irc.CTCPQuote.decodeParam(bao,ba,start,i);
							value[j]= bao.toByteArray();
							continue;
						}
						throw new ParseException(desc[j]+"の指定がない",0);
					}
					int port = Integer.parseInt(Util.fromJIS(value[1]));
					long pos  = Long.parseLong(Util.fromJIS(value[2]));
					for(Iterator it=list.iterator();it.hasNext();){
						if( ((DCCReceiveItem)it.next()).onResumeAccept
						(ctcp,port,pos,value[0] ) ) break;
					}
				}catch(ParseException ee){
					App.Log("DCC ACCEPTを読めません:"+ee.getMessage() );
				}
			}
		}
	}

	////////////////////////////////////////////////
	// GUI部品

	JTable table;
	MyCellRendererH header_renderer;
	MyCellRendererD cell_renderer;
	public void show(){
		boolean old_showing=isShowing();
		super.show();
		if(!old_showing){
			App.os_dependence.updateUI(UIManager.getColor("control"),this);
			header_renderer.updateUI();
			cell_renderer.updateUI();
		}
	}

	void addComponents(){
		getContentPane().setLayout(new BorderLayout());
		// テーブルを追加する
		{
			table = new JTable(this);
			JScrollPane scrollpane = new JScrollPane(table);
			getContentPane().add(scrollpane,BorderLayout.CENTER);

			table.setFont(new Font("Dialog",0,12));

			header_renderer =new MyCellRendererH(table.getTableHeader().getDefaultRenderer());
			table.getTableHeader().setDefaultRenderer(header_renderer);

			cell_renderer = new MyCellRendererD();
			table.setDefaultRenderer(String.class,cell_renderer);

			table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			table.setShowVerticalLines(false);

			table.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION );
			table.getSelectionModel().addListSelectionListener(new ListSelectionListener (){
				public void valueChanged(ListSelectionEvent e){
					checkButtonEnabled();
				}
			});
			updateColWidth();
		}
		// ボタンを追加する
		{
			buttons=Box.createHorizontalBox();
			Insets inset = new Insets(0,0,0,0);
			for(int i=0;i<button_actions.length;++i){
				if(button_actions[i]==null){
					buttons.add(Box.createHorizontalGlue());
					continue;
				}
				JButton b= new JButton(button_actions[i]);
				b.setFont(table.getFont());
				b.setMargin(inset);
				buttons.add(b);
			}
			
			getContentPane().add(buttons,BorderLayout.SOUTH);
		}
		setSize(300,300);
		WindowPos.setWindowsPosToCenter(this);
		WindowPos.loadWindowPos(this,"DCCReceiver/WindowPos");
		WindowPos.loadTableColPos(table,"DCCReceiver/TableColPos");
	}


	////////
	// manage TableModelListener 
	LinkedList listener = new LinkedList();
	public void addTableModelListener(TableModelListener l)
	{ if(-1==listener.indexOf(l)) listener.add(l); }
	public void removeTableModelListener(TableModelListener l)
	{ listener.remove(l); }
	public void fireTableChanged(TableModelEvent e){
		for(Iterator i=listener.iterator();i.hasNext();)
		{ ((TableModelListener)i.next()).tableChanged(e); }
	}
	////////
	// implements TableModel
	public int getColumnCount() { return header.length; }
	public String getColumnName(int column){ return header[column];}
	public Class getColumnClass(int column){ return String.class;}
	public int getRowCount() { return list.size();}
	public Object getValueAt(int row, int col)
	{ return ((DCCReceiveItem)list.get(row)).getCellValue(col);}
	public boolean isCellEditable(int rowIndex,int columnIndex){return false;}
	public void setValueAt(Object aValue,int rowIndex,int columnIndex){}
	////////

	static String[] header=new String[]{
		// ヘッダ           
		"提示時刻",			
		"送信者",			
		"送信元アドレス",	
		"サイズ",			
		"元ファイル名",		
		"保存フォルダ",		
		"保存ファイル名",	
		"状態",				
		"受信速度",			
	};
	public void updateColWidth(){
		int size= table.getColumnModel().getColumnCount();
		for(int c=0;c<size;++c){
			int mc =table.convertColumnIndexToModel(c);
			int w=8+table.getFontMetrics(table.getFont()).stringWidth(header[c]);
/*
			for(int y=0;y<list.size();++y){
				String s = (String) getValueAt(y,mc);
				if(s==null) continue;
				int wid = 8+table.getFontMetrics(table.getFont()).stringWidth(s);
				if(w<wid) w=wid;
			}
*/
			table.getColumnModel().getColumn(c).setMinWidth    (w);
			table.getColumnModel().getColumn(c).setPreferredWidth(w);
		}
	}

	//////////////////////////////////////////////////////////
	// 受信項目のリスト

	LinkedList list = new LinkedList();

	public int getSelectedIndex(){
		if(list!=null && table!=null){
			int i = table.getSelectionModel().getAnchorSelectionIndex();
			if(i>=0 && i<list.size()) return i;
		}
		return -1;
	}
	public DCCReceiveItem getSelectedItem(){
		int i= getSelectedIndex();
		return i==-1?null:(DCCReceiveItem)list.get(i);
	}

	public void table_add(DCCReceiveItem item){
		list.add(item);
		int i= list.size()-1;
		if(i>=0) this.fireTableChanged(new TableModelEvent(this, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT));
		if(-1==getSelectedIndex()){
			table.getSelectionModel().setSelectionInterval(i,i);
		}
	}

	public void updateDisplay(Object src){
		int i = list.indexOf(src);
		if(i>=0) this.fireTableChanged(new TableModelEvent(this, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE));
		checkButtonEnabled();
		repaint();
	}
	Box buttons;
	void checkButtonEnabled(){
		 Component[] list = buttons.getComponents();
		 for(int i=0;i<list.length;++i){
			if(!(list[i] instanceof JButton)) continue;
			JButton b = (JButton)list[i];
			b.setEnabled(b.getAction().isEnabled());
		}
	}
	public void removeSelected(){
		int index = getSelectedIndex();
		getSelectedItem().unload();
		list.remove(index);
		getThis().fireTableChanged(new TableModelEvent(getThis(), index, index, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
		//
		if(index >= list.size())index=list.size()-1;
		if(index>=0) table.getSelectionModel().setSelectionInterval(index,index);
	}

	//////////////////////////////////////////////////////////
	// ボタン類
	Action[] button_actions = new Action[]{
		new AbstractAction("保存ファイル名..."){
			public boolean isEnabled(){
				DCCReceiveItem item = getSelectedItem();
				return item==null?false:item.canRename();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				DCCReceiveItem item = getSelectedItem();
				item.renameDialog();
			}
		},
		new AbstractAction("受信"){
			public boolean isEnabled(){
				DCCReceiveItem item = getSelectedItem();
				return item==null?false:item.canStart();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				getSelectedItem().startReceive();
			}
		},
		new AbstractAction("再開"){
			public boolean isEnabled(){
				DCCReceiveItem item = getSelectedItem();
				return item==null?false:item.canResume();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				getSelectedItem().resume();
			}
		},

		new AbstractAction("中止"){
			public boolean isEnabled(){
				DCCReceiveItem item = getSelectedItem();
				return item==null?false:item.canStopReceive();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				getSelectedItem().stopReceive();
			}
		},
		new AbstractAction("保存フォルダを開く"){
			public boolean isEnabled()
			{ return getSelectedIndex()!=-1; }
			public void actionPerformed(ActionEvent e)
			{ if(isEnabled()) getSelectedItem().openFolder(); }
		},
		new AbstractAction("削除"){
			public boolean isEnabled(){
				DCCReceiveItem item = getSelectedItem();
				return item==null?false:item.canRemove();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				removeSelected();
			}
		},
		null,
		new AbstractAction("標準の設定"){
			public void actionPerformed(ActionEvent e)
			{ new DCCReceiverDialog(); }
		},
		new AbstractAction("受信器を閉じる"){
			public void actionPerformed(ActionEvent e)
			{ hide(); }
		},
	};
}

/////////////////////////////////////////////////////////////////
// 設定ダイアログ

class DCCReceiverDialog extends DialogBase{
	public DCCReceiverDialog(){
		super();
		App.root_property.setDefaultObject("DCCReceiver",new HashMap());
		setup(App.getApp(),item_list);
	}
	protected void CheckInputs_ok(){ setTitle( "DCC受信器の設定" ); }
	protected ConnTreeNode createNode(){ return null;}

	DialogEditItem[] item_list = new DialogEditItem[]{
		new DialogEditItem_TabSeparator("オプション"),
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "DCCReceiver/NoPopupOnRequest";}
			public String getCaption(){ return "通知を受けたときに受信器を自動表示しない";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "DCCReceiver/DefaultSaveDirectory";}
			public String getCaption(){ return "保存位置";}
			public String getDesc(){ return "デフォルトの保存位置";}
			public  int getFileSelectionMode(){ return JFileChooser.DIRECTORIES_ONLY;}
		},
		new DialogEditItem_Button(){
			public String getCaption(){ return "無視する相手...";}
			public void actionPerformed(java.awt.event.ActionEvent e){
				ConnTreeNode node = getNode();
				if(node==null) return;
				String key="DCCReceiver/ignoreMask";
				node.property.setDefaultObject(key,new LinkedList());
				new PropertyInspector(node.property,"DCC受信を無視する相手",key,true,false,false);
				CheckInputs();
			}
		},
/*
		new DialogEditItem_Button(){
			public String getCaption(){ return "許可する相手...";}
			public void actionPerformed(java.awt.event.ActionEvent e){
				ConnTreeNode node = getNode();
				if(node==null) return;
				String key="DCCReceiver/trustMask";
				node.property.setDefaultObject(key,new LinkedList());
				new PropertyInspector(node.property,"DCC受信を自動開始する相手",key,true,false,false);
				CheckInputs();
			}
		},
*/
	};
};

class MyCellRendererD implements TableCellRenderer{
	Font f= new Font("Dialog",0,12);
	public MyCellRendererD(){}
	TableCellRenderer orig= new DefaultTableCellRenderer();

	public void updateUI(){
		((JComponent)orig).updateUI();
	}

	public Component getTableCellRendererComponent
	(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column)
	{
		JLabel c = (JLabel)orig.getTableCellRendererComponent
			( table, value, isSelected, hasFocus, row, column);

		switch(table.convertColumnIndexToModel(column)){
		case 3: case 4: case 6:
			c.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
			c.setHorizontalAlignment(JLabel.RIGHT);
			break;
		default:
			c.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT );
			c.setHorizontalAlignment(JLabel.LEFT);
			break;
		}
		c.setFont(f);
		return c;
	}
};

class MyCellRendererH implements TableCellRenderer{
	TableCellRenderer orig;
	MyCellRendererH(TableCellRenderer orig){
		this.orig=orig;
	}
	public void updateUI(){
		((JComponent)orig).updateUI();
	}
	public Component getTableCellRendererComponent
	(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column)
	{
		JLabel c = (JLabel)orig.getTableCellRendererComponent
			( table, value, isSelected, hasFocus, row, column);

		switch(table.convertColumnIndexToModel(column)){
		case 3: case 4: case 6:
			c.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
			c.setHorizontalAlignment(JLabel.RIGHT);
			break;
		default:
			c.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT );
			c.setHorizontalAlignment(JLabel.LEFT);
			break;
		}
		c.setFont(table.getFont());
		return c;
	}
};

