package gui;
// UTF-8 ☀☁☂☃

import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;


public class OneLineDialog 
extends JDialog
{
	JTextField tf;
	OneLineDialogListener listener;

	public void apply(){
		listener.apply(tf.getText());
		hide();
		dispose();
	}

	public void cancel(){
		hide();
		dispose();
	}

	public OneLineDialog(
		JFrame parent
		,String title
		,String Caption
		,String def
		,OneLineDialogListener listener
	){
		super(parent);
		this.listener=listener;
		setTitle(title);

		JLabel l = new JLabel(Caption);
		l.setBackground(java.awt.SystemColor.control);

		tf = new JTextField(def);
		tf.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){ apply(); }
		});

		JButton btnOK = new JButton("OK");
		btnOK.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){ apply(); }
		});

		JButton btnCancel = new JButton("キャンセル");
		btnCancel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				cancel();
			}
		});

		setBackground(java.awt.SystemColor.control);
		setForeground(java.awt.SystemColor.controlText);
		tf.setBackground(java.awt.SystemColor.window);
		tf.setForeground(java.awt.SystemColor.windowText);

		JPanel buttons_panel=new JPanel();
		buttons_panel.add(btnOK);
		buttons_panel.add(btnCancel);

		JPanel p2=new JPanel();
		p2.setLayout(new BorderLayout());
		p2.add(l,BorderLayout.NORTH);
		p2.add(tf,BorderLayout.CENTER);
		p2.add(buttons_panel,BorderLayout.SOUTH);

		getContentPane().add(p2);

		validate();
		setSize(p2.getPreferredSize());
		validate();
		pack();
		setResizable(false);
		pack();
		Dimension dim = getToolkit().getScreenSize();
		Dimension sz = getSize();
		setLocation(new Point(
			 (dim.width-sz.width) / 2
			,(dim.height-sz.height )/ 2 
		));
		show();
	}
}
