<?php
// $Id: dailycont.php,v 1.00 2010/10/26 11:54:03 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                      BmSurvey - Bluemoon Multi-Survey                     //
//                   Copyright (c) 2005 - 2010 Bluemoon inc.                 //
//                       <http://www.bluemooninc.biz/>                       //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
include '../../../include/cp_header.php';
/*
** Prototype for daily count
*/
function getDailyResponce($surveyid=0,$ym,$charto,$charfrom){
    global $xoopsDB;
	$sql = "SELECT r.survey_id, Left( `submitted` , 8 ) AS `day` , Count( r.id ) AS dailycount, s.title as title"
		. " FROM " . $xoopsDB->prefix('bmsurvey_survey') . " s "
		. " INNER JOIN " . $xoopsDB->prefix('bmsurvey_response') . " r ON s.id = r.survey_id"
		. " GROUP BY r.survey_id, Left( `submitted` , 8 ) , s.title"
		. " ORDER BY r.survey_id DESC , Left( `submitted` , 8 ) DESC";
    $result = $xoopsDB->query($sql);
	while ($row = $xoopsDB->fetchArray($result)){
		$row['day'] = str_replace("-","", $row['day']);
		if ( substr($row['day'],0,6) == $ym ){
			$row['day'] = preg_replace("/^(\d{4})(\d{2})(\d{2})$/", "$1/$2/$3", $row['day'] );
			$row['title'] = mb_convert_encoding($row['title'],$charto,$charfrom);
			$ret[]=$row;
		}
    }
    return $ret;
}
/*
** admin check
*/
if(
	(!defined('XOOPS_ROOT_PATH')) || 
	(!is_object($xoopsUser)) || 
	(!$xoopsUser->isAdmin()) ){
	exit();
}
/*
** CSV output
*/
$ym = $_GET['ym'] ? intval($_GET['ym']) : date("Y").date("m");
$name = "dailycount";
$csv_charset = "SJIS";		//$GLOBALS['ESPCONFIG']['csv_charset'];
$charfrom = "EUC-JP";	//_CHARSET
header("Pragma: private");
header("Cache-Control: public");
header("Content-Transfer-Encoding: ".$csv_charset);
header("Content-Disposition: attachment; filename=$name.csv");
header("Content-Type: text/comma-separated-values");

// output header 
$header = array('sid','date','count','title');
echo(join(',', $header) . "\n");
// output body 
$output = getDailyResponce(0,$ym,$csv_charset,$charfrom);
foreach ($output as $row ) {
	echo(join(',', $row) . "\n");
}
?>