//---------------------------------------//
//-----䕔----------------------------//
//-----2003.6.10-------------------------//
//--Last Modified By umeda-kushibiki-----//

package bou_n_sha.wana.control;

import bou_n_sha.network.*;
import bou_n_sha.wana.data.*;
import bou_n_sha.wana.data.character.*;
import bou_n_sha.wana.data.item.*;
import bou_n_sha.wana.data.room.*;
import bou_n_sha.wana.view.*;
import bou_n_sha.io.*;

import java.io.*;
import java.util.*;


/**
 * T[o[̐NX
 * @author	Masanori Nakashizu
 *
 */
public class WanaClient implements KeyboardControler,ClientControler,IWanaClient{
  
  private String        playerName = "";
  private String        serverMessage = "";
  private String        keyMessage = "";
  private String        com = "";//R}h(commandoDvision\bhŎgp)
  private int           rn;//R}h(commandoDvision\bhŎgp)
  private int           objID;//R}h(commandoDvision\bhŎgp)
  private int           selectCharacterNum;//ILN^[̔ԍ
  private boolean       startFlg = false;
  
  GameFrame		gf = null;
  PlayerControl	pc = null;
  SocketClient	sc;
  Room			currentRoom;
  Room			monitoredRoom;
  RoomMap	   	roomMap;
  private HashMap      animationList = new HashMap();
  
  /**
   * SocketClientCX^VGCg܂B
   *
   */
  public WanaClient(){
    roomMap 		= new RoomMap(1); //eXĝ߂ЂƂ̂̕
    currentRoom 	= roomMap.getRoom(0);
    monitoredRoom 	= roomMap.getRoom(0);
    String ip = "";
    
    gf = new GameFrame();
    playerName = gf.playerNameDialog(); //vC[͉ʂ̕\
    selectCharacterNum  = gf.characterSelectDialog(); //LN^[Iʂ̕\
    
    try{
      /* vpeBt@C̃pXnēǂݍ */
      Properties prop = new Properties();
      prop.load(new FileInputStream("bou_n_sha/wana/control/wana.conf"));
      //prop.load(new FileInputStream("wana.conf"));
      ip = prop.getProperty("ip");
    }catch(Exception e){
      e.printStackTrace();
    }

    sc = new SocketClient(ip,5555); //\PbgNCAg
    sc.setClientControler(this);
    
    this.gameInit();
  }
  
  /**
   * WanaClientmain
   */
  public static void main(String[] arg){
    WanaClient 	cg	=	new WanaClient(); //䕔
  }
  
  /**	
   * T[oɃbZ[W𑗂
   * @param str M郁bZ[W
   */
  public void sendMessage(String sendMessage){
    sc.send(sendMessage);
  }
    
  /**
   * Q[JnɃT[o[ɎQ邱Ƃ`
   */
  private void gameInit(){
    String scn = WanaUtil.normalization(selectCharacterNum,WanaNetworkProtcol.ROOM_NUMBER + WanaNetworkProtcol.OBJ_NUMBER);
    String len = WanaUtil.normalization(playerName.length(),WanaNetworkProtcol.MSG_NUMBER);
    String str = WanaNetworkProtcol.START + scn + len + playerName;
    
    sendMessage(str);
  }
  
  /**
   * ꂽL[̔f(Client)
   * @param keyMessage L[͂ꂽbZ[W(Jr)
   */
  public void catchKeyControl(String msg){
    keyMessage = msg;
    pc.sendToGameObject(keyMessage);
    //gf.repaintID(); //eXgpiv폜j
  }

  /**
   * `bg_CAO\A͕
   * `[`bgAS̃`bgA`bgR}h𔻒f܂(Client)
   */
  public void catchKeyChat(){
    String chatMessage=gf.goChatMode();
    if(!chatMessage.equals("")){
      switch(chatMessage.charAt(0)){
      case '*':
        teamChat(chatMessage.replaceAll("^.",""));
        break;
      case '/':
        chatCom(chatMessage.replaceAll("^.",""));
        break;
      default:
        zenChat(chatMessage);
      }
    }
    chatMessage="";
  }
  
  /**
   * `bgR}h̎̓()
   * @param str `bgbZ[W
   */
  public void chatCom(String str){
    sc.send(WanaNetworkProtcol.CONTROL + str);
  }
  
  /**
   * `[`bg̎̓()
   * @param str `bgbZ[W
   */
  public void teamChat(String str){
    sc.send(WanaNetworkProtcol.TEAMCHAT + str);
  }
  
  /**
   * S̃`bg̎̓()
   * @param str `bgbZ[W
   */
  public void zenChat(String str){
    str = "00000" + WanaUtil.normalization(str.length(),3) + str;
    sc.send(WanaNetworkProtcol.CHAT + str);
  }
  
  /**
   * T[o[f[^󂯎󂯎Q[NbNbZ[WAfB
   * bZ[WłȂ1bZ[WƂɕB
   * @param str T[o[̃f[^
   */
  public void receiveServerMessage(String str){
    if(str.equals("g")){
      this.receiveClock();
    }else{
      serverMessage = str;
      while(!serverMessage.equals("")){
        int len = 0;
        try{
          len = WanaNetworkProtcol.TOTAL_MSG4 + Integer.parseInt(serverMessage.substring(WanaNetworkProtcol.TOTAL_MSG3,WanaNetworkProtcol.TOTAL_MSG4),36);
          this.messageDistribute(serverMessage.substring(0,len));
          serverMessage = serverMessage.substring(len);
        }catch(NullPointerException e){
			e.printStackTrace();
          System.out.println("reciveServerMessageG[");
        }
      }
    }
  }
  
  /**
   * bZ[W̏e𔻒fe\bhɃbZ[WzzB
   * @param str bZ[W
   */
  public void messageDistribute(String str){
    String oneMessage = str;
    this.commandDivision(oneMessage);
    switch(oneMessage.charAt(0)){
    case WanaNetworkProtcol.START:
      this.receiveStart(rn,objID,com);
      break;
    case WanaNetworkProtcol.END:
      this.receiveEnd(rn,objID);
      break;
    case WanaNetworkProtcol.MAKE_OBJECT:
      this.receiveMakeObject(rn,objID,com);
      break;
    case WanaNetworkProtcol.CONTROL:
      this.receiveControl(rn,objID,com);
      break;
    case WanaNetworkProtcol.CONTROL_PC:
      this.receiveControlPC(rn,objID,com);
      break;
    case WanaNetworkProtcol.CHAT:
      this.receiveChat(com);
      break;
    }
  }

  /**
   * bZ[W𕔉ԍAIuWFNgIDAR}hɕ鏈sB
   * @param str bZ[W
   */
  private void commandDivision(String str){
    try{
      rn = Integer.parseInt((str.substring(WanaNetworkProtcol.CNT_NUMBER,WanaNetworkProtcol.CNT_NUMBER + WanaNetworkProtcol.ROOM_NUMBER)),36);//ԍ
      objID = Integer.parseInt((str.substring(WanaNetworkProtcol.TOTAL_MSG2,WanaNetworkProtcol.TOTAL_MSG3)),36);//IuWFNgID
      com = str.substring(WanaNetworkProtcol.TOTAL_MSG4);//R}h(ߕ)
    }catch(Exception e){
      System.out.println("commandDivisionG[");//e.printStackTrace();
    }
  }
  
  /**
   * 䕶(s...)󂯎ۂ
   * vC[LN^[AvC[Rg[AL[͂쐬
   * @param roomNum ԍ
   * @param objectID IuWFNgID
   * @param command 䃁bZ[W
   */
  public void receiveStart(int roomNum,int objectID,String command){
    int x = Integer.parseInt((command.substring(0,2)),36);
    int y = Integer.parseInt((command.substring(2,4)),36);
    
    pc = new PlayerControl(roomMap.getRoom(roomNum),playerName,selectCharacterNum,objectID,x,y,this);
    gf.frameInit(currentRoom,pc);//Q[t[Q[ʂɐݒ肷
    gf.sendPlayerListDisplay(playerName,objectID);
    KeyControl kc	=	new KeyControl(gf,"KeyMessageThread");	//L[Rg[
    kc.setInterface(this);
    kc.start();
    startFlg = true;

    RepaintDisplay rp = new RepaintDisplay(this,gf);
    rp.start();
    
    gf.repaintSD();
    gf.repaintID();
    gf.repaintPLD();
  }
  
  /**
   * LN^[폜
   * @param roomNum ԍ
   * @param objId IuWFNgID
   */
  public void receiveEnd(int roomNum,int objectID){
    roomMap.getRoom(roomNum).removeObject(objectID);
    gf.sendPlayerListDisplay(objectID);
    gf.repaintPLD();
  }
  
  /**
   * 䕶(k...)󂯎ۂɃIuWFNg쐬
   * @param roomNum ԍ
   * @param objId IuWFNgID
   * @param command 䃁bZ[W
   */
  public void receiveMakeObject(int roomNum,int objectID,String command){
    //쐬IuWFNg̃LN^[ꍇ͍쐬Ȃ(receiveStartō쐬ς)
    if(objectID != pc.getObjectID()){
      GameObject object = null;
      String imageKey = command.substring(1,5);
      
      int x = Integer.parseInt((command.substring(5,7)),36);
      int y = Integer.parseInt((command.substring(7,9)),36);
      
      //R}h쐬IuWFNg̎ނ𔻕
      switch(command.charAt(0)){
      //LN^[
      case WanaNetworkProtcol.OBJ_CHARACTER:
        switch(imageKey.charAt(0)){
        /*case '0':
          object = new GreenMan(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        case '1':
          object = new BlackMan(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        case '2':
          object = new T_no(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;*/
        case '0':
          object = new T_no(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
		case '1':
          object = new U_da(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        default:
          object = new GreenMan(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        }
        roomMap.getRoom(roomNum).addObject(object,x,y);
        gf.sendPlayerListDisplay(command.substring(9),objectID);
        gf.repaintPLD();
        object.setWanaClient(this);
        break;
      //Ƌ([IuWFNg)
      case WanaNetworkProtcol.OBJ_ROOM:
        switch(imageKey.charAt(0)){
        case '0':
          object = new Box(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        default :
          object = new Box(objectID,imageKey.substring(2),roomMap.getRoom(roomNum));
          break;
        }
        roomMap.getRoom(roomNum).addObject(object,x,y);
        object.setWanaClient(this);
        break;
      //ACe
      case WanaNetworkProtcol.OBJ_ITEM:
        switch(imageKey.charAt(0)){
        case '0':
          object = new Blade(objectID,roomMap.getRoom(roomNum));
          break;
        case '1':
          object = new Bomb(objectID,roomMap.getRoom(roomNum));
        default:
          break;
        }
        roomMap.getRoom(roomNum).addObject(object,x,y);
        object.setWanaClient(this);
        break;
        //IuWFNgɎd|ĂACe
      case WanaNetworkProtcol.OBJ_ROOMITEM:
        PortableItem itemObject=null;
        switch(imageKey.charAt(0)){
          case '0':
            itemObject = new Blade(objectID,null);
            break;
          case '1':
            itemObject = new Bomb(objectID,null);
            break;
          default:
            itemObject = null;
            break;
          }
        itemObject.setWanaClient(this);
        int roomObjectID = Integer.parseInt((command.substring(9)),36);
        ((RoomObject)roomMap.getRoom(roomNum).callObject(roomObjectID)).setItemFlag(itemObject);
        break;
        //IuWFNgɎd|Ă
      case WanaNetworkProtcol.OBJ_SETTRAP:
        itemObject=null;
        switch(imageKey.charAt(0)){
          case '0':
            itemObject = new Blade(objectID,null);
            break;
          case '1':
            itemObject = new Bomb(objectID,null);
            break;
          default:
            itemObject = null;
            break;
          }
        itemObject.setWanaClient(this);
        roomObjectID = Integer.parseInt((command.substring(9)),36);
        (roomMap.getRoom(roomNum).callObject(roomObjectID)).setTrapObject((Trap)itemObject);
        break;
	  default:
        break;
      }
	}
  }
  
  /**
   * 䕶(c...)󂯎ۂ
   * objIDGameObjectmsgn
   * @param roomNum ԍ
   * @param objId IuWFNgID
   * @param command 䃁bZ[W
   */ 
  public void receiveControl(int roomNum , int objectID , String command){
    try{
	  if((command.substring(0,WanaNetworkProtcol.ACT_NUMBER)).equals(WanaNetworkProtcol.ACT_SCORE)){
	  	gf.setPlayersScore((Integer.parseInt(command.substring(WanaNetworkProtcol.ACT_NUMBER),36)),objectID);
	  }
      roomMap.getRoom(roomNum).callObject(objectID,command);
      gf.repaintSD();
      gf.repaintID();
      gf.repaintPLD();
      pc.clearBufferMessage();
    }catch(Exception e){
      e.printStackTrace();
      System.out.println("Ɏs܂.");
    }
  }

  /**
    *䕶(p)󂯎ۂɃvC[Rg[𒼐ڑ삷
    */
  public void receiveControlPC(int roomNum,int objectID , String command){
    pc.removeItem();
  }
  
  /**
   * 䕶(z...)󂯎ۂɃ`bgbZ[Wʂɕ\
   * @param str `bgbZ[W
   */
  public void receiveChat(String str){
    try{
      gf.showChatMessage(str);
    }
    catch(Exception e){
      System.out.println("Ɏs܂.");
    }
  }

  /**
   * Q[NbN󂯎̏B
   * yCgĉʂXVvC[̃bZ[WT[oɑ
   */
  public void receiveClock(){
    if(startFlg){
      if(!pc.getCommand().equals("")){
        this.sendMessage(pc.getCommand());
        pc.clearCommand();
      }
    }
  }

  /**
    *
	*ItemDisplayyCg
    */
  public void repaintItemDisplay(){
    gf.repaintID();
  }

/**
 *yCgƌĂ΂֐
 */
  public void repaintSignal(){

    if(!animationList.isEmpty()){
      GameObject gameObject = null;
      Set set = animationList.entrySet();
      Iterator itr = set.iterator();

      String gameObjectID="";

      while(itr.hasNext()){
        Map.Entry entry = (Map.Entry)itr.next();
        gameObject = (GameObject)entry.getValue();
        if(gameObject.startAnimation()){
          gameObjectID=gameObjectID + WanaUtil.normalization(gameObject.getObjectID(),3);
        }
      }

      while(!gameObjectID.equals("")){
        GameObject go;
        int intID;
        intID=Integer.parseInt(gameObjectID.substring(0,3),36);

        go = (GameObject)animationList.get(new Integer(intID));
        if(go instanceof GameCharacter){
          ((GameCharacter)go).setStatus(0);
        }else if(go instanceof Trap){
          Room room = go.getCurrentRoom();
          room.removeObject(go.getObjectID());
        }

        animationList.remove(new Integer(intID));
        gameObjectID = gameObjectID.substring(3);
      }
    }
  }

  /**
    *Aj[VXgꗗɃQ[IuWFNg
	*@param	go	GameObject
    */
  public void addAnimationList(GameObject go){
    animationList.put(new Integer(go.getObjectID()),go);
  }
}

/**
  *摜NX
  */
class RepaintDisplay extends Thread
{
  WanaClient wanaClient = null;
  GameFrame gameFrame;
  
  RepaintDisplay(WanaClient wc,GameFrame gf){
    super("RepaintThread");
    gameFrame = gf;
    wanaClient = wc;
  }

  public void run(){
    while(true){
      try{
        if(gameFrame.goRepaint()){
          wanaClient.repaintSignal();
        }
        Thread.sleep(33); //30fpsł
      }catch(InterruptedException e){
      }
    }
  }
}