//eXgp̃LN^NX
package bou_n_sha.wana.data.character;

import bou_n_sha.wana.data.*;
import bou_n_sha.wana.data.item.*;
import bou_n_sha.wana.control.*;

import java.util.*;
/**
 * LN^[̒ۃNX
 */
public abstract class GameCharacter extends GameObject implements IGameCharacter{
   /**
   * LN^[̌Ă
   */
  protected int direction = 0;//:0,:1,E:2,:3
   /**
   * LN^[̂go
   */
  protected int characterHP;
  /**
   * LN^[̂so
   */
  protected int characterTP;

  private int status = 0; //0:Ă,1:,2:HAj[V,3:UAj[V
  private int count = 0;
  private int animationCount = 0;
  private SetItemInterface si = null;
  
  private int playerScore = 0;
 
  /**
   * L[Lb`bZ[W̐U蕪
   * ꂼ̃ANVɑ΂郁bZ[WԂ
   * @return	ړbZ[W
   */
  public String catchPlayerMessage(String keyMessage){
    //Lb`bZ[WMOVEꍇ
    if(keyMessage.equals("MOVE_UP")){
      keyMessage = moveObject(0,-1,0);
    }
    else if(keyMessage.equals("MOVE_DOWN")){
      keyMessage = moveObject(0,1,1);
    }
    else if(keyMessage.equals("MOVE_RIGHT")){
      keyMessage = moveObject(1,0,2);
    }
    else if(keyMessage.equals("MOVE_LEFT")){
      keyMessage = moveObject(-1,0,3);
    }
    return keyMessage;
  }

  /**
    *ACe擾̔
	*@return	LN^[̑OɂIuWFNg
    */
   public GameObject frontCheck(){
    int x = getX();
    int y = getY();

     switch(direction){
     case 0:
       y--;
       break;
     case 1:
       y++;
       break;
     case 2:
       x++;
       break;
     case 3:
       x--;
       break;
     default:
       break;
     }
     
     GameObject gameObject = getCurrentRoom().getObjectAt(x,y);
     
     return gameObject;
  }

  /**
    *IuWFNg̈ړ
	*@return	ړbZ[W
    */
  public String  moveObject(int moveX, int moveY,int d){
    int x = getX();
    int y = getY();
    String str;
    
    String strRoomNum = WanaUtil.normalization(getRoomNum(),WanaNetworkProtcol.ROOM_NUMBER);
    String objID = WanaUtil.normalization(getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
    //̔
    if(d != direction){
      direction = d;
      String strDirection = Integer.toString(direction);
      String strLen = WanaUtil.normalization(strDirection.length()+WanaNetworkProtcol.ACT_NUMBER,WanaNetworkProtcol.MSG_NUMBER);
      str = (WanaNetworkProtcol.CONTROL + strRoomNum + objID + strLen + WanaNetworkProtcol.ACT_DIRECTION + strDirection );
    }else{
      x = x + moveX;
      y = y + moveY;
      
      if(getCurrentRoom().moveJudgment(this,x,y)){
        str = "false";
      }else{
        String strX = WanaUtil.normalization(x,2);
        String strY = WanaUtil.normalization(y,2);
        String strLen = WanaUtil.normalization(WanaNetworkProtcol.ACT_NUMBER+strX.length()+strY.length(),WanaNetworkProtcol.MSG_NUMBER);
        str = (WanaNetworkProtcol.CONTROL +  strRoomNum + objID + strLen + WanaNetworkProtcol.ACT_MOVE + strX + strY);
      }
    }
    
    return str;
  }

/**
  *roomcallObjectĂяo
  *@param	LN^[ɑ΂ANV̏
  */
  public void catchCommand(String str){
    String strCommand = str.substring(0,WanaNetworkProtcol.ACT_NUMBER);
    if(strCommand.equals(WanaNetworkProtcol.ACT_MOVE)){//ړ
      x = Integer.parseInt((str.substring(2,4)),36);
      y = Integer.parseInt((str.substring(4,6)),36);
      
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_DIRECTION)){//]
      this.setDirection(Integer.parseInt((str.substring(WanaNetworkProtcol.ACT_NUMBER)),36));
      
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_ATTACK)){//U(T[ôݎdl)
      this.damage(Integer.parseInt(str.substring(WanaNetworkProtcol.ACT_NUMBER),36));
      
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_SETHP)){//HPύX
      this.setHitPoint(Integer.parseInt(str.substring(WanaNetworkProtcol.ACT_NUMBER),36));
      
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_STAT)){
      this.setStatus(Integer.parseInt(str.substring(WanaNetworkProtcol.ACT_NUMBER),36));
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_SCORE)){
	  this.setPlayerScore(Integer.parseInt(str.substring(WanaNetworkProtcol.ACT_NUMBER),36));
    }
  }

  /**
   * Q[LN^[ɑ΂ANVɂbZ[W
   * @return	"false"Ԃ
   */
  public String actionMessage(GameCharacter gc){
    return "false";
  }

  /**
    *Zbg郁\bh
	*@param	d	ԍ
    */
  public void setDirection(int d){
    direction = d;
    imageKey = imageKey.substring(0,imageKey.length()-2) + "0" + (d+1);
  }

  /**
    *_[W󂯂ƂAqbg|CgiT[opj
    *@param damage _[W
    */
  public void damage(int damage){
    characterHP = characterHP - damage;
  }

  /**
    *ACeplayerRg[̃ACeɉ
	*@param	item	tACe
    */
  public void setItem(GameObject item){
    if(si!=null){
      si.setItem(item);
    }
  }

  /**
   *playerRg[̕헓ɉ
   *@param	镐
   */
  public void setWeapon(Weapon weapon){
    if(si!=null){
      si.setCurrentWeapon(weapon);
    }
  }

  /**
    *݂̕󂯎
	*@return	݌Ă
    */
  public int getDirection(){
    return direction;
  }
   
  /**LN^[HPZbg
   *@param hitpoint HP
   */
  public void setHitPoint(int hitpoint){
    characterHP = hitpoint;
  }
	
  /**LN^[̃eVZbg
   *@param tension eV
   */
  public void setTensionPoint(int tension){
    characterTP = tension;
  }
  
  /**LN^[HPԂ
   *@return ݂̃LN^[HP
   */
  public int getHitPoint(){
    return characterHP;
  }
  
  /**LN^[̃eVԂ
   *@return ݂̃LN^[̃eV
   */
  public int getTensionPoint(){
    return characterTP;
  }

  /**
    *݂̃Xe[^XZbg
    *@param	setStat	Xe[^Xԍ
    */
  public void setStatus(int setStat){
    String deadImage;
    
    switch(setStat){
    case 0:
      if(status==1){ this.setHitPoint(getMaxHp()); }
      
      deadImage = imageKey.substring(0,imageKey.length()-2) + WanaUtil.normalization(direction+1,2);
      setImageKey(deadImage);
      break;
    case 1:
      this.setHitPoint(0);
      deadImage = imageKey.substring(0,imageKey.length()-2) + "05";
      setImageKey(deadImage);
      if(si!=null) si.setDefaultWeapon();
      count = 200;
      break;
    case 2:
      if(wana != null){
        anim.initAnimation(2);
        wana.addAnimationList(this);
      }
      break;
    case 3:
      if(wana != null){
        anim.initAnimation(1);
        wana.addAnimationList(this);
      }
      break;
    default:
      break;
    }
    status = setStat;
  }
  /**
   * ݂̃Xe[^XƎ擾
   * @return	Xe[^Xԍ
   */
  public int getStatus(){
    return status;
  }

  /**
   * cJEgԂ
   * @return	cJEg
   */
  public int clockCount(){
    return --count;
  }
  
  /**
   * vC[̃XRAZbg
   */
  public void setPlayerScore(int score){
  	if(si != null){
  		si.setScore(score);
	}
  }
  /**
   * U͂擾
   * @return	U
   */
  public abstract int getAttackPoint();
  /**
   * HPől擾
   * @return	HPől
   */
  public abstract int getMaxHp();
  /**
   * TPől擾
   * @return	TPől
   */
  public abstract int getMaxTension();
  
  /**
   * LN^[̖O擾
   * @return	LN^[̖O
   */
  public abstract String getCharacterName();

/**
  *
  */
  public void setInterface(SetItemInterface setItemInterface){
    si=setItemInterface;
  }
}