package bou_n_sha.wana.view;

import bou_n_sha.wana.data.*;
import bou_n_sha.io.*;
import bou_n_sha.wana.data.character.*;
import bou_n_sha.wana.control.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;

/**
 * Q[t[𐶐NX
 */
public class GameFrame extends JFrame{

  GameDisplay	gameDisplay;		//\̃Rs[邽߂̕ϐ
  ItemDisplay   itemDisplay;
  PlayerListDisplay	playerListDisplay;
  StatusDisplay	statusDisplay;
  GameDisplay	monitorDisplay;
  GameFrame	gameFrame;		//t[̃Rs[邽߂̕ϐ
  GameCharacter gameCharacter;
  GraphicsLibrary graphicsLibrary;
  boolean lock = true;
	
/**
 * Q[̉摜[hB
 */
  public GameFrame(){
    super("test");
    //System.out.println("EBhE->N...");
    gameFrame = this;
    //摜[h
    graphicsLibrary = new GraphicsLibrary();
  }

  /**
   * Q[ʂɕKvȂ̂B
   * @param room Room̃CX^X
   * @param pc PlayerControl̃CX^X
   */
  public void frameInit(Room room,final PlayerControl pc){
    //鏈̓o^
    WindowAdapter wa = new WindowAdapter(){
      public void windowClosing(WindowEvent e){
        String str = WanaNetworkProtcol.END + WanaUtil.normalization(pc.getCurrentRoom().getRoomID(),WanaNetworkProtcol.ROOM_NUMBER);
        str = str + WanaUtil.normalization(pc.getObjectID(),3) + "000";
        pc.sendToServer(str);
        System.exit(0);
      }
    };
    gameFrame.addWindowListener(wa);
    
    //t[̐ݒ
    gameFrame.setSize(800,800);
    gameFrame.getContentPane().setLayout(new FlowLayout());
    gameFrame.setResizable(false);
    
    //Rei̐
    Container	container = gameFrame.getContentPane();
    BoxLayout	containerBox	= new BoxLayout(container,BoxLayout.Y_AXIS);
    container.setLayout(containerBox);
    
    //㕔pl̐ݒ
    JPanel upperPanel = new JPanel();	
    upperPanel.setLayout(new BoxLayout(upperPanel,BoxLayout.X_AXIS));
    
    //pl̐ݒ
    JPanel	underPanel = new JPanel();
    underPanel.setLayout(new BoxLayout(underPanel,BoxLayout.X_AXIS));
    
    //\̍쐬Ɠ\t
    //㕔pl
    gameDisplay = new GameDisplay(600,480,graphicsLibrary);
    gameDisplay.addRoom(room);
    gameDisplay.setFocusable(false);
    upperPanel.add(gameDisplay);
    
    itemDisplay = new ItemDisplay(200,480,pc,graphicsLibrary);
    itemDisplay.setFocusable(false);
    upperPanel.add(itemDisplay);
    
    container.add(upperPanel);
    
    //pl
    playerListDisplay = new PlayerListDisplay(180,280);
    playerListDisplay.setFocusable(false);
    underPanel.add(playerListDisplay);
    
    statusDisplay = new StatusDisplay(300,280,pc);
    statusDisplay.setFocusable(false);
    underPanel.add(statusDisplay);
    
    monitorDisplay = new GameDisplay(300,280,graphicsLibrary);
    monitorDisplay.addRoom(room);
    monitorDisplay.setFocusable(false);
    underPanel.add(monitorDisplay);
    
    container.add(underPanel);	

    //ꂼ̉ʂ̃_uobt@O
    gameDisplay.initGameDisplay();
    monitorDisplay.initGameDisplay();
    statusDisplay.initGameDisplay();
    playerListDisplay.initGameDisplay();
    itemDisplay.initGameDisplay();
    
    //EBhE
    gameFrame.setVisible(true);
  }
  
  /**
   * `bg[hɈȍ~B
   * @return	͂ꂽ`bgbZ[W
   */
  public String goChatMode(){
    //`bgEBhE̍쐬
    ChatDialog cd = new ChatDialog(gameFrame);
    return cd.getChatMessage();
  }
  
  /**
   * `bg̕ʂɕ\B
   * @param message `bg
   */
  public void showChatMessage(String message){
    gameDisplay.showChat(message);
  }

  /**
    * vC[XgfBXvCɕ\vC[𑗂B
    * @param plyaerName vC[
    * @param objectID IuWFNgID
    */
  public void sendPlayerListDisplay(String playerName, int objectID){
    playerListDisplay.setPlayerName(playerName,objectID);
  }
  
  /**
   * T[o瑗ĂevC[̓_Zbg
   * @param	score	_
   * @param	objectID	IuWFNgID
   */
   public void setPlayersScore(int score,int objectID){
   	playerListDisplay.setPlayersScore(score,objectID);
   }

  /**
    * vC[XgfBXvC폜vC[̃IuWFNgID𑗂B
    * @param objectID IuWFNgID
    */
  public void sendPlayerListDisplay(int objectID){
    playerListDisplay.clearPlayerName(objectID);
  }

  /**
    * vC[XgfBXvCȊỎʂ̃yCgsB
    * @return	yCgtrueAȂfalseԂ
    */
  public boolean goRepaint(){
    if(lock==true){
      lock = false;
      gameDisplay.repaintDisplay();
      monitorDisplay.repaintDisplay();
      lock = true;
      return true;
    }
    return false;
  }

  /**
   * vC[XgfBXvC̃yCgsB
   */
  public void repaintPLD(){
    playerListDisplay.repaintPLDisplay();
  }

  /**
    *ACefBXvC̃yCgs
    */
  public void repaintID(){
    itemDisplay.repaintIDisplay();
  }
  
  /**
    *Xe[^XfBXvC̃yCgs
    */
  public void repaintSD(){
    statusDisplay.repaintstDisplay();
  }
  
  /**
   * Nɕ\_CAOʂĂяoB
   * @return	_CAOʂɓ͂ꂽvC[l[
   */
  public String playerNameDialog(){
    PlayerNameInputDialog pnid = new PlayerNameInputDialog(gameFrame);
    return pnid.getPlayerName();
  }

  /**
    * LN^[IʂĂяo
    * @return	IꂽLN^[ԍ
    */
  public int characterSelectDialog(){
    CharacterSelect cs = new CharacterSelect(gameFrame,graphicsLibrary);
    return cs.getSelectCharacter();
  }
}

/**
 * vC[̓_CAONX
 */
class PlayerNameInputDialog extends JDialog{
  
  String playerName;
  JTextField tf;

  /**
   * RXgN^
   * @param parent GameFramẽCX^X
   */
  public PlayerNameInputDialog(GameFrame parent){
    super(parent,"vC[",true);
    
    //_CAO̐ݒ
    this.setSize(300,150);
    this.getContentPane().setLayout(new FlowLayout());
    this.setResizable(false);
    
    WindowAdapter wa = new WindowAdapter(){
      public void windowClosing(WindowEvent e){
        System.exit(0);
      }
    };
    
    //eLXg̓tB[h̐ݒƓ\t
    tf = new JTextField("",30);

    tf.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
        JTextField t = (JTextField)e.getSource();
        playerName=t.getText();
        setVisible(false);
      }
    });
    
    this.getContentPane().add(tf);
    this.pack();
    this.setVisible(true);
  }
  
  /**
   * ͂ꂽvC[Ԃ
   * @return	͂ꂽvC[
   */
  public String getPlayerName(){
    return playerName;
  }
}

/**
  * LN^[I_CAONX
  * 
  */
class CharacterSelect extends JDialog implements IMenuKeyControl{

  private int selectCharacterNum;//LN^[ԍ
  private int charaPersons = 2;//LN^[

  private String[][] particular = new String[8][6];
  
  private Image		myOffScreenImage;
  private Graphics	myOffScreenGraphics;
  private Dimension	offScreenSize;
  
  GraphicsLibrary graphicsLibrary;
  MenuKeyControl keyControl;
  
  /**
   * RXgN^
   * @param	parent	GameFramẽCX^X
   * @param gl	GraphicsLibrarỹCX^X
   */
  public CharacterSelect(GameFrame parent,GraphicsLibrary gl){
    super(parent,"LN^[I",true);
    graphicsLibrary = gl;
    selectCharacterNum = 0;
    
    try{
      Properties prop = new Properties();
      for(int i=0;i<charaPersons;i++){
        prop.load(new FileInputStream("bou_n_sha/wana/control/character"+ i + ".cha"));
        particular[i][0] = new String(prop.getProperty("s").getBytes("iso-8859-1"),"Shift_JIS");
        particular[i][1] = new String(prop.getProperty("name").getBytes("iso-8859-1"),"Shift_JIS");
        particular[i][2] = prop.getProperty("HP");
        particular[i][3] = prop.getProperty("TP");
        particular[i][4] = prop.getProperty("AT");
        particular[i][5] = prop.getProperty("SP");
      }
    }catch(Exception e){
      e.printStackTrace();
    }
    keyControl = new MenuKeyControl(this,"");
    keyControl.setInterface(this);
    keyControl.start();
    
    this.setSize(600,600);
    this.setVisible(true);
    repaint();
    
  }

  /**
   * L[͂ꂽbZ[Wɂď{yCg
   * @param	L[͂ꂽbZ[W
   */
  public void catchKeyControl(String keyMessage){
    if(keyMessage == "RIGHT" && charaPersons-1 != selectCharacterNum){
      selectCharacterNum = selectCharacterNum + 1;
    }else if(keyMessage == "LEFT" && 0 != selectCharacterNum){
      selectCharacterNum = selectCharacterNum - 1;
    }else if(keyMessage =="UP" && 0 <= selectCharacterNum - 4){
      selectCharacterNum = selectCharacterNum - 4;
    }else if(keyMessage == "DOWN" && charaPersons-1 >= selectCharacterNum + 4){
      selectCharacterNum = selectCharacterNum + 4;
    }else if(keyMessage == "OK"){
      setVisible(false);
    }
    repaint();
  }

  /**
   * IꂽLN^[ԍԂ
   * @return	IꂽLN^[ԍ
   */
  public int getSelectCharacter(){
    return selectCharacterNum;
  }
  
  /**
   * ʂɕ`
   * @para	g	Graphics̃CX^X
   */
  public void paint(Graphics g){
    g.setColor(Color.white);
    g.fillRect(0,0,600,600);
    for(int i=0;i<charaPersons;i++){
      if(i==selectCharacterNum){
        g.setColor(new Color(184,192,243));
        g.fillRoundRect((45+170*i),45,130,130,5,5);
        g.setColor(Color.white);
        g.fillRoundRect((48+170*i),48,124,124,5,5);
      }
      g.setColor(Color.white);
      g.fillRoundRect((50+170*i),50,120,120,5,5);
      g.drawImage(graphicsLibrary.getImage("chara" + i + "-00"),(52+170*i),52,116,116,this);
    }
    g.setColor(new Color(184,192,243));
    g.drawRoundRect(40,235,500,150,10,10);

    g.setColor(new Color(100,100,100));
    int drawPosition = 250;
    for(int j=0;j<6;j++){
      if(particular[selectCharacterNum][j].length() > 30){
        g.drawString(particular[selectCharacterNum][j].substring(0,30),125,(drawPosition + 20*j));
        drawPosition = drawPosition + 20;
        g.drawString(particular[selectCharacterNum][j].substring(30),125,(drawPosition + 20*j));
      }else{
        g.drawString(particular[selectCharacterNum][j],125,(drawPosition + 20*j));
      }
    }
    g.setColor(Color.black);
    g.drawString("",50,250);
    g.drawString("푰",50,drawPosition+20);
    g.drawString("HP",50,drawPosition+40);
    g.drawString("TP",50,drawPosition+60);
    g.drawString("U",50,drawPosition+80);
    g.drawString("Xs[h",50,drawPosition+100);
  }
  
  /**
   * ĕ`
   * @param	g	Graphics̃CX^X
   */
  public void update(Graphics g){
    Dimension d=getSize();
    
    if((myOffScreenImage == null) || (d.width != offScreenSize.width) || (d.height != offScreenSize.height)) {
      myOffScreenImage = createImage(d.width, d.height);
      offScreenSize = d;
      myOffScreenGraphics = myOffScreenImage.getGraphics();
    }
    
    paint(myOffScreenGraphics);
    g.drawImage(myOffScreenImage, 0, 0, this);
  }
}

/**
 * `bg_CAONX
 */
class ChatDialog extends JDialog{
  String chatMessage = "";
  ChatDialog(GameFrame parent){
    super(parent,"`bgEBhE",true);
    
    //_CAO̐ݒ
    this.setSize(300,150);
    this.getContentPane().setLayout(new FlowLayout());
    this.setResizable(false);
    
    //eLXg̓tB[h̐ݒƓ\t
    JTextField tf = new JTextField("",30);
    
    tf.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
        JTextField t = (JTextField)e.getSource();
        chatMessage=t.getText();
        setVisible(false);
      }
    });
    
    this.getContentPane().add(tf);
    this.pack();
    this.setVisible(true);
  }
  
  /**
   * ͂ꂽ`bgbZ[WԂ
   * @return	͂ꂽ`bgbZ[W
   */
  public String getChatMessage(){
    return chatMessage;
  }
}
