package bou_n_sha.wana.view;

import bou_n_sha.wana.control.*;
import bou_n_sha.wana.data.*;
import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.util.*;

/**
 * Canvasɕ\ItemGraphics
 * 
 * @author	Yudai Tomono
 */
class ItemDisplay extends Canvas{
  GraphicsLibrary		graphicsLibrary;
  private	String[]	itemString;
  public	int			canvasX;
  public	int			canvasY;
  PlayerControl 		playerControl;
  GameObject 			go;
  Image image;

  //BufferStrategyɊւ
  //http://www5.airnet.ne.jp/sakuraba/java/laboratory/JDK1.4/Graphics/BufferStrategy/BufferStrategy.html
  private BufferStrategy bs;

  private int x;
  private int y;
  
  private int			itemID;
  private int			itemNumber;
  private int			index;
  int objID;
  
  /**
   * CharacterStatus\邽߂Canvas𐶐
   * @param	sizeX	Canvas̏c̒iPʁFpixelj
   * @param	sizeY	Canvas̉̒iPʁFpixelj
   * @param	pc		PlayerControlNX̃CX^X
   */
  public ItemDisplay(int sizeX,int sizeY,PlayerControl pc, GraphicsLibrary gl){
    playerControl = pc;
    graphicsLibrary = gl;
    canvasX = sizeX;
    canvasY = sizeY;
    this.setSize(sizeX,sizeY);
  }

   /**
    *BufferStrategy𗘗p邽߂̏s
    */
  public void initGameDisplay(){
    try{
      this.createBufferStrategy(2);
      bs = getBufferStrategy();
    }catch(IllegalStateException ex){
      ex.printStackTrace();
      System.exit(0);
    }
  }
  
  /**
   * GameFramerepaint߂Ƃ̎se
   * 
   */
  public void repaintIDisplay(){
    repaint();
  }
  
  /**
   *yCgI[o[Ch
   */
  public void repaint(){
    Graphics2D g = (Graphics2D)bs.getDrawGraphics();
    if(!bs.contentsLost()){
      
      //wiœhԂ
      g.setColor(Color.darkGray);
      g.fillRect(0,0,canvasX,canvasY);
      g.setColor(Color.white);
      Font f = new Font("Serif",Font.PLAIN,30);
      g.setFont(f);
      g.drawString("Item List", 10, 30);
      g.drawString("WEAPON", 10, 300);
      f = new Font("Serif",Font.PLAIN,20);
      g.setFont(f);
      
      x = 35;
      y = 40;
      
      ArrayList al = playerControl.getItemList();

      for(int i=0;i<al.size();i++){
        if(i!=0){
          go = (GameObject)al.get(i);
          image = graphicsLibrary.getImage(go.getImageKey());
          
          g.drawImage(image,x,y,30,30,this);
          g.drawString(go.getImageKey(),x,y+55);//{̓ACe̎ce[h\
        }

        x = x + 50;
        if((canvasX-35) < (x+30)){
          x = 35;
          y = y+75;
        }
      }

      int currentItemPos = playerControl.getCurrentItemPos();
      g.drawRoundRect(30+(50*(currentItemPos%3)),35+(75*(currentItemPos/3)),40,40,5,5);
      
	  String weaponImageKey = playerControl.getCurrentWeapon().getImageKey();
	  if(weaponImageKey != ""){
	  	image = graphicsLibrary.getImage(weaponImageKey);
	  	g.drawImage(image,35,310,60,60,this);
	  }
      
      bs.show();
      g.dispose();
    }
  }
}