package bou_n_sha.wana.view;

import bou_n_sha.wana.control.*;
import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.util.*;



class PlayerListDisplay extends Canvas{
	
  private String[] playerNameList = new String[8]; //SNCAg̃vC[
  private int[]    playerObjIDList = new int[8];   //NCAgLN^[̃IuWFNgID
  
  private String[] playersScore = new String[8];//SNCAg̓_
  
  private int canvasX;
  private int canvasY;
  private int x;
  private int y;

  //BufferStrategyɊւ
  //http://www5.airnet.ne.jp/sakuraba/java/laboratory/JDK1.4/Graphics/BufferStrategy/BufferStrategy.html
  private BufferStrategy bs;
  
  /**
   * ݐڑĂvC[\邽߂Canvas𐶐
   * RXgN^
   * @param	sizeX	Canvas̏c̒iPʁFpixelj
   * @param	sizeY	Canvas̉̒iPʁFpixelj
   */
  public PlayerListDisplay(int sizeX,int sizeY){
    canvasX = sizeX;
    canvasY = sizeY;
    Arrays.fill(playerNameList,"");
	Arrays.fill(playersScore,"0000");
    Arrays.fill(playerObjIDList,-1);
    this.setSize(sizeX,sizeY);
  }

  /**
    *BufferStrategy𗘗p邽߂̏s
    */
  public void initGameDisplay(){
    try{
      this.createBufferStrategy(2);
      bs = getBufferStrategy();
    }catch(IllegalStateException ex){
      ex.printStackTrace();
      System.exit(0);
    }
  }
  
  /**
   * vC[ݒ肷B
   * @param playerName vC[
   * @param objectID   IuWFNgID
   */
  public void setPlayerName(String playerName, int objectID){
    int i = WanaUtil.arraySearch(playerObjIDList,-1);
    playerNameList[i] = playerName;
    playerObjIDList[i] = objectID;
  }
  
  /**
   * XRA[Zbg
   * @param	score	_
   * @param	objectID	IuWFNgID
   */
  public void setPlayersScore(int score,int objectID){
  	int i = WanaUtil.arraySearch(playerObjIDList,objectID);
	String strScore = Integer.toString(score);
    int scLen = 4 - strScore.length();
    for(int j=0; j<scLen; j++){
      strScore = "0" + strScore;
    }
	playersScore[i] = strScore;
  }
  
  
  /**
   * ڑؒfvC[̖O폜B
   * @param objectID   IuWFNgID
   */
  public void clearPlayerName(int objectID){
    int i = WanaUtil.arraySearch(playerObjIDList,objectID);
    for(int j=i;j<8;j++){
      if(playerNameList[j] != ""){
        playerNameList[j] = playerNameList[j+1];
		playersScore[j] = playersScore[j+1];
        playerObjIDList[j] = playerObjIDList[j+1];
      }else{
        playerNameList[j-1] = "";
		playersScore[j-1] = "";
        playerObjIDList[j-1] = -1;
        break;
      }
    }
  }
  
  /**
   * GameFramerepaint߂Ƃ̎se
   * ݐڑĂvC[AgpLN^[̃f[^󂯎
   */
  public void repaintPLDisplay(){
    repaint();
  }

  /**
   * yCgI[o[Ch
   */
  public void repaint(){
    Graphics2D g = (Graphics2D)bs.getDrawGraphics();
    if(!bs.contentsLost()){
      
      //wiœhԂ
      g.setColor(Color.black);
      g.fillRect(0,0,canvasX,canvasY);
      
      Font f = new Font("Serif",Font.PLAIN,30);
      g.setFont(f);
      g.setColor(Color.white);
      g.drawString("Player List", 10, 30);
      
      Font plfont = new Font("Serif",Font.BOLD,15);
      g.setFont(plfont);
      g.setColor(Color.cyan);
      int x = 47;
      for(int i=0;i<8;i++){
	  	g.drawString(playerNameList[i], 10, x);
		x=x+15;
		if(playerNameList[i] != ""){
			g.drawString("SCORE:" + playersScore[i], 50, x);
		}
        x=x+15;
      }
    }
    bs.show();
    g.dispose();
  }
}