package bou_n_sha.wana.view;

import bou_n_sha.wana.control.*;
import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.util.*;

/**
 * Canvasɕ\CharacterStatus
 * 
 * @author	Yudai Tomono
 */

class StatusDisplay extends Canvas{
	
  private 	String 		playerNameString 	= new String();
  private	String 		characterNameString = new String();
  private	String		strHP = "";
  private	String		strTP = "";
  private	String		strScore = "";
  private 	String      strMaxHP = "";
  private 	String      strMaxTP = "";
  private	int			canvasX;
  private	int			canvasY;
  PlayerControl		playerControl;

  //BufferStrategyɊւ
  //http://www5.airnet.ne.jp/sakuraba/java/laboratory/JDK1.4/Graphics/BufferStrategy/BufferStrategy.html
  private BufferStrategy bs;
  
  /**
   * CharacterStatus\邽߂Canvas𐶐
   * @param	sizeX	Canvas̏c̒iPʁFpixelj
   * @param	sizeY	Canvas̉̒iPʁFpixelj
   * @param	pc		PlayerControlNX̃CX^X
   */
  public StatusDisplay(int sizeX,int sizeY,PlayerControl pc){
    playerControl = pc;
    canvasX = sizeX;
    canvasY = sizeY;
    this.setSize(sizeX,sizeY);
  }
	
  /**
    *_uobt@O(DirectDraw)̏ݒs
    */
  public void initGameDisplay(){
    try{
      this.createBufferStrategy(2);
      bs = getBufferStrategy();
    }catch(IllegalStateException ex){
      ex.printStackTrace();
      System.exit(0);
    }
  }
  
	/**
	 * GameFramerepaint߂Ƃ̎se
	 * HPTP̕\ɂTɂ
	 */
	public void repaintstDisplay(){
      //HP̏
      strHP = Integer.toString(playerControl.getGameCharacter().getHitPoint());
      strMaxHP = Integer.toString(playerControl.getGameCharacter().getMaxHp());
      int hpLen = 5 - strHP.length();
      for(int i=0;i<hpLen;i++){
        strHP = "0" + strHP;
      }
      
      //TP̏
      strTP = Integer.toString(playerControl.getGameCharacter().getTensionPoint());
      strMaxTP = Integer.toString(playerControl.getGameCharacter().getMaxTension());
      int tpLen = 5 - strTP.length();
      for(int i=0;i<tpLen;i++){
        strTP = "0" + strTP;
      }
	  
	  strScore = Integer.toString(playerControl.getScore());
      int scLen = 4 - strScore.length();
      for(int i=0;i<scLen;i++){
        strScore = "0" + strScore;
      }
      
      repaint();
    }

  /**
    *yCgɃI[o[Ch
    */
  public void repaint(){
    Graphics2D g = (Graphics2D)bs.getDrawGraphics();
    if(!bs.contentsLost()){
      
      //wiœhԂ
      g.setColor(Color.black);
      g.fillRect(0,0,canvasX,canvasY);
      
      Font f = new Font("Serif",Font.PLAIN,30);
      g.setFont(f);
      
      g.setColor(Color.white);
      g.drawString("CharacterStatus", 50, 30);
      
      Font f2 = new Font("Serif",Font.BOLD,20);
      g.setFont(f2);
      playerNameString = playerControl.getplayerName();
      characterNameString = playerControl.getcharacterName();
      g.setColor(Color.red);
      g.drawString(playerNameString,180,70);
      g.drawString(characterNameString,180,110);
      
      Font f3 = new Font("Serif",Font.PLAIN,20);
      g.setFont(f3);
      g.setColor(Color.white);
      g.drawString("PlayerName",50,70);
      g.drawString("CharacterName",50,110);
      g.drawString("HP",50,150);
      g.drawString(strHP+"/"+strMaxHP,180,150);
      g.drawString("TP",50,190);
      g.drawString(strTP+"/"+strMaxTP,180,190); 
      g.drawString("SCORE",50,230);
      g.drawString(strScore,180,230);
      bs.show();
      g.dispose();
    }
  }
}