/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder;

import bodybuilder.builder.BuilderMapping;
import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.argument.ArgumentBuilder;
import bodybuilder.builder.value.ExtendedValue;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.jdom.JDOMUtils;
import org.jdom.Element;

public abstract class Builder {
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_TYPE = "type";
    protected static final String ELEM_CONSTRUCTOR = "constructor";
    protected boolean hasConstructor = true;
    protected boolean hasChild = true;

    protected abstract Object getMuscle(Element var1, Argument var2);

    public static Object getValue(Element element) {
        return Builder.getValue(element, null);
    }

    public static Object getValue(Element element, String string) {
        Object object = element.getAttributeValue(ATTR_VALUE);
        if (object == null) {
            Element element2 = JDOMUtils.getRequiredChild(element);
            return Builder.build(element2);
        }
        if (ExtendedValue.isExtended((String)object)) {
            return ExtendedValue.getValue((String)object);
        }
        if (string == null) {
            string = Builder.getType(element);
        }
        object = ObjectUtils.getObject((String)object, string);
        return object;
    }

    public static Object build(Element element) {
        Builder builder = Builder.getBuilder(element.getName());
        Argument argument = Builder.getConstructor(element, builder.hasConstructor);
        if (!builder.hasChild && element.getChildren().size() > 0) {
            throw new BodyBuilderException("cannot define child '" + element.getName() + "'.");
        }
        return builder.getMuscle(element, argument);
    }

    private static Builder getBuilder(String string) {
        Builder builder = BuilderMapping.getBuilder(string);
        if (builder == null) {
            throw new BodyBuilderException("cannot find builder '" + string + "'.");
        }
        return builder;
    }

    private static Argument getConstructor(Element element, boolean bl) {
        Argument argument = null;
        Element element2 = element.getChild(ELEM_CONSTRUCTOR);
        if (element2 != null) {
            if (!bl) {
                throw new BodyBuilderException("cannot pass constructor '" + element.getName() + "'.");
            }
            argument = ArgumentBuilder.getArgument(element2);
            element.removeChild(ELEM_CONSTRUCTOR);
        }
        return argument;
    }

    protected static Object newObject(String string, Argument argument) {
        if (argument != null) {
            return ObjectUtils.getInstance(string, argument.getClasses(), argument.getArguments());
        }
        return ObjectUtils.getObject(string);
    }

    protected static Object newObject(Class clazz, Argument argument) {
        if (argument != null) {
            return ObjectUtils.getInstance(clazz, argument.getClasses(), argument.getArguments());
        }
        return ObjectUtils.getObject(clazz);
    }

    protected static String getRequiredName(Element element) {
        return JDOMUtils.getRequiredAttrValue(element, ATTR_NAME);
    }

    protected static String getValueAttr(Element element) {
        return element.getAttributeValue(ATTR_VALUE);
    }

    protected static String getRequiredValueAttr(Element element) {
        return JDOMUtils.getRequiredAttrValue(element, ATTR_VALUE);
    }

    protected static String getType(Element element) {
        return element.getAttributeValue(ATTR_TYPE);
    }

    protected static String getType(Element element, String string) {
        return JDOMUtils.getAttrValue(element, ATTR_TYPE, string);
    }

    protected static String getRequiredType(Element element) {
        return JDOMUtils.getRequiredAttrValue(element, ATTR_TYPE);
    }
}

