/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder;

import bodybuilder.builder.Builder;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Bullworker {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder(Config.isValidate());
    private static final String OBJECT_ELEMENT = "object";
    private static final String OBJECT_NAME_ATTRIBUTE = "name";
    private List objectList = new ArrayList();
    private Map objectMap = new HashMap();

    public Bullworker(String string) {
        this(new File(string));
    }

    public Bullworker(File file) {
        try {
            this.loadObjects(builder.build(file));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public Bullworker(InputStream inputStream) {
        try {
            this.loadObjects(builder.build(inputStream));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public Bullworker(Reader reader) {
        try {
            this.loadObjects(builder.build(reader));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public Object getMuscle() {
        if (this.objectList.size() < 1) {
            return null;
        }
        Element element = (Element)this.objectList.get(0);
        return Builder.getValue(element);
    }

    public Object getMuscle(int n) {
        Element element = (Element)this.objectList.get(n);
        return Builder.getValue(element);
    }

    public Object getMuscle(String string) {
        Element element = (Element)this.objectMap.get(string);
        if (element == null) {
            return null;
        }
        return Builder.getValue(element);
    }

    private void loadObjects(Document document) {
        Element element = document.getRootElement();
        List list = element.getChildren(OBJECT_ELEMENT);
        for (int i = 0; i < list.size(); ++i) {
            this.add((Element)list.get(i));
        }
    }

    private void add(Element element) {
        this.objectList.add(element);
        String string = element.getAttributeValue(OBJECT_NAME_ATTRIBUTE);
        if (string != null) {
            this.objectMap.put(string, element);
        }
    }
}

