/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.InspectorMapping;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;

public abstract class Inspector {
    private List targets = new ArrayList();

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(String string) {
        this.targets.add(string);
    }

    public abstract void assertEquals(Object var1, Object var2, ObjectBackTrace var3);

    public static void assertObjectEquals(Object object, Object object2) {
        ObjectBackTrace objectBackTrace = new ObjectBackTrace();
        Inspector.assertObjectEquals(object, object2, objectBackTrace);
        objectBackTrace.clear();
    }

    public static void assertObjectEquals(Object object, Object object2, ObjectBackTrace objectBackTrace) {
        objectBackTrace.append(object2);
        Inspector.assertNullEquals(object, object2, objectBackTrace);
        if (object == null && object2 == null) {
            return;
        }
        Inspector inspector = InspectorMapping.getInspector(object);
        if (inspector != null) {
            List list = ObjectUtils.getClassNames(object2);
            List list2 = inspector.getTargets();
            boolean bl = false;
            for (int i = 0; i < list2.size(); ++i) {
                if (!list.contains(list2.get(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Inspector.rethrow("unimplement class", inspector.getTargets(), object2.getClass().getName(), objectBackTrace);
            }
            objectBackTrace.indent();
            inspector.assertEquals(object, object2, objectBackTrace);
            objectBackTrace.unindent();
        } else {
            Inspector.assertClassEquals(object, object2, objectBackTrace);
            if (!object.equals(object2)) {
                Inspector.rethrow(object, object2, objectBackTrace);
            }
        }
    }

    protected static void assertNullEquals(Object object, Object object2, ObjectBackTrace objectBackTrace) {
        if (object != null && object2 == null || object == null && object2 != null) {
            Inspector.rethrow(object, object2, objectBackTrace);
        }
    }

    protected static void assertClassEquals(Object object, Object object2, ObjectBackTrace objectBackTrace) {
        if (!Config.isInspectionClass()) {
            return;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (!clazz.getName().equals(clazz2.getName())) {
            Inspector.rethrow("classes differ", clazz, clazz2, objectBackTrace);
        }
    }

    protected void assertSizeEquals(int n, int n2, ObjectBackTrace objectBackTrace) {
        this.assertSizeEquals("size differ", n, n2, objectBackTrace);
    }

    protected void assertSizeEquals(String string, int n, int n2, ObjectBackTrace objectBackTrace) {
        if (!Config.isInspectionSize()) {
            return;
        }
        if (n != n2) {
            Inspector.rethrow(string, String.valueOf(n), String.valueOf(n2), objectBackTrace);
        }
    }

    protected void assertKeySetEquals(Set set, Set set2, ObjectBackTrace objectBackTrace) {
        this.assertKeySetEquals("key set differ", set, set2, objectBackTrace);
    }

    protected void assertKeySetEquals(String string, Set set, Set set2, ObjectBackTrace objectBackTrace) {
        Object e;
        Iterator iterator = set.iterator();
        Iterator iterator2 = set2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (set2.contains(e)) continue;
            Inspector.rethrow(string, e, null, objectBackTrace);
        }
        if (Config.isInspectionKeySetStrictly()) {
            while (iterator2.hasNext()) {
                e = iterator2.next();
                if (set.contains(e)) continue;
                Inspector.rethrow(string, null, e, objectBackTrace);
            }
        }
    }

    protected void assertRegexEquals(String string, String string2, ObjectBackTrace objectBackTrace) {
        this.assertRegexEquals("not macth regex", string, string2, objectBackTrace);
    }

    protected void assertRegexEquals(String string, String string2, String string3, ObjectBackTrace objectBackTrace) {
        if (string2 == null && string3 == null) {
            return;
        }
        if (string3 == null || string2 == null) {
            Inspector.rethrow(string, string2, string3, objectBackTrace);
        }
        if (!string3.matches(string2)) {
            Inspector.rethrow(string, string2, string3, objectBackTrace);
        }
    }

    protected static void rethrow(Object object, Object object2, ObjectBackTrace objectBackTrace) {
        Inspector.rethrow(null, object, object2, objectBackTrace);
    }

    protected static void rethrow(String string, Object object, Object object2, ObjectBackTrace objectBackTrace) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("objects differ");
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(" ");
        stringBuffer.append("expected:<");
        stringBuffer.append(object);
        stringBuffer.append("> but was:<");
        stringBuffer.append(object2);
        stringBuffer.append(">");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(objectBackTrace.dump());
        throw new AssertionFailedError(stringBuffer.toString());
    }
}

