/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.util.ObjectUtils;
import java.util.Stack;

public class ObjectBackTrace {
    private static final String NL = System.getProperty("line.separator");
    private static final String TAB = "  ";
    private StringBuffer buffer = new StringBuffer();
    private int level = 0;
    private Stack indentPoints = new Stack();
    private Stack indexPoints = new Stack();

    public void indent() {
        ++this.level;
        if (this.buffer.toString().endsWith(NL)) {
            int n = this.buffer.length();
            this.buffer.delete(n - NL.length(), n);
        }
        this.buffer.append(" {");
        this.setIndentPosition();
        this.buffer.append(NL);
        this.setIndexPosition();
    }

    public void unindent() {
        --this.level;
        this.rollbackIndentPosition();
        this.indexPoints.pop();
    }

    public void append(Object object) {
        this.nest();
        this.buffer.append(ObjectUtils.getInfo(object));
        this.buffer.append(NL);
    }

    public void appendIndex(int n) {
        this.rollbackIndexPosition();
        this.nest();
        this.buffer.append("[" + n + "]=>");
        this.buffer.append(NL);
    }

    public void appendKey(Object object) {
        this.appendKey(object, null);
    }

    public void appendKey(Object object, String string) {
        this.rollbackIndexPosition();
        this.nest();
        this.buffer.append("[\"" + object + "\"]");
        if (string != null) {
            this.buffer.append(string);
        }
        this.buffer.append("=>");
        this.buffer.append(NL);
    }

    String dump() {
        String string = this.buffer.toString();
        this.clear();
        this.buffer = null;
        return string;
    }

    void clear() {
        this.buffer.delete(0, this.buffer.length());
    }

    private void nest() {
        for (int i = 0; i < this.level; ++i) {
            this.buffer.append(TAB);
        }
    }

    private void setIndentPosition() {
        int n = this.buffer.lastIndexOf(NL);
        if (n >= 0) {
            this.indentPoints.push(new Integer(n + NL.length()));
        }
    }

    private void rollbackIndentPosition() {
        if (this.indentPoints.size() < 1) {
            return;
        }
        Integer n = (Integer)this.indentPoints.pop();
        if (n != null) {
            this.buffer.delete(n, this.buffer.length());
        }
    }

    private void setIndexPosition() {
        int n = this.buffer.lastIndexOf(NL);
        if (n >= 0) {
            this.indexPoints.push(new Integer(n + NL.length()));
        }
    }

    private void rollbackIndexPosition() {
        Integer n = (Integer)this.indexPoints.lastElement();
        if (n != null && n < this.buffer.length()) {
            this.buffer.delete(n, this.buffer.length());
        }
    }
}

