/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.test.TestCaseMapping;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class XML {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder();
    protected Element root = null;
    protected String xmlType = null;
    protected File file = null;

    public static XML newXML(String string) {
        return XML.newXML(new File(string));
    }

    public static XML newXML(File file) {
        try {
            Document document = builder.build(file);
            Element element = document.getRootElement();
            return XML.newXML(file, element);
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public static XML newXML(File file, Element element) {
        String string = element.getName();
        XML xML = TestCaseMapping.getXML(string);
        xML.file = file;
        xML.root = element;
        xML.xmlType = string;
        xML.build();
        return xML;
    }

    public abstract Test getTest();

    protected abstract void build();

    public File getFile() {
        return this.file;
    }

    public Element getRoot() {
        return this.root;
    }

    public String getXmlType() {
        return this.xmlType;
    }
}

