/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.SortedDataSet;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DbUnitUtils {
    private static Class driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$XmlDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$FlatXmlDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$excel$XlsDataSet;

    public static void registerDriver(String string) {
        try {
            if (driver == null) {
                driver = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BodyBuilderException(classNotFoundException);
        }
    }

    public DbUnitUtils(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
    }

    private IDatabaseConnection getConnection() {
        try {
            Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
            return new DatabaseConnection(connection);
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
    }

    private void close(IDatabaseConnection iDatabaseConnection) {
        if (iDatabaseConnection == null) {
            return;
        }
        try {
            iDatabaseConnection.close();
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
    }

    public void setUpDatabase(String string, String string2) {
        IDatabaseConnection iDatabaseConnection = null;
        try {
            iDatabaseConnection = this.getConnection();
            IDataSet iDataSet = this.getDataSet(string, string2);
            DatabaseOperation.CLEAN_INSERT.execute(iDatabaseConnection, iDataSet);
        }
        catch (DatabaseUnitException databaseUnitException) {
            throw new BodyBuilderException(databaseUnitException);
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
        finally {
            this.close(iDatabaseConnection);
        }
    }

    public void assertDataSetEquals(String string, String string2, Map map) {
        IDatabaseConnection iDatabaseConnection = null;
        try {
            iDatabaseConnection = this.getConnection();
            IDataSet iDataSet = this.getDataSet(string, string2);
            IDataSet iDataSet2 = iDatabaseConnection.createDataSet();
            String[] stringArray = iDataSet.getTableNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                ITable iTable = iDataSet.getTable(string3);
                ITable iTable2 = iDataSet2.getTable(string3);
                String[] stringArray2 = map != null ? map.get(string3.toUpperCase()) : null;
                this.assertTableEquals(iTable, iTable2, stringArray2);
            }
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        finally {
            this.close(iDatabaseConnection);
        }
    }

    public void assertTableEquals(ITable iTable, ITable iTable2, String[] stringArray) {
        IDatabaseConnection iDatabaseConnection = null;
        try {
            iDatabaseConnection = this.getConnection();
            if (stringArray != null && stringArray.length > 0) {
                iTable = this.getFilteredTable(iTable, stringArray);
                iTable2 = this.getFilteredTable(iTable2, stringArray);
            }
            if (iTable.getRowCount() == 0 && iTable2.getRowCount() == 0) {
                return;
            }
            iTable = new SortedTable(iTable);
            iTable2 = new SortedTable(iTable2);
            Assertion.assertEquals((ITable)iTable, (ITable)iTable2);
        }
        catch (DatabaseUnitException databaseUnitException) {
            throw new BodyBuilderException(databaseUnitException);
        }
        finally {
            this.close(iDatabaseConnection);
        }
    }

    private ITable getFilteredTable(ITable iTable, String[] stringArray) {
        try {
            return DefaultColumnFilter.excludedColumnsTable((ITable)iTable, (String[])stringArray);
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
    }

    private IDataSet getDataSet(String string, String string2) {
        if ((class$org$dbunit$dataset$xml$XmlDataSet == null ? (class$org$dbunit$dataset$xml$XmlDataSet = DbUnitUtils.class$("org.dbunit.dataset.xml.XmlDataSet")) : class$org$dbunit$dataset$xml$XmlDataSet).getName().equals(string2)) {
            return this.getXmlDataSet(string);
        }
        if ((class$org$dbunit$dataset$xml$FlatXmlDataSet == null ? (class$org$dbunit$dataset$xml$FlatXmlDataSet = DbUnitUtils.class$("org.dbunit.dataset.xml.FlatXmlDataSet")) : class$org$dbunit$dataset$xml$FlatXmlDataSet).getName().equals(string2)) {
            return this.getFlatXmlDataSet(string);
        }
        if ((class$org$dbunit$dataset$excel$XlsDataSet == null ? (class$org$dbunit$dataset$excel$XlsDataSet = DbUnitUtils.class$("org.dbunit.dataset.excel.XlsDataSet")) : class$org$dbunit$dataset$excel$XlsDataSet).getName().equals(string2)) {
            return this.getXlsDataSet(string);
        }
        throw new BodyBuilderException("unimplemented dataset '" + string2 + "'.");
    }

    private XmlDataSet getXmlDataSet(String string) {
        try {
            return new XmlDataSet((InputStream)new FileInputStream(string));
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    private FlatXmlDataSet getFlatXmlDataSet(String string) {
        try {
            return new FlatXmlDataSet(new File(string));
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    private XlsDataSet getXlsDataSet(String string) {
        try {
            return new XlsDataSet(new File(string));
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public String getDatabaseContent() {
        IDatabaseConnection iDatabaseConnection = null;
        try {
            iDatabaseConnection = this.getConnection();
            IDataSet iDataSet = iDatabaseConnection.createDataSet();
            StringWriter stringWriter = new StringWriter();
            FlatXmlDataSet.write((IDataSet)new SortedDataSet(iDataSet), (Writer)stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
        finally {
            this.close(iDatabaseConnection);
        }
    }

    public String getTableContent(String string) {
        IDatabaseConnection iDatabaseConnection = null;
        try {
            iDatabaseConnection = this.getConnection();
            IDataSet iDataSet = iDatabaseConnection.createDataSet(new String[]{string});
            StringWriter stringWriter = new StringWriter();
            FlatXmlDataSet.write((IDataSet)new SortedDataSet(iDataSet), (Writer)stringWriter);
            String string2 = stringWriter.toString();
            return string2;
        }
        catch (SQLException sQLException) {
            throw new BodyBuilderException(sQLException);
        }
        catch (DataSetException dataSetException) {
            throw new BodyBuilderException(dataSetException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
        finally {
            this.close(iDatabaseConnection);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

