/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object getObject(String string) {
        return ObjectUtils.getObject(null, string);
    }

    public static Object getObject(String string, String string2) {
        if (string2 == null || string2.equals((class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return string;
        }
        if (ObjectUtils.isPrimitive(string2)) {
            return ObjectUtils.getPrimitiveWrapperInstance(string, string2);
        }
        if (string != null) {
            return ObjectUtils.getInstance(string2, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
        }
        return ObjectUtils.getInstance(string2, new Class[0], new Object[0]);
    }

    public static Object getObject(Class clazz) {
        return ObjectUtils.getObject(null, clazz);
    }

    public static Object getObject(String string, Class clazz) {
        if (clazz == null || clazz.equals((class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return string;
        }
        if (string != null) {
            return ObjectUtils.getInstance(clazz, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectUtils.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
        }
        return ObjectUtils.getInstance(clazz, new Class[0], new Object[0]);
    }

    public static boolean isPrimitive(String string) {
        boolean bl = false;
        if ("bool".equals(string) || "boolean".equals(string)) {
            bl = true;
        } else if ("byte".equals(string)) {
            bl = true;
        } else if ("char".equals(string) || "character".equals(string)) {
            bl = true;
        } else if ("short".equals(string)) {
            bl = true;
        } else if ("int".equals(string) || "integer".equals(string)) {
            bl = true;
        } else if ("long".equals(string)) {
            bl = true;
        } else if ("float".equals(string)) {
            bl = true;
        } else if ("double".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static Object getPrimitiveWrapperInstance(String string, String string2) {
        Comparable<Boolean> comparable = null;
        if ("bool".equals(string2) || "boolean".equals(string2)) {
            comparable = Boolean.valueOf(string);
        } else if ("byte".equals(string2)) {
            comparable = Byte.valueOf(string);
        } else if ("char".equals(string2) || "character".equals(string2)) {
            comparable = new Character((char)Integer.parseInt(string));
        } else if ("short".equals(string2)) {
            comparable = Short.valueOf(string);
        } else if ("int".equals(string2) || "integer".equals(string2)) {
            comparable = Integer.valueOf(string);
        } else if ("long".equals(string2)) {
            comparable = Long.valueOf(string);
        } else if ("float".equals(string2)) {
            comparable = Float.valueOf(string);
        } else if ("double".equals(string2)) {
            comparable = Double.valueOf(string);
        }
        return comparable;
    }

    public static Object getInstance(String string, Class[] classArray, Object[] objectArray) {
        Class clazz = ObjectUtils.getClass(string);
        return ObjectUtils.getInstance(clazz, classArray, objectArray);
    }

    public static Object getInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
            return constructor.newInstance(objectArray);
        }
        catch (SecurityException securityException) {
            throw new BodyBuilderException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BodyBuilderException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BodyBuilderException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new BodyBuilderException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BodyBuilderException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BodyBuilderException(invocationTargetException);
        }
    }

    public static Class getClass(String string) {
        try {
            if (ObjectUtils.isPrimitive(string)) {
                return ObjectUtils.getPrimitiveClass(string);
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BodyBuilderException(classNotFoundException);
        }
    }

    public static Class getPrimitiveClass(String string) {
        Class<Comparable<Boolean>> clazz = null;
        if ("bool".equals(string) || "boolean".equals(string)) {
            clazz = Boolean.TYPE;
        } else if ("byte".equals(string)) {
            clazz = Byte.TYPE;
        } else if ("char".equals(string) || "character".equals(string)) {
            clazz = Character.TYPE;
        } else if ("short".equals(string)) {
            clazz = Short.TYPE;
        } else if ("int".equals(string) || "integer".equals(string)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(string)) {
            clazz = Long.TYPE;
        } else if ("float".equals(string)) {
            clazz = Float.TYPE;
        } else if ("double".equals(string)) {
            clazz = Double.TYPE;
        }
        return clazz;
    }

    public static String getName(Object object, boolean bl) {
        if (object == null) {
            return "null";
        }
        return ObjectUtils.getName(object.getClass(), bl);
    }

    public static String getName(Class clazz, boolean bl) {
        String string = null;
        string = clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName();
        if (bl) {
            string = ObjectUtils.omit(string);
        }
        if (Proxy.isProxyClass(clazz)) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?>[] classArray = clazz.getInterfaces();
            stringBuffer.append(string);
            stringBuffer.append("(");
            for (int i = 0; i < classArray.length; ++i) {
                String string2 = classArray[i].getName();
                stringBuffer.append(ObjectUtils.omit(string2));
                if (i <= 0) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String omit(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getSize(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return String.valueOf(Array.getLength(object));
        }
        Method method = null;
        try {
            method = clazz.getMethod("size", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        try {
            if (method == null) {
                method = clazz.getMethod("length", new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        if (method == null) {
            return null;
        }
        String string = null;
        try {
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 != null) {
                string = object2.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            string = null;
        }
        catch (InvocationTargetException invocationTargetException) {
            string = null;
        }
        return string;
    }

    public static String getInfo(Object object) {
        return ObjectUtils.getInfo(object, false);
    }

    public static String getInfo(Object object, boolean bl) {
        if (object == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ObjectUtils.getName(object, true));
        String string = ObjectUtils.getSize(object);
        if (string != null) {
            stringBuffer.append("(" + string + ")");
        }
        if (bl) {
            stringBuffer.append(" \"");
            stringBuffer.append(object.toString());
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static List getClassNames(Object object) {
        return ObjectUtils.getClassNames(object, false);
    }

    public static List getClassNames(Object object, boolean bl) {
        if (object == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("null");
            return arrayList;
        }
        return ObjectUtils.getClassNames(object.getClass(), bl);
    }

    public static List getClassNames(Class clazz) {
        return ObjectUtils.getClassNames(clazz, false);
    }

    public static List getClassNames(Class clazz, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Class clazz2 = clazz;
        if (clazz.isPrimitive()) {
            arrayList.add("primitive");
            return arrayList;
        }
        if (clazz.isArray()) {
            arrayList.add("array");
            return arrayList;
        }
        String string = (class$java$lang$Object == null ? (class$java$lang$Object = ObjectUtils.class$("java.lang.Object")) : class$java$lang$Object).getName();
        ArrayList arrayList2 = new ArrayList();
        while (!clazz2.getName().equals(string)) {
            arrayList.add(clazz2.getName());
            ObjectUtils.addInterfaceNames(clazz2, arrayList2);
            clazz2 = clazz2.getSuperclass();
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private static void addInterfaceNames(Class clazz, List list) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            String string = classArray[i].getName();
            if (list.contains(string)) continue;
            list.add(string);
            ObjectUtils.addInterfaceNames(classArray[i], list);
        }
    }

    public static Method getMethod(Object object, String string, Class[] classArray) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + string + "' defined is null.");
        }
        return ObjectUtils.getMethod(object.getClass(), string, classArray);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method method = null;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            return method;
        }
        catch (SecurityException securityException) {
            throw new BodyBuilderException("cannot get method '" + string + " " + Arrays.asList(classArray) + "' as '" + clazz.getName() + "'.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BodyBuilderException("cannot get method '" + string + " " + Arrays.asList(classArray) + "' as '" + clazz.getName() + "'.", noSuchMethodException);
        }
    }

    public static Object invokeMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        return ObjectUtils.invokeMethod(ObjectUtils.getClass(string), null, string2, classArray, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + string + "' defined is null.");
        }
        return ObjectUtils.invokeMethod(object.getClass(), object, string, classArray, objectArray);
    }

    public static Object invokeMethod(Class clazz, Object object, String string, Class[] classArray, Object[] objectArray) {
        Method method = ObjectUtils.getMethod(clazz, string, classArray);
        return ObjectUtils.invokeMethod(clazz, object, method, objectArray);
    }

    public static Object invokeMethod(Class clazz, Object object, Method method, Object[] objectArray) {
        try {
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (SecurityException securityException) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BodyBuilderException("cannot invole method '" + method.getName() + "' as '" + object + "'.", invocationTargetException);
        }
    }

    public static boolean isStaticMethod(Method method) {
        return method.toString().matches("^.* static .*$");
    }

    public static Object getFiledValue(String string, String string2) {
        return ObjectUtils.getFiledValue(ObjectUtils.getClass(string), null, string2);
    }

    public static Object getFiledValue(Object object, String string) {
        if (object == null) {
            throw new BodyBuilderException("object that '" + string + "' defined is null.");
        }
        return ObjectUtils.getFiledValue(object.getClass(), object, string);
    }

    public static Object getFiledValue(Class clazz, Object object, String string) {
        try {
            Field field = null;
            try {
                field = clazz.getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(string);
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (SecurityException securityException) {
            throw new BodyBuilderException("cannot get field '" + string + "' as '" + object + "(" + clazz + ")'.", securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BodyBuilderException("cannot get field '" + string + "' as '" + object + "(" + clazz + ")'.", noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BodyBuilderException("cannot get field '" + string + "' as '" + object + "(" + clazz + ")'.", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BodyBuilderException("cannot get field '" + string + "' as '" + object + "(" + clazz + ")'.", illegalAccessException);
        }
    }

    public static boolean instance_of(Class clazz, String string) {
        List list = ObjectUtils.getClassNames(clazz);
        return list.contains(string);
    }

    public static boolean instance_of(Class clazz, Class clazz2) {
        return ObjectUtils.instance_of(clazz, clazz2.getName());
    }

    public static boolean instance_of(Object object, String string) {
        List list = ObjectUtils.getClassNames(object);
        return list.contains(string);
    }

    public static boolean instance_of(Object object, Class clazz) {
        return ObjectUtils.instance_of(object, clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

