/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util.jdom;

import bodybuilder.exception.BodyBuilderException;
import java.util.List;
import org.jdom.Element;

public class JDOMUtils {
    public static Element getChild(Element element) {
        List list = element.getChildren();
        if (list == null || list.size() < 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new BodyBuilderException("too many children as '" + element.getName() + "'.");
        }
        return (Element)list.get(0);
    }

    public static Element getRequiredChild(Element element) {
        List list = element.getChildren();
        if (list == null || list.size() < 0) {
            throw new BodyBuilderException("undefined child as '" + element.getName() + "'.");
        }
        return (Element)list.get(0);
    }

    public static Element getRequiredChild(Element element, String string) {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new BodyBuilderException("undefined element '" + string + "' as '" + element.getName() + "'.");
        }
        return element2;
    }

    public static List getRequiredChildren(Element element, String string) {
        List list = element.getChildren(string);
        if (list == null || list.size() < 0) {
            throw new BodyBuilderException("undefined elements '" + string + "' as '" + element.getName() + "'.");
        }
        return list;
    }

    public static boolean hasChild(Element element, String string) {
        Element element2 = element.getChild(string);
        return element2 != null;
    }

    public static String getAttrValue(Element element, String string, String string2) {
        String string3 = element.getAttributeValue(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String getRequiredAttrValue(Element element, String string) {
        String string2 = element.getAttributeValue(string);
        if (string2 == null) {
            throw new BodyBuilderException("undefined attribute '" + string + "' as '" + element.getName() + "'.");
        }
        return string2;
    }

    public static boolean getAttrBoolValue(Element element, String string) {
        return JDOMUtils.getAttrBoolValue(element, string, true);
    }

    public static boolean getAttrBoolValue(Element element, String string, boolean bl) {
        String string2 = element.getAttributeValue(string);
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }
}

