package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.Bullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample05 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample05.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // Node
        Object string_buffer = bullworker.getMuscle("Node");
        Viewer.dump(string_buffer);

        // SampleBean03
        Object exception = bullworker.getMuscle("SampleBean03");
        Viewer.dump(exception);
    }

}