package sample.builder.extension.value;

import sample.object.UserDefined;

import bodybuilder.builder.value.ExtendedValue;

/**
 * ユーザ定義オブジェクト拡張値
 */
public class UserDefinedValue extends ExtendedValue {

    /**
     * ユーザ定義オブジェクトを取得する。
     * 
     * @param value メッセージ
     * @return オブジェクト
     */
    protected Object value(String value) {
        // メッセージを取得。
        String message = value.substring("msg:".length());

        // ユーザ定義オブジェクトを返す。
        return new UserDefined(message);
    }

}