package bodybuilder.exception;

/**
 * bodybuilderの例外
 */
public class BodyBuilderException extends RuntimeException {

    /**
     * 詳細メッセージに null を使用して、新規例外を構築する。
     */
    public BodyBuilderException() {
        super();
    }

    /**
     * 指定された詳細メッセージを使用して、新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     */
    public BodyBuilderException(String message) {
        super(message);
    }

    /**
     * 指定された原因を使用して、新規例外を構築する。
     * 
     * @param cause 原因
     */
    public BodyBuilderException(Throwable cause) {
        super(cause);
    }

    /**
     * 指定された詳細メッセージおよび原因を使用して新規例外を構築する。
     * 
     * @param message 詳細メッセージ
     * @param cause 原因
     */
    public BodyBuilderException(String message, Throwable cause) {
        super(message, cause);
    }

}