package bodybuilder.inspector;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import bodybuilder.util.ExtendedPropertyUtils;

/**
 * ビーンインスペクター
 */
public class BeanInspector extends Inspector {

    /**
     * 二つのビーンが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // プロパティを取得。
        Map expectedProps = ExtendedPropertyUtils.getProperties(expected);
        Map actualProps = ExtendedPropertyUtils.getProperties(actual);
        // プロパティ名を検査。
        Set expectedNameSet = expectedProps.keySet();
        assertKeySetEquals(expectedNameSet, actualProps.keySet(), trace);
        Iterator names = expectedNameSet.iterator();

        // プロパティ値を検査。
        while (names.hasNext()) {
            Object name = names.next();
            trace.appendKey(name);
            Object expectedElement = expectedProps.get(name);
            Object actualElement = actualProps.get(name);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}