package bodybuilder.util;

import java.io.File;

/**
 * ファイルユーティリティ
 */
public class FileUtils {

    /**
     * ファイルの拡張子を取得する。
     * 
     * @param filename ファイル名
     * @return 拡張子
     */
    public static String getExt(String filename) {
        // ピリオドの位置を取得。
        int pos = filename.lastIndexOf(".");

        if (pos >= 0) {
            // 拡張子を返す。
            return filename.substring(pos + 1);
        } else {
            // 拡張子がなければnull。
            return null;
        }
    }

    /**
     * ファイル名から拡張子を削除する。
     * 
     * @param filename ファイル名
     * @return 拡張子を削除したファイル名
     */
    public static String removeExt(String filename) {
        // ピリオドの位置を取得。
        int pos = filename.lastIndexOf(".");

        // 拡張子がある場合は、拡張子を削除。
        if (pos >= 0) {
            filename = filename.substring(0, pos);
        }

        // ファイル名を返す。
        return filename;
    }

    /**
     * ファイル名がフルパスかどうか調べる。
     * 
     * @param filename ファイル名
     * @return フルパスの場合はtrue
     */
    public static boolean isFullPath(String filename) {
        // ファイル名の先頭がパス区切り文字、またはドライブレターの場合はtrue
        return (filename.matches("^[/\\\\].*$") || filename
                .matches("^[A-Za-z]:.*$"));

    }

    /**
     * パスの末尾からパス区切り文字を削除する。
     * 
     * @param path パス
     * @return パス区切り文字を追加したパス
     */
    public static String removeEndSeparator(String path) {
        // パスの末尾がパス区切り文字の場合は、パス区切り文字を削除。
        if (path.endsWith(File.separator)) {
            int end = path.length() - File.separator.length();
            path = path.substring(0, end);
        }

        // パスを返す。
        return path;
    }

    /**
     * パスからドライブレターを削除する。
     * 
     * @param path パス
     * @return ドライブレターを削除したパス
     */
    public static String removeDriveLetter(String path) {
        // ドライブレターを削除。
        return path.replaceAll("^[A-Za-z]:", "");
    }

    /**
     * パスをドット(ピリオド)区切り文字列に変換する。
     * 
     * @param path パス
     * @return ドット区切り文字列
     */
    public static String toDotSeparatedValue(String path) {
        // ドライブレターを削除。
        path = removeDriveLetter(path);
        // 拡張子を削除。
        path = removeExt(path);
        // ルートのパス区切り文字を削除。
        path = path.replaceAll("^[/\\\\]", "");
        // パス区切り文字をドットに置換。
        path = path.replaceAll("[/\\\\]", ".");
        // ドット区切り文字を返す。
        return path;
    }

}