package bodybuilder.util;

import java.util.Arrays;
import java.util.List;

/**
 * ユーティリティ
 */
public class Utils {

    /**
     * 改行
     */
    public static final String NL = System.getProperty("line.separator");

    /**
     * リストの要素を結合する。
     * 
     * @param list リスト
     * @param sep セパレータ
     * @return リストの要素を結合した文字列
     */
    public static String join(List list, String sep) {
        if (list == null) {
            // nullの場合はnullを返す。
            return null;
        } else if (list.size() < 1) {
            // 空リストの場合は空文字を返す。
            return "";
        }

        // 最初の要素をバッファに格納。
        StringBuffer buf = new StringBuffer((list.get(0) != null) ? list.get(0)
                .toString() : "");

        // 要素を結合。
        for (int i = 1; i < list.size(); i++) {
            buf.append(sep);
            buf.append((list.get(i) != null) ? list.get(i).toString() : "");
        }

        // 結合した文字列を返す。
        return buf.toString();
    }

    /**
     * 文字列を文字列配列に変換する。
     * 
     * @param str 文字列
     * @return 文字列配列
     */
    public static String[] toStringArray(String str) {
        return str.split(NL);
    }

    /**
     * 文字列配列を枠で囲む。
     * 
     * @param body
     * @return 枠で囲んだ文字列配列
     */
    public static String[] decorate(String[] body) {
        // バッファを生成。
        String[] buf = new String[body.length + 2];

        // 文字列の最大長を取得。
        int max = 0;

        for (int i = 0; i < body.length; i++) {
            // タブは空白に置換。
            body[i] = body[i].replaceAll("\t", "    ");

            // 長さを取得。
            int len = len(body[i]);

            if (len > max) {
                max = len;
            }
        }

        // バッファに文字列をセット。
        for (int i = 0; i < body.length; i++) {
            int len = len(body[i]);
            StringBuffer line = new StringBuffer(body[i]);

            if (len < max) {
                for (int j = 0; j < (max - len); j++) {
                    line.append(' ');
                }
            }

            line.insert(0, '|');
            line.append('|');
            buf[i + 1] = line.toString();
        }

        // 枠を生成。
        char[] cs = new char[max + 2];
        Arrays.fill(cs, '-');
        cs[0] = '+';
        cs[cs.length - 1] = '+';
        String stretcher = new String(cs);

        // 枠をバッファに追加。
        buf[0] = stretcher;
        buf[buf.length - 1] = stretcher;

        // 枠で囲んだ文字列配列を返す。
        return buf;
    }

    /**
     * 文字列の長さを取得する。
     * マルチバイト文字は2文字と数える。
     * 
     * @param str
     * @return 文字列の長さ。
     */
    public static int len(String str) {
        char[] cs = str.toCharArray();
        int len = 0;

        for (int i = 0; i < cs.length; i++) {

            if (((int) cs[i]) > 0x7F) {
                len += 2;
            } else {
                len++;
            }
        }

        return len;
    }

}