package bodybuilder.viewer.servlet;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import bodybuilder.util.ObjectUtils;
import bodybuilder.util.ServletObjectUtils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * リクエストビューア
 */
public class RequestViewer extends Viewer {

    /**
     * リクエストの内容を出力する。
     * 
     * @param object リクエスト
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // リクエストにキャスト。
        HttpServletRequest request = (HttpServletRequest) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // パラメータを取得。
        handler.print("(parameters)");
        Map params = ServletObjectUtils.getRequestParameters(request);
        Iterator paramNames = params.keySet().iterator();

        // パラメータを出力。
        while (paramNames.hasNext()) {
            String name = (String) paramNames.next();
            Object value = params.get(name);
            handler.print("[\"" + name + "\"]=>");
            dump(value, handler);
        }

        // 属性を取得。
        handler.print("(attributes)");
        Map attributes = ServletObjectUtils.getRequestAttributes(request);
        Iterator attrNames = attributes.keySet().iterator();

        // 属性を出力。
        while (attrNames.hasNext()) {
            String name = (String) attrNames.next();
            handler.print("[\"" + name + "\"]=>");
            dump(request.getAttribute(name), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}