/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder.servlet;

import bodybuilder.builder.Builder;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ServletObjectsBullworker {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder(Config.isValidate());
    private static final String SERVLETCONTEXT_ELEMENT = "servletcontext";
    private static final String REQUEST_ELEMENT = "request";
    private static final String SESSION_ELEMENT = "session";
    private ServletContext servletcontext = null;
    private HttpServletRequest request = null;
    private HttpSession session = null;

    public ServletObjectsBullworker(String string) {
        this(new File(string));
    }

    public ServletObjectsBullworker(File file) {
        try {
            this.loadObjects(builder.build(file));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public ServletObjectsBullworker(InputStream inputStream) {
        try {
            this.loadObjects(builder.build(inputStream));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public ServletObjectsBullworker(Reader reader) {
        try {
            this.loadObjects(builder.build(reader));
        }
        catch (JDOMException jDOMException) {
            throw new BodyBuilderException(jDOMException);
        }
        catch (IOException iOException) {
            throw new BodyBuilderException(iOException);
        }
    }

    public ServletContext getServletContext() {
        return this.servletcontext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpSession getSession() {
        return this.session;
    }

    private void loadObjects(Document document) {
        Element element;
        Element element2;
        Element element3 = document.getRootElement();
        Element element4 = element3.getChild(SERVLETCONTEXT_ELEMENT);
        if (element4 != null) {
            this.servletcontext = (ServletContext)Builder.build(element4);
        }
        if ((element2 = element3.getChild(REQUEST_ELEMENT)) != null) {
            this.request = (HttpServletRequest)Builder.build(element2);
        }
        if ((element = element3.getChild(SESSION_ELEMENT)) != null) {
            this.session = (HttpSession)Builder.build(element);
        }
    }
}

