/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.dicon;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.dicon.DIConTestCaseXML;
import bodybuilder.test.dicon.InjectedObjects;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class DIConTestCase
extends XMLTestCase {
    protected DIConTestCaseXML xml = null;

    protected void setXML(TestCaseXML testCaseXML) {
        this.xml = (DIConTestCaseXML)testCaseXML;
    }

    protected void runTest() {
        this.info("'" + this.getName() + "' is started .");
        this.debug("description is:\n" + this.xml.getDescription());
        String string = this.xml.getTarget();
        int n = this.xml.getType();
        this.debug("target is '" + string + "'(Type" + n + ").");
        this.debug("build component.");
        InjectedObjects injectedObjects = this.xml.getInjectedObjects();
        Object object = this.buildComponent(string, n, injectedObjects);
        DatabaseSetUp databaseSetUp = this.xml.getDatabaseSetUp();
        if (databaseSetUp != null) {
            this.debug("set up database by '" + databaseSetUp.getFile() + "'.");
            databaseSetUp.setUp();
        }
        Execute execute = this.xml.getExecute();
        String string2 = execute.getMethod();
        Argument argument = execute.getArgument();
        this.debug("invoked method is '" + string2 + "' as '" + string + "'.");
        Object object2 = null;
        Throwable throwable = null;
        try {
            object2 = ObjectUtils.invokeMethod(object, string2, argument.getClasses(), argument.getArguments());
        }
        catch (BodyBuilderException bodyBuilderException) {
            if (!(bodyBuilderException.getCause() instanceof InvocationTargetException)) {
                throw bodyBuilderException;
            }
            throwable = bodyBuilderException.getCause().getCause();
            this.debug("'" + throwable + "' was catched.");
        }
        this.debug("'" + string2 + "' was invoked.");
        Catch catch_ = this.xml.getCatch();
        if (catch_ != null && ObjectUtils.instance_of((Object)throwable, catch_.getType())) {
            this.debug("verify catched exception.");
            Inspector.assertObjectEquals(catch_.getException(), throwable);
            this.debug("catched exception value was corrected.");
        } else {
            if (catch_ != null) {
                throw new BodyBuilderException("unexpected exception '" + throwable + "' but was '" + catch_.getType() + "'.", throwable);
            }
            if (throwable != null) {
                throw new BodyBuilderException("unexpected exception '" + throwable + "'.", throwable);
            }
        }
        Return return_ = this.xml.getReturn();
        if (return_ != null) {
            this.debug("verify return value.");
            Inspector.assertObjectEquals(return_.getValue(), object2);
            this.debug("return value was corrected.");
        }
        InjectedObjects injectedObjects2 = this.xml.getExpectedObjects();
        String[] stringArray = injectedObjects2.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.debug("verify object '" + stringArray[i] + "' as '" + object + "'.");
            Object object3 = injectedObjects2.getObject(stringArray[i]);
            Object object4 = injectedObjects.getObject(stringArray[i]);
            Inspector.assertObjectEquals(object3, object4);
            this.debug("'" + stringArray[i] + "' was corrected.");
        }
        DatabaseAssertion databaseAssertion = this.xml.getDatabaseAssertion();
        if (databaseSetUp != null) {
            this.debug("verify database by '" + databaseAssertion.getFile() + "'.");
            databaseAssertion.assertDataSetEquals();
            this.debug("database was corrected.");
        }
        this.windup(injectedObjects);
        this.info("test was ended.");
    }

    private Object buildComponent(String string, int n, InjectedObjects injectedObjects) {
        Object object = null;
        switch (n) {
            case 2: {
                object = ObjectUtils.getObject(string);
                Map map = injectedObjects.getObjectMap();
                ExtendedPropertyUtils.copyProperties(object, map);
                break;
            }
            case 3: {
                Class[] classArray = injectedObjects.getClasses();
                Object[] objectArray = injectedObjects.getObjects();
                object = ObjectUtils.getInstance(string, classArray, objectArray);
                break;
            }
            default: {
                throw new BodyBuilderException("uninplemented injection type '" + n + "'.");
            }
        }
        return object;
    }

    private void windup(InjectedObjects injectedObjects) {
        String[] stringArray = injectedObjects.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = injectedObjects.getObject(stringArray[i]);
            Execute[] executeArray = injectedObjects.getWindUp(stringArray[i]);
            if (executeArray == null || executeArray.length < 1) continue;
            this.debug("wind up component '" + stringArray[i] + "'.");
            for (int j = 0; j < executeArray.length; ++j) {
                String string = executeArray[j].getMethod();
                Argument argument = executeArray[j].getArgument();
                this.debug("execute method '" + string + "' as '" + object.getClass().getName() + "' for wind up.");
                ObjectUtils.invokeMethod(object, executeArray[j].getMethod(), argument.getClasses(), argument.getArguments());
            }
        }
    }
}

