/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.usually;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.common.Target;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.usually.UsualTestCaseXML;
import bodybuilder.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UsualTestCase
extends XMLTestCase {
    protected UsualTestCaseXML xml = null;

    protected void setXML(TestCaseXML testCaseXML) {
        this.xml = (UsualTestCaseXML)testCaseXML;
    }

    protected void runTest() {
        Object object;
        this.info("'" + this.getName() + "' is started.");
        this.debug("description is:\n" + this.xml.getDescription());
        Target target = this.xml.getTarget();
        this.debug("target is '" + target.getName() + "'.");
        DatabaseSetUp databaseSetUp = this.xml.getDatabaseSetUp();
        if (databaseSetUp != null) {
            this.debug("set up database by '" + databaseSetUp.getFile() + "'.");
            databaseSetUp.setUp();
        }
        Execute execute = this.xml.getExecute();
        String string = execute.getMethod();
        Argument argument = execute.getArgument();
        this.debug("invoked method is '" + string + "' as '" + target.getName() + "'.");
        Class clazz = ObjectUtils.getClass(target.getName());
        Method method = ObjectUtils.getMethod(clazz, string, argument.getClasses());
        Object object2 = null;
        if (!ObjectUtils.isStaticMethod(method)) {
            object = target.getConstructor();
            object2 = ObjectUtils.getInstance(target.getName(), ((Argument)object).getClasses(), ((Argument)object).getArguments());
        }
        object = null;
        Throwable throwable = null;
        try {
            object = ObjectUtils.invokeMethod(clazz, object2, method, argument.getArguments());
        }
        catch (BodyBuilderException bodyBuilderException) {
            if (!(bodyBuilderException.getCause() instanceof InvocationTargetException)) {
                throw bodyBuilderException;
            }
            throwable = bodyBuilderException.getCause().getCause();
            this.debug("'" + throwable + "' was catched.");
        }
        this.debug("'" + method + "' was invoked.");
        Catch catch_ = this.xml.getCatch();
        if (catch_ != null && ObjectUtils.instance_of((Object)throwable, catch_.getType())) {
            this.debug("verify catched exception.");
            Inspector.assertObjectEquals(catch_.getException(), throwable);
            this.debug("catched exception value was corrected.");
        } else {
            if (catch_ != null) {
                throw new BodyBuilderException("unexpected exception '" + throwable + "' but was '" + catch_.getType() + "'.", throwable);
            }
            if (throwable != null) {
                throw new BodyBuilderException("unexpected exception '" + throwable + "'.", throwable);
            }
        }
        Return return_ = this.xml.getReturn();
        if (return_ != null) {
            this.debug("verify return value.");
            Inspector.assertObjectEquals(return_.getValue(), object);
            this.debug("return value was corrected.");
        }
        DatabaseAssertion databaseAssertion = this.xml.getDatabaseAssertion();
        if (databaseSetUp != null) {
            this.debug("verify database by '" + databaseAssertion.getFile() + "'.");
            databaseAssertion.assertDataSetEquals();
            this.debug("database was corrected.");
        }
        this.info("test was ended.");
    }
}

