/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Config {
    private static Properties config = new Properties();
    private static final String DEFAULT_CONFIG_FILE_NAME = "bodybuilder-default.properties";
    private static final String CONFIG_FILE_NAME = "bodybuilder.properties";
    private static final String PROP_KEY_PREFIX = "bodybuilder.";
    private static final String INSPECTION_PROP_KEY_PRIFIX = "bodybuilder.inspection.";
    private static final String VIEW_PROP_KEY_PRIFIX = "bodybuilder.view.";
    private static final String BUILDER_PROP_KEY_PRIFIX = "bodybuilder.builder.";
    private static final String VIEWER_PROP_KEY_PRIFIX = "bodybuilder.viewer.";
    private static final String INSPECTOR_PROP_KEY_PRIFIX = "bodybuilder.inspector.";
    private static final String VALUE_PROP_KEY_PRIFIX = "bodybuilder.value.";
    private static final String TEST_PROP_KEY_PREFIX = "bodybuilder.test.";
    private static final String DATABASE_PROP_KEY_PREFIX = "bodybuilder.database.";
    static /* synthetic */ Class class$bodybuilder$util$Config;

    public static boolean isValidate() {
        return Config.getBooleanProperty("bodybuilder.xml.validate", false);
    }

    public static String getOutputHandler() {
        return Config.getProperty("bodybuilder.output.handler");
    }

    public static boolean isInspectionSize() {
        return Config.getBooleanProperty("bodybuilder.inspection.size", true);
    }

    public static boolean isInspectionKeySetStrictly() {
        return Config.getBooleanProperty("bodybuilder.inspection.keyset.strictly", false);
    }

    public static boolean isInspectionClass() {
        return Config.getBooleanProperty("bodybuilder.inspection.class", true);
    }

    public static boolean isInspectionExceptionRegex() {
        return Config.getBooleanProperty("bodybuilder.inspection.exception.regex", true);
    }

    public static boolean isInspectionExceptionCause() {
        return Config.getBooleanProperty("bodybuilder.inspection.exception.cause", false);
    }

    public static Map getIgnoreProperties() {
        String[] stringArray = Config.getList(Config.getProperty("bodybuilder.inspection.ignore.properties"));
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("[#/]");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
            arrayList.remove(0);
            hashMap.put(stringArray2[0], arrayList);
        }
        return hashMap;
    }

    public static boolean isViewPrintStackTrace() {
        return Config.getBooleanProperty("bodybuilder.view.stacktrace", false);
    }

    public static Map getBuilderMap() {
        return Config.subMap(BUILDER_PROP_KEY_PRIFIX);
    }

    public static Map getViewerMap() {
        return Config.newMap(VIEWER_PROP_KEY_PRIFIX, ".type", ".class");
    }

    public static Map getInspectorMap() {
        return Config.newMap(INSPECTOR_PROP_KEY_PRIFIX, ".type", ".class");
    }

    public static Map getValueMap() {
        return Config.newMap(VALUE_PROP_KEY_PRIFIX, ".format", ".class");
    }

    public static String[] getTestRootDirs() {
        String string = Config.getRequiredProperty("bodybuilder.test.root.dirs");
        String[] stringArray = Config.getList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = FileUtils.removeEndSeparator(stringArray[i]);
        }
        return stringArray;
    }

    public static List getTestIgnoreDirs() {
        String string = Config.getProperty("bodybuilder.test.ignore.dirs");
        if (string == null) {
            return new ArrayList();
        }
        String[] stringArray = Config.getList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = FileUtils.removeEndSeparator(stringArray[i]);
        }
        return Arrays.asList(stringArray);
    }

    public static Map getTestCaseMap() {
        return Config.subMap("bodybuilder.test.type.");
    }

    public static String getDatabaseDriver() {
        return Config.getRequiredProperty("bodybuilder.database.driver");
    }

    public static String getDatabaseUrl() {
        return Config.getRequiredProperty("bodybuilder.database.url");
    }

    public static String getDatabaseUser() {
        return Config.getRequiredProperty("bodybuilder.database.user");
    }

    public static String getDatabasePassword() {
        return Config.getRequiredProperty("bodybuilder.database.password");
    }

    public static Map getDataSetMap() {
        return Config.subMap("bodybuilder.database.dataset.");
    }

    public static String getProperty(String string) {
        String string2 = config.getProperty(string);
        return string2 != null ? string2.trim() : string2;
    }

    public static String getRequiredProperty(String string) {
        String string2 = Config.getProperty(string);
        if (string2 == null) {
            throw new BodyBuilderException("undefined property '" + string + "'.");
        }
        return string2;
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = Config.getProperty(string);
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    private static Map subMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator<Object> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            String string3 = Config.getProperty(string2);
            string2 = string2.substring(string.length());
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static Map newMap(String string, String string2, String string3) {
        String string4;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = Config.subMap(string);
        Iterator iterator = map.keySet().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string4 = ((String)object).substring(0, ((String)object).indexOf(46));
            hashSet.add(string4);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            string4 = (String)object.next();
            String[] stringArray = Config.getList((String)map.get(string4 + string2));
            String string5 = (String)map.get(string4 + string3);
            if (string5 == null) {
                throw new BodyBuilderException("undefined value corresponding to key '" + string + string4 + string2 + "'.");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], string5);
            }
        }
        return hashMap;
    }

    private static String[] getList(String string) {
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    private static void init() {
        config.clear();
        Config.load(DEFAULT_CONFIG_FILE_NAME, true);
        Config.load(CONFIG_FILE_NAME, false);
        config.putAll((Map<?, ?>)System.getProperties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void load(String string, boolean bl) {
        InputStream inputStream = null;
        try {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = (class$bodybuilder$util$Config == null ? (class$bodybuilder$util$Config = Config.class$("bodybuilder.util.Config")) : class$bodybuilder$util$Config).getClass().getClassLoader();
                }
                inputStream = classLoader.getResourceAsStream(string);
                if (bl && inputStream == null) {
                    throw new BodyBuilderException("cannot load '" + string + "' in CLASSPATH.");
                }
                if (inputStream != null) {
                    config.load(inputStream);
                }
            }
            catch (IOException iOException) {
                throw new BodyBuilderException("cannot load '" + string + "'.", iOException);
            }
            Object var5_5 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new BodyBuilderException("cannot close '" + string + "'.", iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new BodyBuilderException("cannot close '" + string + "'.", iOException);
        }
        inputStream.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Config.init();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new BodyBuilderException("failed to initialize '" + (class$bodybuilder$util$Config == null ? (class$bodybuilder$util$Config = Config.class$("bodybuilder.util.Config")) : class$bodybuilder$util$Config).getName() + "'.", throwable);
        }
    }
}

