/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.viewer;

import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.Utils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionViewer
extends Viewer {
    public void output(Object object, OutputHandler outputHandler) {
        Exception exception = (Exception)object;
        outputHandler.print(ObjectUtils.getInfo(object) + " {");
        outputHandler.indent();
        if (exception.getMessage() != null) {
            outputHandler.print("[message]=>");
            ExceptionViewer.dump(exception.getMessage(), outputHandler);
        }
        if (Config.isViewPrintStackTrace()) {
            String[] stringArray = Utils.decorate(this.getStackTrace(exception));
            outputHandler.print("[stacktrace]=>");
            for (int i = 0; i < stringArray.length; ++i) {
                outputHandler.print(stringArray[i]);
            }
        }
        if (exception.getCause() != null) {
            outputHandler.print("[cause]=>");
            ExceptionViewer.dump(exception.getCause(), outputHandler);
        }
        outputHandler.unindent();
        outputHandler.print("}");
    }

    private String[] getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        String string = stringWriter.toString();
        return Utils.toStringArray(string);
    }
}

