package sample.viewer.extension;

import sample.object.UserDefined2;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * ユーザ定義クラス２ビューア
 */
public class UserDefined2Viewer extends Viewer {

    /**
     * ユーザ定義クラス２の内容を出力する。
     * 
     * @param object ユーザ定義クラス
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // ユーザ定義クラス２にキャスト。
        UserDefined2 userDifined2 = (UserDefined2) object;
        // クラスの情報と開きカッコを出力。
        handler.print(ObjectUtils.getInfo(object) + " {");
        // 出力をインデント。
        handler.indent();

        // メッセージを出力。
        handler.print("[message]=>\"" + userDifined2.message() + "\"");
        // 値を出力。
        handler.print("[value]=>");
        // 値を再帰的にダンプ。
        dump(userDifined2.value(), handler);

        // 出力をアンインデント。
        handler.unindent();
        // 閉じカッコを出力。
        handler.print("}");
    }

}