package bodybuilder.builder;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.ObjectUtils;

/**
 * 例外ビルダー
 */
public class ExceptionBuilder extends Builder {

    /**
     * 例外のインスタンスを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return クラスのインスタンス
     */
    public Object getMuscle(Element element, Argument constructor) {
        // クラスを生成。
        String type = getRequiredType(element);
        Class clazz = ObjectUtils.getClass(type);

        // Exceptionのサブクラスでない場合はエラー。
        if (!ObjectUtils.instance_of(clazz, Exception.class)) {
            throw new BodyBuilderException("'" + element.getName()
                    + "' is not extending java.lang.Exception.");
        }

        // メッセージを取得。
        String message = element.getAttributeValue("message");

        Object exception = null;

        // 例外を生成
        if (message != null) {
            exception = ObjectUtils.getObject(message, clazz);
        } else {
            exception = newObject(clazz, constructor);
        }

        // オブジェクトを返す。
        return exception;
    }

}