package bodybuilder.builder.mock;

import java.lang.reflect.Proxy;
import java.util.List;
import org.jdom.Element;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.ObjectUtils;

/**
 * モックビルダー
 */
public class MockBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "method";

    /**
     * モックを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return モック
     */
    public Object getMuscle(Element element, Argument constructor) {
        // クラスを生成。
        String type = getRequiredType(element);
        Class clazz = ObjectUtils.getClass(type);

        // インターフェースではない場合は例外を投げる。
        if (!clazz.isInterface()) {
            return new BodyBuilderException("'" + clazz + "' is not interface.");
        }

        // ハンドラを生成。
        MockInvocationHandler handler = new MockInvocationHandler();

        // <method>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <method>からメソッド名と戻り値をハンドラに追加。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            String method = getRequiredName(child);
            Object ret = getValue(child);
            handler.regist(method, ret);
        }

        // モックを生成。
        return Proxy.newProxyInstance(clazz.getClassLoader(),
                new Class[] { clazz }, handler);
    }

}