package bodybuilder.inspector;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import bodybuilder.util.Config;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;

/**
 * ビーンインスペクター
 */
public class BeanInspector extends Inspector {

    /**
     * 二つのビーンが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // プロパティを取得。
        Map expectedProps = ExtendedPropertyUtils.getProperties(expected);
        Map actualProps = ExtendedPropertyUtils.getProperties(actual);

        // プロパティ名を検査。
        Set expectedNameSet = expectedProps.keySet();
        assertKeySetEquals(expectedNameSet, actualProps.keySet(), trace);
        Iterator names = expectedNameSet.iterator();

        // 検査しないプロパティのリストを取得。
        String type = expected.getClass().getName();
        String pkg = ObjectUtils.getPackage(type, true);
        Map ignores = Config.getIgnoreProperties();
        List ignoreProps = (List) ignores.get(type);

        if (ignoreProps == null) {
            ignoreProps = (List) ignores.get(pkg);
        }

        // プロパティ値を検査。
        while (names.hasNext()) {
            Object name = names.next();

            if (ignoreProps != null && ignoreProps.contains(name)) {
                continue;
            }

            trace.appendKey(name);
            Object expectedElement = expectedProps.get(name);
            Object actualElement = actualProps.get(name);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}