/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder.mock;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.mock.MockInvocationHandler;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.ObjectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jdom.Element;

public class MockBuilder
extends Builder {
    private static final String METHOD_NAME = "method";

    public MockBuilder() {
        this.hasConstructor = false;
    }

    public Object getMuscle(Element element, Argument constructor) {
        String type = MockBuilder.getRequiredType(element);
        Class clazz = ObjectUtils.getClass(type);
        if (!clazz.isInterface()) {
            return new BodyBuilderException("'" + clazz + "' is not interface.");
        }
        MockInvocationHandler handler = new MockInvocationHandler();
        List children = element.getChildren(METHOD_NAME);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String method = MockBuilder.getRequiredName(child);
            Object ret = MockBuilder.getValue(child);
            handler.regist(method, ret);
        }
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
    }
}

