/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.database;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.DbUnitUtils;
import bodybuilder.util.FileUtils;
import bodybuilder.util.jdom.JDOMUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class DatabaseAssertion {
    private String file = null;
    private String type = null;
    private Map ignore = null;
    static /* synthetic */ Class class$bodybuilder$test$database$DatabaseAssertion;

    public DatabaseAssertion(Element element, String baseDir) {
        this.file = JDOMUtils.getRequiredAttrValue(element, "file");
        if (!FileUtils.isFullPath(this.file)) {
            this.file = baseDir + File.separator + this.file;
        }
        this.type = element.getAttributeValue("type");
        if (this.type == null) {
            Map dataSetMap = Config.getDataSetMap();
            this.type = (String)dataSetMap.get(FileUtils.getExt(this.file));
        }
        this.ignore = this.buildIgnore(element);
    }

    public void assertDataSetEquals() {
        String driver = Config.getDatabaseDriver();
        String url = Config.getDatabaseUrl();
        String user = Config.getDatabaseUser();
        String password = Config.getDatabasePassword();
        DbUnitUtils utils = new DbUnitUtils(url, user, password);
        utils.assertDataSetEquals(this.file, this.type, this.ignore);
    }

    public String getFile() {
        return this.file;
    }

    public String getType() {
        return this.type;
    }

    public Map getIgnore() {
        return this.ignore;
    }

    private Map buildIgnore(Element element) {
        HashMap<String, String[]> ignore = new HashMap<String, String[]>();
        List children = element.getChildren("ignore");
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String table = JDOMUtils.getRequiredAttrValue(child, "table");
            String[] colmuns = JDOMUtils.getRequiredAttrValue(child, "columns").split(",");
            for (int j = 0; j < colmuns.length; ++j) {
                colmuns[j] = colmuns[j].trim().toUpperCase();
            }
            ignore.put(table.toUpperCase(), colmuns);
        }
        return ignore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DbUnitUtils.registerDriver(Config.getDatabaseDriver());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '" + (class$bodybuilder$test$database$DatabaseAssertion == null ? (class$bodybuilder$test$database$DatabaseAssertion = DatabaseAssertion.class$("bodybuilder.test.database.DatabaseAssertion")) : class$bodybuilder$test$database$DatabaseAssertion).getName() + "'.", e);
        }
    }
}

