/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.database.excel;

import java.math.BigDecimal;
import java.util.ArrayList;
import jxl.BooleanCell;
import jxl.BooleanFormulaCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.DateFormulaCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.Sheet;
import jxl.StringFormulaCell;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;

class YetAnotherXlsTable
extends AbstractTable {
    private final ITableMetaData _metaData;
    private final Sheet _sheet;

    public YetAnotherXlsTable(String sheetName, Sheet sheet) throws DataSetException {
        int rowCount = sheet.getRows();
        this._metaData = rowCount > 0 ? YetAnotherXlsTable.createMetaData(sheetName, sheet.getRow(0)) : new DefaultTableMetaData(sheetName, new Column[0]);
        this._sheet = sheet;
    }

    static ITableMetaData createMetaData(String tableName, Cell[] sampleRow) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int i = 0; i < sampleRow.length; ++i) {
            Cell cell = sampleRow[i];
            Column column = new Column(cell.getContents(), DataType.UNKNOWN);
            columnList.add(column);
        }
        Column[] columns = columnList.toArray(new Column[0]);
        return new DefaultTableMetaData(tableName, columns);
    }

    public int getRowCount() {
        return this._sheet.getRows() - 1;
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public Object getValue(int row, String column) throws DataSetException {
        Cell[] cells;
        this.assertValidRowIndex(row);
        if (row + 1 >= this._sheet.getRows()) {
            return null;
        }
        int columnIndex = this.getColumnIndex(column);
        if (columnIndex >= (cells = this._sheet.getRow(row + 1)).length) {
            return null;
        }
        Cell cell = cells[columnIndex];
        CellType type = cell.getType();
        if (type == CellType.NUMBER) {
            NumberCell number = (NumberCell)cell;
            return new BigDecimal(number.getValue());
        }
        if (type == CellType.NUMBER_FORMULA) {
            NumberFormulaCell numberFormula = (NumberFormulaCell)cell;
            return new BigDecimal(numberFormula.getValue());
        }
        if (type == CellType.LABEL) {
            LabelCell label = (LabelCell)cell;
            return label.getString();
        }
        if (type == CellType.STRING_FORMULA) {
            StringFormulaCell stringFormula = (StringFormulaCell)cell;
            return stringFormula.getString();
        }
        if (type == CellType.EMPTY) {
            return null;
        }
        if (type == CellType.BOOLEAN) {
            BooleanCell bool = (BooleanCell)cell;
            return bool.getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CellType.BOOLEAN_FORMULA) {
            BooleanFormulaCell booleanFormula = (BooleanFormulaCell)cell;
            return booleanFormula.getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CellType.DATE) {
            DateCell date = (DateCell)cell;
            return date.getDate();
        }
        if (type == CellType.DATE_FORMULA) {
            DateFormulaCell dateFormula = (DateFormulaCell)cell;
            return dateFormula.getDate();
        }
        if (type == CellType.ERROR) {
            throw new DataTypeException("Error at row=" + row + ", column=" + column);
        }
        throw new DataTypeException("Unsupported type at row=" + row + ", column=" + column);
    }
}

