package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.Bullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample04 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample04.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // 文字列バッファ
        Object string_buffer = bullworker.getMuscle("string_buffer");
        Viewer.dump(string_buffer);

        // 例外
        Object exception = bullworker.getMuscle("exception");
        Viewer.dump(exception);

        // ユーザ定義クラス
        Object user_defined = bullworker.getMuscle("user_defined");
        Viewer.dump(user_defined);
    }

}