package sample.inspector.extension;

import sample.object.UserDefined2;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;

/**
 * ユーザ定義オブジェクト２インスペクター
 */
public class UserDefined2Inspector extends Inspector {

    /**
     * 二つのユーザ定義オブジェクト２が等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // ユーザ定義オブジェクト２を取得。
        UserDefined2 expectedObj = (UserDefined2) expected;
        UserDefined2 actualObj = (UserDefined2) actual;

        // メッセージを検査。
        trace.appendKey("message");
        assertObjectEquals(expectedObj.message(), actualObj.message(), trace);

        // 値を検査。
        trace.appendKey("value");
        assertObjectEquals(expectedObj.value(), actualObj.value(), trace);
    }

}