package sample.testtarget.usually;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

import sample.testtarget.usually.constant.Sex;

/**
 * 住所管理クラス
 */
public class AddressManager {

    private String url = null;

    private String user = null;

    private String password = null;

    /**
     * コンストラクタ
     * 
     * @param driver JDBCドライバ名
     * @param url URL
     * @param user ユーザ
     * @param password パスワード
     */
    public AddressManager(String driver, String url, String user,
            String password) throws ClassNotFoundException {
        // ドライバをロード。
        Class.forName(driver);
        // プロパティをセット。
        this.url = url;
        this.user = user;
        this.password = password;
    }

    /**
     * アドレスを追加する。
     * 
     * @param id ID
     * @param name 氏名
     * @param age 年齢
     * @param sex 性別
     * @param zipCode 郵便番号
     * @param address 住所
     * @param tel 電話番号
     */
    public void append(String id, String name, int age, Sex sex,
            String zipCode, String address, String tel) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;

        try {
            // データベースに接続。
            conn = DriverManager.getConnection(url, user, password);
            conn.setAutoCommit(false);

            // ステートメントを生成。
            pstmt = conn.prepareStatement("INSERT INTO ADDRESS_BOOK VALUES "
                    + "(?, ?, ?, ?, ?, ?, ?, SYSDATE, SYSDATE)");

            // パラメータをセット。
            pstmt.setString(1, id);
            pstmt.setString(2, name);
            pstmt.setInt(3, age);
            pstmt.setString(4, sex.getValue());
            pstmt.setString(5, zipCode);
            pstmt.setString(6, address);
            pstmt.setString(7, tel);

            // SQLを発行。
            pstmt.executeUpdate();

            // コミット。
            conn.commit();
        } finally {
            // コネクションを切断。
            close(conn, pstmt);
        }
    }

    /**
     * データベースに接続する。
     * 
     * @return コネクション
     */
    private Connection connect() throws SQLException {
        // データベースに接続。
        Connection conn = DriverManager.getConnection(url, user, password);
        conn.setAutoCommit(false);
        return conn;
    }

    /**
     * リソースをクローズする。
     * 
     * @param conn コネクション
     * @param stmt ステートメント
     */
    private void close(Connection conn, Statement stmt) throws SQLException {
        // ステートメントをクローズ。
        if (stmt != null)
            stmt.close();

        // コネクションをクローズ。
        if (conn != null) {
            conn.rollback();
            conn.close();
        }
    }

}