package bodybuilder.builder.servlet;

import java.util.List;
import org.jdom.Element;

import com.mockrunner.mock.web.MockHttpSession;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * セッションビルダー
 */
public class SessionBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * セッションを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return セッション
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックセッションを生成。
        MockHttpSession session = new MockHttpSession();

        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をセッションにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            session.setAttribute(name, value);
        }

        // セッションを返す。
        return session;
    }

}