package bodybuilder.test.usually;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.common.Target;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.util.ObjectUtils;

/**
 * 汎用XMLテストケース
 */
public class UsualTestCase extends XMLTestCase {

    /**
     * 汎用XMLテストケース
     */
    protected UsualTestCaseXML xml = null;

    /**
     * 汎用XMLテストケースXMLをセットする。
     */
    protected void setXML(TestCaseXML xml) {
        this.xml = (UsualTestCaseXML) xml;
    }

    /**
     * テストを実行する。
     */
    protected void runTest() {
        info("'" + getName() + "' is started.");
        debug("description is:\n" + xml.getDescription());

        // ターゲットを取得。
        Target target = xml.getTarget();
        debug("target is '" + target.getName() + "'.");

        // データベースセットアップを取得。
        DatabaseSetUp databaseSetUp = xml.getDatabaseSetUp();

        if (databaseSetUp != null) {
            debug("set up database by '" + databaseSetUp.getFile() + "'.");
            databaseSetUp.setUp();
        }

        // 実行するメソッドを取得。
        Execute execute = xml.getExecute();
        String methodName = execute.getMethod();
        Argument argument = execute.getArgument();
        debug("invoked method is '" + methodName + "' as '" + target.getName()
                + "'.");

        Class clazz = ObjectUtils.getClass(target.getName());
        Method method = ObjectUtils.getMethod(clazz, methodName, argument
                .getClasses());
        Object object = null;

        // スタティックメソッドではない場合はインスタンスを生成。
        if (!ObjectUtils.isStaticMethod(method)) {
            Argument constructor = target.getConstructor();
            object = ObjectUtils.getInstance(target.getName(), constructor
                    .getClasses(), constructor.getArguments());
        }

        Object actualReturn = null;
        Throwable cause = null;

        // メソッドを実行。
        try {
            actualReturn = ObjectUtils.invokeMethod(clazz, object, method,
                    argument.getArguments());
        } catch (BodyBuilderException e) {
            // メソッドの例外ではない場合は上位に投げる。
            if (!(e.getCause() instanceof InvocationTargetException)) {
                throw e;
            }

            // メソッドの例外を取得。
            cause = e.getCause().getCause();
            debug("'" + cause + "' was catched.");
        }

        debug("'" + method + "' was invoked.");

        // 例外を検査。
        Catch expectedCatch = xml.getCatch();

        if (expectedCatch != null
                && ObjectUtils.instance_of(cause, expectedCatch.getType())) {
            debug("verify catched exception.");
            Inspector.assertObjectEquals(expectedCatch.getException(), cause);
            debug("catched exception value was corrected.");
        } else if (expectedCatch != null) {
            // 例外を検査しない場合は上位に投げる。
            throw new BodyBuilderException("unexpected exception '" + cause
                    + "' but was '" + expectedCatch.getType() + "'.", cause);
        } else if (cause != null) {
            // 例外を検査しない場合は上位に投げる。
            throw new BodyBuilderException("unexpected exception '" + cause
                    + "'.", cause);
        }

        // 戻り値を検査。
        Return expectedReturn = xml.getReturn();

        if (expectedReturn != null) {
            debug("verify return value.");
            Inspector.assertObjectEquals(expectedReturn.getValue(),
                    actualReturn);
            debug("return value was corrected.");
        }

        // データベースを検査。
        DatabaseAssertion databaseAssertion = xml.getDatabaseAssertion();

        if (databaseSetUp != null) {
            debug("verify database by '" + databaseAssertion.getFile() + "'.");
            databaseAssertion.assertDataSetEquals();
            debug("database was corrected.");
        }

        info("test was ended.");
    }

}